/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.grpc;

import com.google.cloud.grpc.GcpManagedChannel;
import com.google.cloud.grpc.GcpManagedChannelOptions;
import com.google.cloud.grpc.GcpMetricsConstants;
import com.google.cloud.grpc.GcpMultiEndpointOptions;
import com.google.cloud.grpc.multiendpoint.MultiEndpoint;
import com.google.cloud.grpc.proto.ApiConfig;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.grpc.CallOptions;
import io.grpc.ChannelCredentials;
import io.grpc.ClientCall;
import io.grpc.ConnectivityState;
import io.grpc.Context;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.MethodDescriptor;
import io.opencensus.metrics.DerivedLongCumulative;
import io.opencensus.metrics.DerivedLongGauge;
import io.opencensus.metrics.LabelKey;
import io.opencensus.metrics.LabelValue;
import io.opencensus.metrics.MetricOptions;
import io.opencensus.metrics.MetricRegistry;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class GcpMultiEndpointChannel
extends ManagedChannel {
    private static final Logger logger = Logger.getLogger(GcpMultiEndpointChannel.class.getName());
    public static final CallOptions.Key<String> ME_KEY = CallOptions.Key.create((String)"MultiEndpoint");
    public static final Context.Key<String> ME_CONTEXT_KEY = Context.key((String)"MultiEndpoint");
    private final LabelKey endpointKey = LabelKey.create((String)GcpMetricsConstants.ENDPOINT_LABEL, (String)GcpMetricsConstants.ENDPOINT_LABEL_DESC);
    private final Map<String, MultiEndpoint> multiEndpoints = new ConcurrentHashMap<String, MultiEndpoint>();
    private MultiEndpoint defaultMultiEndpoint;
    private final ApiConfig apiConfig;
    private final GcpManagedChannelOptions gcpManagedChannelOptions;
    private final GcpManagedChannelOptions.GcpMetricsOptions gcpMetricsOptions;
    private DerivedLongGauge endpointStateMetric;
    private DerivedLongCumulative endpointSwitchMetric;
    private DerivedLongGauge currentEndpointMetric;
    private final Map<String, CurrentEndpointWatcher> currentEndpointWatchers = new ConcurrentHashMap<String, CurrentEndpointWatcher>();
    private final Map<String, GcpManagedChannel> pools = new ConcurrentHashMap<String, GcpManagedChannel>();
    @GuardedBy(value="this")
    private final Set<String> currentEndpoints = new HashSet<String>();
    private final ScheduledExecutorService executor = new ScheduledThreadPoolExecutor(1);

    public GcpMultiEndpointChannel(List<GcpMultiEndpointOptions> meOptions, ApiConfig apiConfig, GcpManagedChannelOptions gcpManagedChannelOptions) {
        this.apiConfig = apiConfig;
        this.gcpManagedChannelOptions = gcpManagedChannelOptions;
        this.gcpMetricsOptions = gcpManagedChannelOptions.getMetricsOptions();
        this.createMetrics();
        this.setMultiEndpoints(meOptions);
    }

    private ConnectivityState checkPoolState(ManagedChannel channel, String endpoint) {
        ConnectivityState state = channel.getState(false);
        for (MultiEndpoint me : this.multiEndpoints.values()) {
            me.setEndpointAvailable(endpoint, state.equals((Object)ConnectivityState.READY));
        }
        return state;
    }

    private GcpManagedChannelOptions prepareGcpManagedChannelConfig(GcpManagedChannelOptions gcpOptions, String endpoint) {
        GcpManagedChannelOptions.GcpMetricsOptions.Builder metricsOptions = GcpManagedChannelOptions.GcpMetricsOptions.newBuilder(gcpOptions.getMetricsOptions());
        ArrayList<LabelKey> labelKeys = new ArrayList<LabelKey>(metricsOptions.build().getLabelKeys());
        ArrayList<LabelValue> labelValues = new ArrayList<LabelValue>(metricsOptions.build().getLabelValues());
        labelKeys.add(this.endpointKey);
        labelValues.add(LabelValue.create((String)endpoint));
        GcpManagedChannelOptions.GcpChannelPoolOptions.Builder poolOptions = GcpManagedChannelOptions.GcpChannelPoolOptions.newBuilder(gcpOptions.getChannelPoolOptions());
        if (poolOptions.build().getMinSize() < 1) {
            int minSize = Math.min(2, poolOptions.build().getMaxSize());
            minSize = Math.max(minSize, (int)Math.sqrt(poolOptions.build().getMaxSize()));
            poolOptions.setMinSize(minSize);
        }
        return GcpManagedChannelOptions.newBuilder(gcpOptions).withChannelPoolOptions(poolOptions.build()).withMetricsOptions(metricsOptions.withLabels(labelKeys, labelValues).build()).build();
    }

    private ManagedChannelBuilder<?> channelBuilderForEndpoint(String endpoint) {
        String serviceAddress;
        int port = 443;
        try {
            URL url = new URL(endpoint);
            serviceAddress = url.getHost();
            port = url.getPort() < 0 ? url.getDefaultPort() : url.getPort();
        }
        catch (MalformedURLException ex) {
            int colon = endpoint.lastIndexOf(58);
            if (colon < 0) {
                serviceAddress = endpoint;
            }
            serviceAddress = endpoint.substring(0, colon);
            port = Integer.parseInt(endpoint.substring(colon + 1));
        }
        return ManagedChannelBuilder.forAddress((String)serviceAddress, (int)port);
    }

    private void setUpMetricsForMultiEndpoint(GcpMultiEndpointOptions options, MultiEndpoint me) {
        String name = options.getName();
        List<String> endpoints = options.getEndpoints();
        this.endpointSwitchMetric.createTimeSeries(this.appendCommonValues(LabelValue.create((String)name), LabelValue.create((String)GcpMetricsConstants.TYPE_FALLBACK)), (Object)me, MultiEndpoint::getFallbackCnt);
        this.endpointSwitchMetric.createTimeSeries(this.appendCommonValues(LabelValue.create((String)name), LabelValue.create((String)GcpMetricsConstants.TYPE_RECOVER)), (Object)me, MultiEndpoint::getRecoverCnt);
        this.endpointSwitchMetric.createTimeSeries(this.appendCommonValues(LabelValue.create((String)name), LabelValue.create((String)GcpMetricsConstants.TYPE_REPLACE)), (Object)me, MultiEndpoint::getReplaceCnt);
        for (String e : endpoints) {
            CurrentEndpointWatcher watcher = new CurrentEndpointWatcher(me, e);
            this.currentEndpointWatchers.put(name + ":" + e, watcher);
            this.currentEndpointMetric.createTimeSeries(this.appendCommonValues(LabelValue.create((String)name), LabelValue.create((String)e)), (Object)watcher, CurrentEndpointWatcher::getMetricValue);
        }
    }

    private void updateMetricsForMultiEndpoint(GcpMultiEndpointOptions options, MultiEndpoint me) {
        HashSet<String> newEndpoints = new HashSet<String>(options.getEndpoints());
        HashSet<String> existingEndpoints = new HashSet<String>(me.getEndpoints());
        for (String e : existingEndpoints) {
            if (newEndpoints.contains(e)) continue;
            this.currentEndpointMetric.removeTimeSeries(this.appendCommonValues(LabelValue.create((String)options.getName()), LabelValue.create((String)e)));
            this.currentEndpointWatchers.remove(options.getName() + ":" + e);
        }
        for (String e : newEndpoints) {
            if (existingEndpoints.contains(e)) continue;
            CurrentEndpointWatcher watcher = new CurrentEndpointWatcher(me, e);
            this.currentEndpointWatchers.put(options.getName() + ":" + e, watcher);
            this.currentEndpointMetric.createTimeSeries(this.appendCommonValues(LabelValue.create((String)options.getName()), LabelValue.create((String)e)), (Object)watcher, CurrentEndpointWatcher::getMetricValue);
        }
    }

    private void removeMetricsForMultiEndpoint(String name, MultiEndpoint me) {
        this.endpointSwitchMetric.removeTimeSeries(this.appendCommonValues(LabelValue.create((String)name), LabelValue.create((String)GcpMetricsConstants.TYPE_FALLBACK)));
        this.endpointSwitchMetric.removeTimeSeries(this.appendCommonValues(LabelValue.create((String)name), LabelValue.create((String)GcpMetricsConstants.TYPE_RECOVER)));
        this.endpointSwitchMetric.removeTimeSeries(this.appendCommonValues(LabelValue.create((String)name), LabelValue.create((String)GcpMetricsConstants.TYPE_REPLACE)));
        for (String e : me.getEndpoints()) {
            this.currentEndpointMetric.removeTimeSeries(this.appendCommonValues(LabelValue.create((String)name), LabelValue.create((String)e)));
            this.currentEndpointWatchers.remove(name + ":" + e);
        }
    }

    public synchronized void setMultiEndpoints(List<GcpMultiEndpointOptions> meOptions) {
        Preconditions.checkNotNull(meOptions);
        Preconditions.checkArgument((!meOptions.isEmpty() ? 1 : 0) != 0, (Object)"MultiEndpoints list is empty");
        HashSet currentMultiEndpoints = new HashSet();
        meOptions.forEach(options -> {
            currentMultiEndpoints.add(options.getName());
            MultiEndpoint existingMe = this.multiEndpoints.get(options.getName());
            if (existingMe != null) {
                this.updateMetricsForMultiEndpoint((GcpMultiEndpointOptions)options, existingMe);
                existingMe.setEndpoints(options.getEndpoints());
            } else {
                MultiEndpoint me = new MultiEndpoint.Builder(options.getEndpoints()).withRecoveryTimeout(options.getRecoveryTimeout()).withSwitchingDelay(options.getSwitchingDelay()).build();
                this.setUpMetricsForMultiEndpoint((GcpMultiEndpointOptions)options, me);
                this.multiEndpoints.put(options.getName(), me);
            }
        });
        HashSet<String> existingPools = new HashSet<String>(this.pools.keySet());
        this.currentEndpoints.clear();
        meOptions.forEach(options -> options.getEndpoints().forEach(endpoint -> {
            this.currentEndpoints.add((String)endpoint);
            this.pools.computeIfAbsent((String)endpoint, e -> {
                ManagedChannelBuilder managedChannelBuilder = options.getChannelCredentials() != null ? Grpc.newChannelBuilder((String)e, (ChannelCredentials)options.getChannelCredentials()) : this.channelBuilderForEndpoint((String)e);
                if (options.getChannelConfigurator() != null) {
                    managedChannelBuilder = (ManagedChannelBuilder)options.getChannelConfigurator().apply((Object)managedChannelBuilder);
                }
                GcpManagedChannel channel = new GcpManagedChannel(managedChannelBuilder, this.apiConfig, this.prepareGcpManagedChannelConfig(this.gcpManagedChannelOptions, (String)e));
                new EndpointStateMonitor(channel, (String)e);
                return channel;
            });
        }));
        existingPools.retainAll(this.currentEndpoints);
        existingPools.forEach(e -> this.checkPoolState(this.pools.get(e), (String)e));
        this.defaultMultiEndpoint = this.multiEndpoints.get(meOptions.get(0).getName());
        Iterator<String> iter = this.multiEndpoints.keySet().iterator();
        while (iter.hasNext()) {
            String name = iter.next();
            if (currentMultiEndpoints.contains(name)) continue;
            this.removeMetricsForMultiEndpoint(name, this.multiEndpoints.get(name));
            iter.remove();
        }
        HashSet<String> poolsToRemove = new HashSet<String>(this.pools.keySet());
        poolsToRemove.removeIf(this.currentEndpoints::contains);
        if (!poolsToRemove.isEmpty()) {
            Optional<Duration> maxDelay = meOptions.stream().map(GcpMultiEndpointOptions::getSwitchingDelay).max(Comparator.naturalOrder());
            if (maxDelay.isPresent() && maxDelay.get().toMillis() > 0L) {
                this.executor.schedule(() -> this.maybeCleanupPools(poolsToRemove), maxDelay.get().toMillis(), TimeUnit.MILLISECONDS);
            } else {
                this.maybeCleanupPools(poolsToRemove);
            }
        }
    }

    private synchronized void maybeCleanupPools(Set<String> endpoints) {
        for (String endpoint : endpoints) {
            if (this.currentEndpoints.contains(endpoint)) continue;
            this.pools.get(endpoint).shutdown();
            this.pools.remove(endpoint);
        }
    }

    private void createMetrics() {
        if (this.gcpMetricsOptions == null) {
            return;
        }
        MetricRegistry metricRegistry = this.gcpMetricsOptions.getMetricRegistry();
        if (metricRegistry == null) {
            return;
        }
        if (this.endpointStateMetric != null) {
            return;
        }
        String prefix = this.gcpMetricsOptions.getNamePrefix();
        this.endpointStateMetric = metricRegistry.addDerivedLongGauge(prefix + GcpMetricsConstants.METRIC_ENDPOINT_STATE, this.createMetricOptions("Reports 1 when endpoint is in the status.", "1", LabelKey.create((String)GcpMetricsConstants.ENDPOINT_LABEL, (String)GcpMetricsConstants.ENDPOINT_LABEL_DESC), LabelKey.create((String)GcpMetricsConstants.STATUS_LABEL, (String)GcpMetricsConstants.STATUS_LABEL_DESC)));
        this.endpointSwitchMetric = metricRegistry.addDerivedLongCumulative(prefix + GcpMetricsConstants.METRIC_ENDPOINT_SWITCH, this.createMetricOptions("Reports occurrences of changes of current endpoint for a multi-endpoint with the name, specifying change type.", "1", LabelKey.create((String)GcpMetricsConstants.ME_NAME_LABEL, (String)GcpMetricsConstants.ME_NAME_LABEL_DESC), LabelKey.create((String)GcpMetricsConstants.SWITCH_TYPE_LABEL, (String)GcpMetricsConstants.SWITCH_TYPE_LABEL_DESC)));
        this.currentEndpointMetric = metricRegistry.addDerivedLongGauge(prefix + GcpMetricsConstants.METRIC_CURRENT_ENDPOINT, this.createMetricOptions("Reports 1 when an endpoint is current for multi-endpoint with the name.", "1", LabelKey.create((String)GcpMetricsConstants.ME_NAME_LABEL, (String)GcpMetricsConstants.ME_NAME_LABEL_DESC), LabelKey.create((String)GcpMetricsConstants.ENDPOINT_LABEL, (String)GcpMetricsConstants.ENDPOINT_LABEL_DESC)));
    }

    private List<LabelValue> appendCommonValues(LabelValue ... labelValues) {
        ArrayList<LabelValue> values = new ArrayList<LabelValue>();
        Collections.addAll(values, labelValues);
        if (this.gcpMetricsOptions != null && this.gcpMetricsOptions.getLabelValues() != null) {
            values.addAll(this.gcpMetricsOptions.getLabelValues());
        }
        return values;
    }

    private MetricOptions createMetricOptions(String description, String unit, LabelKey ... labelKeys) {
        ArrayList<LabelKey> keys = new ArrayList<LabelKey>();
        Collections.addAll(keys, labelKeys);
        if (this.gcpMetricsOptions != null && this.gcpMetricsOptions.getLabelKeys() != null) {
            keys.addAll(this.gcpMetricsOptions.getLabelKeys());
        }
        return MetricOptions.builder().setDescription(description).setLabelKeys(keys).setUnit(unit).build();
    }

    @CanIgnoreReturnValue
    public ManagedChannel shutdown() {
        this.pools.values().forEach(GcpManagedChannel::shutdown);
        return this;
    }

    public boolean isShutdown() {
        return this.pools.values().stream().allMatch(GcpManagedChannel::isShutdown);
    }

    public boolean isTerminated() {
        return this.pools.values().stream().allMatch(GcpManagedChannel::isTerminated);
    }

    @CanIgnoreReturnValue
    public ManagedChannel shutdownNow() {
        this.pools.values().forEach(GcpManagedChannel::shutdownNow);
        return this;
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long endTimeNanos = System.nanoTime() + unit.toNanos(timeout);
        for (GcpManagedChannel gcpManagedChannel : this.pools.values()) {
            if (gcpManagedChannel.isTerminated()) continue;
            long awaitTimeNanos = endTimeNanos - System.nanoTime();
            if (awaitTimeNanos <= 0L) break;
            gcpManagedChannel.awaitTermination(awaitTimeNanos, TimeUnit.NANOSECONDS);
        }
        return this.isTerminated();
    }

    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        String multiEndpointKey = (String)callOptions.getOption(ME_KEY);
        if (multiEndpointKey == null) {
            multiEndpointKey = (String)ME_CONTEXT_KEY.get(Context.current());
        }
        MultiEndpoint me = this.defaultMultiEndpoint;
        if (multiEndpointKey != null) {
            me = this.multiEndpoints.getOrDefault(multiEndpointKey, this.defaultMultiEndpoint);
        }
        return this.pools.get(me.getCurrentId()).newCall(methodDescriptor, callOptions);
    }

    public String authority() {
        return this.pools.get(this.defaultMultiEndpoint.getCurrentId()).authority();
    }

    public String authorityFor(String multiEndpointName) {
        MultiEndpoint multiEndpoint = this.multiEndpoints.get(multiEndpointName);
        if (multiEndpoint == null) {
            return null;
        }
        return this.pools.get(multiEndpoint.getCurrentId()).authority();
    }

    private static class CurrentEndpointWatcher {
        private final MultiEndpoint me;
        private final String endpoint;

        public CurrentEndpointWatcher(MultiEndpoint me, String endpoint) {
            this.me = me;
            this.endpoint = endpoint;
        }

        public long getMetricValue() {
            return this.endpoint.equals(this.me.getCurrentId()) ? 1L : 0L;
        }
    }

    private class EndpointStateMonitor
    implements Runnable {
        private final ManagedChannel channel;
        private final String endpoint;
        private ConnectivityState currentState;

        private EndpointStateMonitor(ManagedChannel channel, String endpoint) {
            this.endpoint = endpoint;
            this.channel = channel;
            this.setUpMetrics();
            this.run();
        }

        private void setUpMetrics() {
            if (GcpMultiEndpointChannel.this.endpointStateMetric == null) {
                return;
            }
            GcpMultiEndpointChannel.this.endpointStateMetric.createTimeSeries(GcpMultiEndpointChannel.this.appendCommonValues(new LabelValue[]{LabelValue.create((String)this.endpoint), LabelValue.create((String)GcpMetricsConstants.STATUS_AVAILABLE)}), (Object)this, EndpointStateMonitor::reportAvailable);
            GcpMultiEndpointChannel.this.endpointStateMetric.createTimeSeries(GcpMultiEndpointChannel.this.appendCommonValues(new LabelValue[]{LabelValue.create((String)this.endpoint), LabelValue.create((String)GcpMetricsConstants.STATUS_UNAVAILABLE)}), (Object)this, EndpointStateMonitor::reportUnavailable);
        }

        private void removeMetrics() {
            if (GcpMultiEndpointChannel.this.endpointStateMetric == null) {
                return;
            }
            GcpMultiEndpointChannel.this.endpointStateMetric.removeTimeSeries(GcpMultiEndpointChannel.this.appendCommonValues(new LabelValue[]{LabelValue.create((String)this.endpoint), LabelValue.create((String)GcpMetricsConstants.STATUS_AVAILABLE)}));
            GcpMultiEndpointChannel.this.endpointStateMetric.removeTimeSeries(GcpMultiEndpointChannel.this.appendCommonValues(new LabelValue[]{LabelValue.create((String)this.endpoint), LabelValue.create((String)GcpMetricsConstants.STATUS_UNAVAILABLE)}));
        }

        private long reportAvailable() {
            return ConnectivityState.READY.equals((Object)this.currentState) ? 1L : 0L;
        }

        private long reportUnavailable() {
            return ConnectivityState.READY.equals((Object)this.currentState) ? 0L : 1L;
        }

        @Override
        public void run() {
            if (this.channel == null) {
                this.removeMetrics();
                return;
            }
            this.currentState = GcpMultiEndpointChannel.this.checkPoolState(this.channel, this.endpoint);
            if (this.currentState != ConnectivityState.SHUTDOWN) {
                this.channel.notifyWhenStateChanged(this.currentState, (Runnable)this);
            } else {
                this.removeMetrics();
            }
        }
    }
}

