/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.auth.Credentials;
import com.google.cloud.opentelemetry.detection.DetectedPlatform;
import com.google.cloud.opentelemetry.detection.GCPPlatformDetector;
import com.google.cloud.spanner.BuiltInMetricsConstant;
import com.google.cloud.spanner.BuiltInOpenTelemetryMetricsView;
import com.google.cloud.spanner.SpannerCloudMonitoringExporter;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class BuiltInOpenTelemetryMetricsProvider {
    static BuiltInOpenTelemetryMetricsProvider INSTANCE = new BuiltInOpenTelemetryMetricsProvider();
    private static final Logger logger = Logger.getLogger(BuiltInOpenTelemetryMetricsProvider.class.getName());
    private static String taskId;
    private OpenTelemetry openTelemetry;

    private BuiltInOpenTelemetryMetricsProvider() {
    }

    OpenTelemetry getOrCreateOpenTelemetry(String projectId, @Nullable Credentials credentials) {
        try {
            if (this.openTelemetry == null) {
                SdkMeterProviderBuilder sdkMeterProviderBuilder = SdkMeterProvider.builder();
                BuiltInOpenTelemetryMetricsView.registerBuiltinMetrics(SpannerCloudMonitoringExporter.create(projectId, credentials), sdkMeterProviderBuilder);
                this.openTelemetry = OpenTelemetrySdk.builder().setMeterProvider(sdkMeterProviderBuilder.build()).build();
            }
            return this.openTelemetry;
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Unable to get OpenTelemetry object for client side metrics, will skip exporting client side metrics", ex);
            return null;
        }
    }

    Map<String, String> createClientAttributes(String projectId, String client_name) {
        HashMap<String, String> clientAttributes = new HashMap<String, String>();
        clientAttributes.put(BuiltInMetricsConstant.LOCATION_ID_KEY.getKey(), BuiltInOpenTelemetryMetricsProvider.detectClientLocation());
        clientAttributes.put(BuiltInMetricsConstant.PROJECT_ID_KEY.getKey(), projectId);
        clientAttributes.put(BuiltInMetricsConstant.INSTANCE_CONFIG_ID_KEY.getKey(), "unknown");
        clientAttributes.put(BuiltInMetricsConstant.CLIENT_NAME_KEY.getKey(), client_name);
        clientAttributes.put(BuiltInMetricsConstant.CLIENT_UID_KEY.getKey(), BuiltInOpenTelemetryMetricsProvider.getDefaultTaskValue());
        clientAttributes.put(BuiltInMetricsConstant.CLIENT_HASH_KEY.getKey(), "cloud_spanner_client_raw_metrics");
        return clientAttributes;
    }

    static String detectClientLocation() {
        GCPPlatformDetector detector = GCPPlatformDetector.DEFAULT_INSTANCE;
        DetectedPlatform detectedPlatform = detector.detectPlatform();
        String region = (String)detectedPlatform.getAttributes().get("cloud_region");
        if (detectedPlatform.getSupportedPlatform() == GCPPlatformDetector.SupportedPlatform.GOOGLE_KUBERNETES_ENGINE) {
            region = (String)detectedPlatform.getAttributes().get("REGION");
        }
        return region == null ? "global" : region;
    }

    private static String getDefaultTaskValue() {
        if (taskId == null) {
            String identifier = UUID.randomUUID().toString();
            String pid = BuiltInOpenTelemetryMetricsProvider.getProcessId();
            try {
                String hostname = InetAddress.getLocalHost().getHostName();
                taskId = identifier + "@" + pid + "@" + hostname;
            }
            catch (UnknownHostException e) {
                logger.log(Level.INFO, "Unable to get the hostname.", e);
                taskId = identifier + "@" + pid + "@localhost";
            }
        }
        return taskId;
    }

    private static String getProcessId() {
        try {
            Class<?> processHandleClass = Class.forName("java.lang.ProcessHandle");
            Method currentMethod = processHandleClass.getMethod("current", new Class[0]);
            Object processHandleInstance = currentMethod.invoke(null, new Object[0]);
            Method pidMethod = processHandleClass.getMethod("pid", new Class[0]);
            long pid = (Long)pidMethod.invoke(processHandleInstance, new Object[0]);
            return Long.toString(pid);
        }
        catch (Exception e) {
            String jvmName = ManagementFactory.getRuntimeMXBean().getName();
            if (jvmName != null && jvmName.contains("@")) {
                return jvmName.split("@")[0];
            }
            return "unknown";
        }
    }
}

