/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.Tuple;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.connection.SimpleParser;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.spanner.v1.RequestOptions;
import java.util.Locale;
import java.util.Map;

class StatementHintParser {
    private static final char[] GOOGLE_SQL_START_HINT_TOKENS = new char[]{'@', '{'};
    private static final char[] POSTGRESQL_START_HINT_TOKENS = new char[]{'/', '*', '@'};
    private static final char[] GOOGLE_SQL_END_HINT_TOKENS = new char[]{'}'};
    private static final char[] POSTGRESQL_END_HINT_TOKENS = new char[]{'*', '/'};
    private static final String STATEMENT_TAG_HINT_NAME = "STATEMENT_TAG";
    private static final String RPC_PRIORITY_HINT_NAME = "RPC_PRIORITY";
    private static final ImmutableSet<String> CLIENT_SIDE_STATEMENT_HINT_NAMES = ImmutableSet.of((Object)"STATEMENT_TAG", (Object)"RPC_PRIORITY");
    static final Map<String, String> NO_HINTS = ImmutableMap.of();
    private final boolean hasStatementHints;
    private final Map<String, String> hints;
    private final String sqlWithoutClientSideHints;

    StatementHintParser(Dialect dialect, String sql) {
        this(CLIENT_SIDE_STATEMENT_HINT_NAMES, dialect, sql);
    }

    StatementHintParser(ImmutableSet<String> clientSideStatementHintNames, Dialect dialect, String sql) {
        SimpleParser parser = new SimpleParser(dialect, sql, 0, dialect == Dialect.POSTGRESQL);
        this.hasStatementHints = parser.peekTokens(StatementHintParser.getStartHintTokens(dialect));
        if (this.hasStatementHints) {
            Tuple<String, Map<String, String>> hints = StatementHintParser.extract(parser, clientSideStatementHintNames);
            this.sqlWithoutClientSideHints = (String)hints.x();
            this.hints = (Map)hints.y();
        } else {
            this.sqlWithoutClientSideHints = sql;
            this.hints = NO_HINTS;
        }
    }

    private static char[] getStartHintTokens(Dialect dialect) {
        switch (dialect) {
            case POSTGRESQL: {
                return POSTGRESQL_START_HINT_TOKENS;
            }
        }
        return GOOGLE_SQL_START_HINT_TOKENS;
    }

    private static char[] getEndHintTokens(Dialect dialect) {
        switch (dialect) {
            case POSTGRESQL: {
                return POSTGRESQL_END_HINT_TOKENS;
            }
        }
        return GOOGLE_SQL_END_HINT_TOKENS;
    }

    static Options.ReadQueryUpdateTransactionOption[] convertHintsToOptions(Map<String, String> hints) {
        Options.ReadQueryUpdateTransactionOption[] result = new Options.ReadQueryUpdateTransactionOption[hints.size()];
        int index = 0;
        for (Map.Entry<String, String> hint : hints.entrySet()) {
            result[index++] = StatementHintParser.convertHintToOption(hint.getKey(), hint.getValue());
        }
        return result;
    }

    private static Options.ReadQueryUpdateTransactionOption convertHintToOption(String hint, String value) {
        Preconditions.checkNotNull((Object)value);
        switch (((String)Preconditions.checkNotNull((Object)hint)).toUpperCase(Locale.ENGLISH)) {
            case "STATEMENT_TAG": {
                return Options.tag(value);
            }
            case "RPC_PRIORITY": {
                try {
                    RequestOptions.Priority priority = RequestOptions.Priority.valueOf((String)value);
                    return Options.priority(Options.RpcPriority.fromProto(priority));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Invalid RPC priority value: " + value, illegalArgumentException);
                }
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Invalid hint name: " + hint);
    }

    boolean hasStatementHints() {
        return this.hasStatementHints;
    }

    String getSqlWithoutClientSideHints() {
        return this.sqlWithoutClientSideHints;
    }

    Map<String, String> getClientSideStatementHints() {
        return this.hints;
    }

    private static Tuple<String, Map<String, String>> extract(SimpleParser parser, ImmutableSet<String> clientSideStatementHintNames) {
        String updatedSql = parser.getSql();
        int posBeforeHintToken = parser.getPos();
        int removedHintsLength = 0;
        boolean allClientSideHints = true;
        parser.eatTokens(StatementHintParser.getStartHintTokens(parser.getDialect()));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        while (parser.hasMoreTokens()) {
            int posBeforeHint = parser.getPos();
            boolean foundClientSideHint = false;
            SimpleParser.Result hintName = parser.eatIdentifier();
            if (!hintName.isValid()) {
                return Tuple.of((Object)parser.getSql(), NO_HINTS);
            }
            if (!parser.eatToken('=')) {
                return Tuple.of((Object)parser.getSql(), NO_HINTS);
            }
            SimpleParser.Result hintValue = StatementHintParser.eatHintLiteral(parser);
            if (!hintValue.isValid()) {
                return Tuple.of((Object)parser.getSql(), NO_HINTS);
            }
            if (clientSideStatementHintNames.contains((Object)hintName.getValue().toUpperCase(Locale.ENGLISH))) {
                builder.put((Object)hintName.getValue(), (Object)hintValue.getValue());
                foundClientSideHint = true;
            } else {
                allClientSideHints = false;
            }
            boolean endOfHints = parser.peekTokens(StatementHintParser.getEndHintTokens(parser.getDialect()));
            if (!endOfHints && !parser.eatToken(',')) {
                return Tuple.of((Object)parser.getSql(), NO_HINTS);
            }
            if (foundClientSideHint) {
                updatedSql = updatedSql.substring(0, posBeforeHint - removedHintsLength) + parser.getSql().substring(parser.getPos());
                removedHintsLength += parser.getPos() - posBeforeHint;
            }
            if (!endOfHints) continue;
            break;
        }
        if (!parser.eatTokens(StatementHintParser.getEndHintTokens(parser.getDialect()))) {
            return Tuple.of((Object)parser.getSql(), NO_HINTS);
        }
        if (allClientSideHints) {
            updatedSql = parser.getSql().substring(0, posBeforeHintToken) + parser.getSql().substring(parser.getPos());
        }
        return Tuple.of((Object)updatedSql, (Object)builder.build());
    }

    private static SimpleParser.Result eatHintLiteral(SimpleParser parser) {
        if (parser.peekToken('\'')) {
            return parser.eatSingleQuotedString();
        }
        return parser.eatIdentifier();
    }
}

