/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.cloud.spanner.persistence;

import io.jans.orm.cloud.spanner.impl.SpannerEntryManager;
import io.jans.orm.cloud.spanner.impl.SpannerEntryManagerFactory;
import java.util.Properties;
import org.apache.log4j.Logger;

public class SpannerEntryManagerSample {
    private static final Logger LOG = Logger.getLogger(SpannerEntryManagerSample.class);

    private Properties getSampleConnectionProperties() {
        Properties connectionProperties = new Properties();
        connectionProperties.put("spanner#connection.project", "jans-project");
        connectionProperties.put("spanner#connection.instance", "jans-instance");
        connectionProperties.put("spanner#connection.database", "jansdb");
        boolean emulator = true;
        if (emulator) {
            connectionProperties.put("spanner#connection.emulator-host", "localhost:9010");
        } else {
            connectionProperties.put("spanner#connection.credentials-file", "V:\\dev-gluu-cloud-platform-32136abdceb7.json");
        }
        connectionProperties.put("spanner#password.encryption.method", "SSHA-256");
        connectionProperties.put("spanner#connection.pool.create-max-wait-time-millis", "20000");
        connectionProperties.put("spanner#statement.limit.default-maximum-result-size", "1000");
        connectionProperties.put("spanner#statement.limit.maximum-result-delete-size", "10000");
        connectionProperties.put("spanner#binaryAttributes", "objectGUID");
        connectionProperties.put("spanner#certificateAttributes", "userCertificate");
        return connectionProperties;
    }

    public SpannerEntryManager createSpannerEntryManager() {
        SpannerEntryManagerFactory sqlEntryManagerFactory = new SpannerEntryManagerFactory();
        sqlEntryManagerFactory.create();
        Properties connectionProperties = this.getSampleConnectionProperties();
        SpannerEntryManager sqlEntryManager = sqlEntryManagerFactory.createEntryManager(connectionProperties);
        LOG.debug((Object)("Created SpannerEntryManager: " + sqlEntryManager));
        return sqlEntryManager;
    }
}

