/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.cloud.spanner.test;

import io.jans.orm.cloud.spanner.impl.SpannerEntryManager;
import io.jans.orm.cloud.spanner.impl.SpannerEntryManagerFactory;
import io.jans.orm.cloud.spanner.test.SessionId;
import io.jans.orm.exception.EntryPersistenceException;
import io.jans.orm.model.BatchOperation;
import io.jans.orm.model.PagedResult;
import io.jans.orm.model.ProcessBatchOperation;
import io.jans.orm.model.SearchScope;
import io.jans.orm.model.SortOrder;
import io.jans.orm.search.filter.Filter;
import io.jans.orm.util.Pair;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ManualSpannerEntryManagerTest {
    private SpannerEntryManager manager;
    private SessionId persistedSessionId;
    private int totalProcessedCount;

    @BeforeClass(enabled=false)
    public void init() throws IOException {
        this.manager = this.createSpannerEntryManager();
    }

    @AfterClass(enabled=false)
    public void destroy() throws IOException {
        if (this.manager != null) {
            this.manager.destroy();
        }
    }

    @Test(enabled=false)
    public void createSessionId() throws IOException {
        SessionId sessionId = this.buildSessionId();
        this.manager.persist((Object)sessionId);
        this.persistedSessionId = sessionId;
        System.out.println(sessionId);
    }

    @Test(dependsOnMethods={"createSessionId"}, enabled=false)
    public void searchSessionId() throws IOException {
        List sessionIdList = this.manager.findEntries("o=jans", SessionId.class, null);
        System.out.println(sessionIdList);
    }

    @Test(dependsOnMethods={"searchSessionId"}, enabled=false)
    public void containsSessionId() throws IOException {
        SessionId sessionId = this.persistedSessionId;
        boolean result = this.manager.contains((Object)sessionId);
        Assert.assertTrue((boolean)result);
        System.out.println(sessionId);
    }

    @Test(dependsOnMethods={"containsSessionId"}, enabled=false)
    public void updateSessionId() throws IOException {
        SessionId sessionId = this.persistedSessionId;
        sessionId.setAuthenticationTime(new Date());
        sessionId.setLastUsedAt(new Date());
        sessionId.setJwt(null);
        sessionId.setIsJwt(null);
        Pair<Date, Integer> expirarion = this.expirationDate(new Date());
        sessionId.setExpirationDate((Date)expirarion.getFirst());
        sessionId.setTtl((Integer)expirarion.getSecond());
        this.manager.merge((Object)sessionId);
        System.out.println(sessionId);
    }

    @Test(dependsOnMethods={"updateSessionId"}, enabled=false)
    public void countSessionId() throws IOException {
        SessionId sessionId = this.persistedSessionId;
        int countEntries = this.manager.countEntries((Object)sessionId);
        Assert.assertEquals((int)countEntries, (int)1);
    }

    @Test(dependsOnMethods={"countSessionId"}, enabled=false)
    public void containsSessionIdAfterUpdate() throws IOException {
        SessionId sessionId = this.persistedSessionId;
        boolean result = this.manager.contains((Object)sessionId);
        Assert.assertTrue((boolean)result);
        System.out.println(sessionId);
    }

    @Test(dependsOnMethods={"containsSessionIdAfterUpdate"}, enabled=false)
    public void deleteSessionId() throws IOException {
        SessionId sessionId = this.persistedSessionId;
        this.manager.remove((Object)sessionId);
        boolean result = this.manager.contains((Object)sessionId);
        Assert.assertFalse((boolean)result);
        System.out.println(sessionId);
    }

    @Test(dependsOnMethods={"deleteSessionId"}, enabled=false)
    public void searchSessionIdWithRanges() throws IOException {
        String outsideSid = UUID.randomUUID().toString();
        for (int i = 0; i < 20; ++i) {
            SessionId sessionId = this.buildSessionId();
            sessionId.setOutsideSid(outsideSid);
            this.manager.persist((Object)sessionId);
        }
        Filter filter = Filter.createEqualityFilter((String)"sid", (Object)outsideSid);
        List sessionIdList = this.manager.findEntries("o=jans", SessionId.class, filter);
        Assert.assertNotNull((Object)sessionIdList);
        Assert.assertEquals((int)sessionIdList.size(), (int)20);
        List sessionIdList2 = this.manager.findEntries("o=jans", SessionId.class, filter, 5);
        Assert.assertNotNull((Object)sessionIdList2);
        Assert.assertEquals((int)sessionIdList2.size(), (int)5);
        List sessionIdList3 = this.manager.findEntries("o=jans", SessionId.class, filter, 25);
        Assert.assertNotNull((Object)sessionIdList3);
        Assert.assertEquals((int)sessionIdList3.size(), (int)20);
        List sessionIdList4 = this.manager.findEntries("o=jans", SessionId.class, filter, null, null, 14, 7, 3);
        Assert.assertNotNull((Object)sessionIdList4);
        Assert.assertEquals((int)sessionIdList4.size(), (int)6);
        List sessionIdList5 = this.manager.findEntries("o=jans", SessionId.class, filter, null, null, 20, 10, 5);
        Assert.assertNotNull((Object)sessionIdList5);
        Assert.assertEquals((int)sessionIdList5.size(), (int)0);
        List sessionIdList6 = this.manager.findEntries("o=jans", SessionId.class, filter, null, null, 19, -1, 5);
        Assert.assertNotNull((Object)sessionIdList6);
        Assert.assertEquals((int)sessionIdList6.size(), (int)1);
    }

    @Test(dependsOnMethods={"deleteSessionId"}, enabled=false)
    public void searchPagedSessionIdWithRanges() throws IOException {
        String outsideSid = UUID.randomUUID().toString();
        for (int i = 0; i < 20; ++i) {
            SessionId sessionId = this.buildSessionId();
            sessionId.setOutsideSid(outsideSid);
            this.manager.persist((Object)sessionId);
        }
        Filter filter = Filter.createEqualityFilter((String)"sid", (Object)outsideSid);
        PagedResult sessionIdList = this.manager.findPagedEntries("o=jans", SessionId.class, filter, null, "sid", SortOrder.DESCENDING, 0, -1, -1);
        Assert.assertNotNull((Object)sessionIdList);
        Assert.assertEquals((int)sessionIdList.getTotalEntriesCount(), (int)20);
        PagedResult sessionIdList2 = this.manager.findPagedEntries("o=jans", SessionId.class, filter, null, "sid", SortOrder.DESCENDING, 0, 5, -1);
        Assert.assertNotNull((Object)sessionIdList2);
        Assert.assertEquals((int)sessionIdList2.getStart(), (int)0);
        Assert.assertEquals((int)sessionIdList2.getEntriesCount(), (int)5);
        Assert.assertEquals((int)sessionIdList2.getTotalEntriesCount(), (int)20);
        PagedResult sessionIdList4 = this.manager.findPagedEntries("o=jans", SessionId.class, filter, null, "sid", SortOrder.DESCENDING, 14, 7, 3);
        Assert.assertNotNull((Object)sessionIdList4);
        Assert.assertEquals((int)sessionIdList4.getStart(), (int)14);
        Assert.assertEquals((int)sessionIdList4.getEntriesCount(), (int)6);
        Assert.assertEquals((int)sessionIdList4.getTotalEntriesCount(), (int)20);
        PagedResult sessionIdList5 = this.manager.findPagedEntries("o=jans", SessionId.class, filter, null, "sid", SortOrder.DESCENDING, 20, 10, 5);
        Assert.assertNotNull((Object)sessionIdList5);
        Assert.assertEquals((int)sessionIdList5.getStart(), (int)20);
        Assert.assertEquals((int)sessionIdList5.getEntriesCount(), (int)0);
        Assert.assertEquals((int)sessionIdList5.getTotalEntriesCount(), (int)20);
        PagedResult sessionIdList6 = this.manager.findPagedEntries("o=jans", SessionId.class, filter, null, "sid", SortOrder.DESCENDING, 19, -1, 5);
        Assert.assertNotNull((Object)sessionIdList6);
        Assert.assertEquals((int)sessionIdList6.getStart(), (int)19);
        Assert.assertEquals((int)sessionIdList6.getEntriesCount(), (int)1);
        Assert.assertEquals((int)sessionIdList6.getTotalEntriesCount(), (int)20);
    }

    @Test(dependsOnMethods={"deleteSessionId"}, enabled=false)
    public void deleteSessionIdByFilter() throws IOException {
        String outsideSid = UUID.randomUUID().toString();
        for (int i = 0; i < 20; ++i) {
            SessionId sessionId = this.buildSessionId();
            sessionId.setOutsideSid(outsideSid);
            this.manager.persist((Object)sessionId);
        }
        Filter filter = Filter.createEqualityFilter((String)"sid", (Object)outsideSid);
        int removedCount = this.manager.remove("ou=sessions,o=jans", SessionId.class, filter, 14);
        Assert.assertEquals((int)removedCount, (int)14);
        int removedCount2 = this.manager.remove("ou=sessions,o=jans", SessionId.class, filter, 5);
        Assert.assertEquals((int)removedCount2, (int)5);
        int removedCount3 = this.manager.remove("ou=sessions,o=jans", SessionId.class, filter, 1);
        Assert.assertEquals((int)removedCount3, (int)1);
    }

    @Test(dependsOnMethods={"deleteSessionId"}, enabled=false)
    public void countSessionIdByFilter() throws IOException {
        String outsideSid = UUID.randomUUID().toString();
        for (int i = 0; i < 33; ++i) {
            SessionId sessionId = this.buildSessionId();
            sessionId.setOutsideSid(outsideSid);
            this.manager.persist((Object)sessionId);
        }
        Filter filter = Filter.createEqualityFilter((String)"sid", (Object)outsideSid);
        int countEntries = this.manager.countEntries("ou=sessions,o=jans", SessionId.class, filter, null);
        Assert.assertEquals((int)countEntries, (int)33);
    }

    @Test(dependsOnMethods={"deleteSessionId"}, enabled=false)
    public void testBatchJob() {
        String outsideSid = UUID.randomUUID().toString();
        for (int i = 0; i < 200; ++i) {
            SessionId sessionId = this.buildSessionId();
            sessionId.setOutsideSid(outsideSid);
            Pair<Date, Integer> expirarion = this.expirationDate(new Date());
            sessionId.setExpirationDate((Date)expirarion.getFirst());
            sessionId.setTtl((Integer)expirarion.getSecond());
            this.manager.persist((Object)sessionId);
        }
        this.totalProcessedCount = 0;
        ProcessBatchOperation<SessionId> sessionBatchOperation = new ProcessBatchOperation<SessionId>(){
            int processedCount = 0;

            public void performAction(List<SessionId> objects) {
                for (SessionId simpleSession : objects) {
                    try {
                        Calendar calendar = Calendar.getInstance();
                        Date jansLastAccessTimeDate = simpleSession.getExpirationDate();
                        calendar.setTime(jansLastAccessTimeDate);
                        calendar.add(13, -1);
                        simpleSession.setExpirationDate(calendar.getTime());
                        ManualSpannerEntryManagerTest.this.manager.merge((Object)simpleSession);
                        ++this.processedCount;
                    }
                    catch (EntryPersistenceException ex) {
                        System.err.println("Failed to update entry: " + ex.getMessage());
                    }
                }
                System.out.println("Total processed: " + this.processedCount);
                Assert.assertEquals((int)this.processedCount, (int)100);
                ManualSpannerEntryManagerTest.this.totalProcessedCount += this.processedCount;
            }
        };
        Filter filter1 = Filter.createANDFilter((Filter[])new Filter[]{Filter.createPresenceFilter((String)"exp"), Filter.createEqualityFilter((String)"sid", (Object)outsideSid)});
        this.manager.findEntries("o=jans", SessionId.class, filter1, SearchScope.SUB, new String[]{"exp"}, (BatchOperation)sessionBatchOperation, 0, 500, 100);
        Assert.assertEquals((int)this.totalProcessedCount, (int)200);
    }

    private SessionId buildSessionId() {
        SessionId sessionId = new SessionId();
        sessionId.setId(UUID.randomUUID().toString());
        sessionId.setDn(String.format("jansId=%s,%s", sessionId.getId(), "ou=sessions,o=jans"));
        sessionId.setCreationDate(new Date());
        sessionId.setJwt("{}");
        sessionId.setIsJwt(true);
        return sessionId;
    }

    private Pair<Date, Integer> expirationDate(Date creationDate) {
        int expirationInSeconds = 120;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(creationDate);
        calendar.add(13, expirationInSeconds);
        return new Pair((Object)calendar.getTime(), (Object)expirationInSeconds);
    }

    public static Properties loadProperties() throws IOException {
        Properties properties = new Properties();
        try (FileInputStream is = new FileInputStream("V://Development//jans//conf/jans-sql.properties");){
            Properties props = new Properties();
            props.load(is);
            for (Object key : props.keySet()) {
                String value = props.getProperty((String)key);
                if (!((String)key).startsWith("sql")) {
                    key = "sql." + (String)key;
                }
                properties.put(key, value);
            }
        }
        properties.put("sql.auth.userName", "root");
        properties.put("sql.auth.userPassword", "Secret1!");
        return properties;
    }

    public SpannerEntryManager createSpannerEntryManager() throws IOException {
        SpannerEntryManagerFactory sqlEntryManagerFactory = new SpannerEntryManagerFactory();
        sqlEntryManagerFactory.create();
        SpannerEntryManager sqlEntryManager = sqlEntryManagerFactory.createEntryManager(ManualSpannerEntryManagerTest.loadProperties());
        System.out.println("Created SpannerEntryManager: " + sqlEntryManager);
        return sqlEntryManager;
    }
}

