/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.cloud.spanner.test;

import com.google.common.collect.Maps;
import io.jans.orm.annotation.AttributeName;
import io.jans.orm.annotation.AttributesList;
import io.jans.orm.annotation.DN;
import io.jans.orm.annotation.DataEntry;
import io.jans.orm.annotation.Expiration;
import io.jans.orm.annotation.JsonObject;
import io.jans.orm.annotation.ObjectClass;
import io.jans.orm.cloud.spanner.test.SessionIdState;
import io.jans.orm.model.base.CustomAttribute;
import io.jans.orm.model.base.Deletable;
import io.jans.orm.util.StringHelper;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

@DataEntry(sortBy={"creationDate", "id"}, sortByName={"creationDate", "jansId"})
@ObjectClass(value="jansSessId")
public class SessionId
implements Deletable,
Serializable {
    public static final String OLD_SESSION_ID_ATTR_KEY = "old_session_id";
    private static final long serialVersionUID = -237476411915686378L;
    @DN
    private String dn;
    @AttributeName(name="jansId")
    private String id;
    @AttributeName(name="sid")
    private String outsideSid;
    @AttributeName(name="jansLastAccessTime")
    private Date lastUsedAt;
    @AttributeName(name="jansUsrDN")
    private String userDn;
    @AttributeName(name="authnTime")
    private Date authenticationTime;
    @AttributeName(name="jansState")
    private SessionIdState state;
    @AttributeName(name="jansSessState")
    private String sessionState;
    @AttributeName(name="jansPermissionGranted")
    private Boolean permissionGranted;
    @AttributeName(name="jansAsJwt")
    private Boolean isJwt = false;
    @AttributeName(name="jansJwt")
    private String jwt;
    @JsonObject
    @AttributeName(name="jansSessAttr")
    private Map<String, String> sessionAttributes;
    @AttributeName(name="exp")
    private Date expirationDate;
    @AttributeName(name="del")
    private Boolean deletable = true;
    @AttributeName(name="creationDate")
    private Date creationDate = new Date();
    @Transient
    private transient boolean persisted;
    @Expiration
    private int ttl;
    @AttributesList(name="name", value="values", sortByName=true)
    private List<CustomAttribute> customAttributes = new ArrayList<CustomAttribute>();

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String p_dn) {
        this.dn = p_dn;
    }

    public String getJwt() {
        return this.jwt;
    }

    public void setJwt(String jwt) {
        this.jwt = jwt;
    }

    public Boolean getIsJwt() {
        return this.isJwt;
    }

    public void setIsJwt(Boolean isJwt) {
        this.isJwt = isJwt;
    }

    public SessionIdState getState() {
        return this.state;
    }

    public void setState(SessionIdState state) {
        this.state = state;
    }

    public String getSessionState() {
        return this.sessionState;
    }

    public void setSessionState(String sessionState) {
        this.sessionState = sessionState;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String p_id) {
        this.id = p_id;
    }

    public Date getLastUsedAt() {
        return this.lastUsedAt;
    }

    public void setLastUsedAt(Date p_lastUsedAt) {
        this.lastUsedAt = p_lastUsedAt;
    }

    public String getUserDn() {
        return this.userDn;
    }

    public void setUserDn(String p_userDn) {
        this.userDn = p_userDn != null ? p_userDn : "";
    }

    public Date getAuthenticationTime() {
        return this.authenticationTime;
    }

    public void setAuthenticationTime(Date authenticationTime) {
        this.authenticationTime = authenticationTime;
    }

    public Boolean getPermissionGranted() {
        return this.permissionGranted;
    }

    public void setPermissionGranted(Boolean permissionGranted) {
        this.permissionGranted = permissionGranted;
    }

    @Nonnull
    public Map<String, String> getSessionAttributes() {
        if (this.sessionAttributes == null) {
            this.sessionAttributes = Maps.newHashMap();
        }
        return this.sessionAttributes;
    }

    public void setSessionAttributes(Map<String, String> sessionAttributes) {
        this.sessionAttributes = sessionAttributes;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public Boolean isDeletable() {
        return this.deletable != null ? this.deletable : true;
    }

    public void setDeletable(Boolean deletable) {
        this.deletable = deletable;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public void setOutsideSid(String outsideSid) {
        this.outsideSid = outsideSid;
    }

    public String getOutsideSid() {
        if (StringUtils.isBlank((CharSequence)this.outsideSid)) {
            this.outsideSid = UUID.randomUUID().toString();
        }
        return this.outsideSid;
    }

    public List<CustomAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(List<CustomAttribute> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public String getAttribute(String ldapAttribute) {
        String attribute = null;
        if (ldapAttribute != null && !ldapAttribute.isEmpty()) {
            for (CustomAttribute customAttribute : this.customAttributes) {
                if (!customAttribute.getName().equals(ldapAttribute)) continue;
                attribute = customAttribute.getValue();
                break;
            }
        }
        return attribute;
    }

    public List<String> getAttributeValues(String ldapAttribute) {
        List values = null;
        if (ldapAttribute != null && !ldapAttribute.isEmpty()) {
            for (CustomAttribute customAttribute : this.customAttributes) {
                if (!StringHelper.equalsIgnoreCase((String)customAttribute.getName(), (String)ldapAttribute)) continue;
                values = customAttribute.getValues();
                break;
            }
        }
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionId id1 = (SessionId)o;
        return !(this.id == null ? id1.id != null : !this.id.equals(id1.id));
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "SessionId [dn=" + this.dn + ", id=" + this.id + ", outsideSid=" + this.outsideSid + ", lastUsedAt=" + this.lastUsedAt + ", userDn=" + this.userDn + ", authenticationTime=" + this.authenticationTime + ", state=" + this.state + ", sessionState=" + this.sessionState + ", permissionGranted=" + this.permissionGranted + ", isJwt=" + this.isJwt + ", jwt=" + this.jwt + ", sessionAttributes=" + this.sessionAttributes + ", expirationDate=" + this.expirationDate + ", deletable=" + this.deletable + ", creationDate=" + this.creationDate + ", persisted=" + this.persisted + ", ttl=" + this.ttl + "]";
    }
}

