/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.cloud.spanner;

import io.jans.orm.cloud.spanner.LoggingHelper;
import io.jans.orm.cloud.spanner.SpannerSample;
import io.jans.orm.cloud.spanner.impl.SpannerEntryManager;
import io.jans.orm.cloud.spanner.model.SimpleClient;
import io.jans.orm.cloud.spanner.model.SimpleSession;
import io.jans.orm.cloud.spanner.model.SimpleToken;
import io.jans.orm.cloud.spanner.persistence.SpannerEntryManagerSample;
import io.jans.orm.exception.EntryPersistenceException;
import io.jans.orm.model.BatchOperation;
import io.jans.orm.model.DefaultBatchOperation;
import io.jans.orm.model.ProcessBatchOperation;
import io.jans.orm.model.SearchScope;
import io.jans.orm.model.base.CustomAttribute;
import io.jans.orm.search.filter.Filter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.status.StatusLogger;

public final class SpannerBatchJobSample {
    private static final Logger LOG;

    private SpannerBatchJobSample() {
    }

    public static void main(String[] args) {
        SpannerEntryManagerSample sqlEntryManagerSample = new SpannerEntryManagerSample();
        final SpannerEntryManager sqlEntryManager = sqlEntryManagerSample.createSpannerEntryManager();
        ProcessBatchOperation<SimpleToken> tokenSQLBatchOperation = new ProcessBatchOperation<SimpleToken>(){
            private int processedCount = 0;

            public void performAction(List<SimpleToken> objects) {
                for (SimpleToken simpleTokenSQL : objects) {
                    try {
                        CustomAttribute customAttribute = SpannerBatchJobSample.getUpdatedAttribute(sqlEntryManager, simpleTokenSQL.getDn(), "exp", simpleTokenSQL.getAttribute("exp"));
                        simpleTokenSQL.setCustomAttributes(Arrays.asList(customAttribute));
                        sqlEntryManager.merge((Object)simpleTokenSQL);
                        ++this.processedCount;
                    }
                    catch (EntryPersistenceException ex) {
                        LOG.error((Object)"Failed to update entry", (Throwable)ex);
                    }
                }
                LOG.info((Object)("Total processed tokens: " + this.processedCount));
            }
        };
        Filter filter1 = Filter.createPresenceFilter((String)"exp");
        sqlEntryManager.findEntries("o=jans", SimpleToken.class, filter1, SearchScope.SUB, new String[]{"exp"}, (BatchOperation)tokenSQLBatchOperation, 0, 0, 100);
        ProcessBatchOperation<SimpleSession> sessionBatchOperation = new ProcessBatchOperation<SimpleSession>(){
            private int processedCount = 0;

            public void performAction(List<SimpleSession> objects) {
                int currentProcessedCount = 0;
                for (SimpleSession simpleSession : objects) {
                    try {
                        CustomAttribute customAttribute = SpannerBatchJobSample.getUpdatedAttribute(sqlEntryManager, simpleSession.getDn(), "jansLastAccessTime", simpleSession.getAttribute("jansLastAccessTime"));
                        simpleSession.setCustomAttributes(Arrays.asList(customAttribute));
                        sqlEntryManager.merge((Object)simpleSession);
                        ++this.processedCount;
                        ++currentProcessedCount;
                    }
                    catch (EntryPersistenceException ex) {
                        LOG.error((Object)"Failed to update entry", (Throwable)ex);
                    }
                }
                LOG.info((Object)("Currnet batch count processed sessions: " + currentProcessedCount));
                LOG.info((Object)("Total processed sessions: " + this.processedCount));
            }
        };
        Filter filter2 = Filter.createPresenceFilter((String)"jansLastAccessTime");
        sqlEntryManager.findEntries("o=jans", SimpleSession.class, filter2, SearchScope.SUB, new String[]{"jansLastAccessTime"}, (BatchOperation)sessionBatchOperation, 0, 0, 100);
        ProcessBatchOperation<SimpleClient> clientBatchOperation = new ProcessBatchOperation<SimpleClient>(){
            private int processedCount = 0;

            public void performAction(List<SimpleClient> objects) {
                for (SimpleClient simpleClient : objects) {
                    ++this.processedCount;
                }
                LOG.info((Object)("Total processed clients: " + this.processedCount));
            }
        };
        Filter filter3 = Filter.createPresenceFilter((String)"exp");
        List result3 = sqlEntryManager.findEntries("o=jans", SimpleClient.class, filter3, SearchScope.SUB, new String[]{"exp"}, (BatchOperation)clientBatchOperation, 0, 0, 1000);
        LOG.info((Object)("Result count (without collecting results): " + result3.size()));
        DefaultBatchOperation<SimpleClient> clientBatchOperation2 = new DefaultBatchOperation<SimpleClient>(){
            private int processedCount = 0;

            public void performAction(List<SimpleClient> objects) {
                for (SimpleClient simpleClient : objects) {
                    ++this.processedCount;
                }
                LOG.info((Object)("Total processed clients: " + this.processedCount));
            }
        };
        Filter filter4 = Filter.createPresenceFilter((String)"exp");
        List result4 = sqlEntryManager.findEntries("o=jans", SimpleClient.class, filter4, SearchScope.SUB, new String[]{"exp"}, (BatchOperation)clientBatchOperation2, 0, 0, 1000);
        LOG.info((Object)("Result count (with collecting results): " + result4.size()));
    }

    private static CustomAttribute getUpdatedAttribute(SpannerEntryManager sqlEntryManager, String baseDn, String attributeName, String attributeValue) {
        try {
            Calendar calendar = Calendar.getInstance();
            Date jansLastAccessTimeDate = new Date();
            calendar.setTime(jansLastAccessTimeDate);
            calendar.add(13, -1);
            CustomAttribute customAttribute = new CustomAttribute();
            customAttribute.setName(attributeName);
            customAttribute.setValue(sqlEntryManager.encodeTime(baseDn, calendar.getTime()));
            return customAttribute;
        }
        catch (Exception ex) {
            LOG.error((Object)"Can't parse attribute", (Throwable)ex);
            return null;
        }
    }

    static {
        StatusLogger.getLogger().setLevel(Level.OFF);
        LoggingHelper.configureConsoleAppender();
        LOG = Logger.getLogger(SpannerSample.class);
    }
}

