/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.cloud.spanner;

import io.jans.orm.cloud.spanner.impl.SpannerEntryManager;
import io.jans.orm.cloud.spanner.model.SimpleCustomStringUser;
import io.jans.orm.cloud.spanner.model.UserRole;
import io.jans.orm.cloud.spanner.operation.impl.SpannerConnectionProvider;
import io.jans.orm.cloud.spanner.persistence.SpannerEntryManagerSample;
import io.jans.orm.model.base.CustomAttribute;
import io.jans.orm.search.filter.Filter;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpannerCustomStringAttributesSample {
    private static final Logger LOG = LoggerFactory.getLogger(SpannerConnectionProvider.class);

    private SpannerCustomStringAttributesSample() {
    }

    public static void main(String[] args) {
        SpannerEntryManagerSample sqlEntryManagerSample = new SpannerEntryManagerSample();
        SpannerEntryManager sqlEntryManager = sqlEntryManagerSample.createSpannerEntryManager();
        String randomExternalUid = "" + System.currentTimeMillis();
        SimpleCustomStringUser newUser = new SimpleCustomStringUser();
        newUser.setDn(String.format("inum=%s,ou=people,o=jans", System.currentTimeMillis()));
        newUser.setUserId("sample_user_" + System.currentTimeMillis());
        newUser.setUserPassword("test");
        newUser.getCustomAttributes().add(new CustomAttribute("address", Arrays.asList("London", "Texas", "Kiev")));
        newUser.getCustomAttributes().add(new CustomAttribute("jansExtUid", randomExternalUid).multiValued());
        newUser.setUserRole(UserRole.ADMIN);
        newUser.setMemberOf(Arrays.asList("group_1", "group_2", "group_3"));
        sqlEntryManager.persist((Object)newUser);
        LOG.info("Added User '{}' with uid '{}' and key '{}'", new Object[]{newUser, newUser.getUserId(), newUser.getDn()});
        SimpleCustomStringUser foundUser = (SimpleCustomStringUser)sqlEntryManager.find(SimpleCustomStringUser.class, (Object)newUser.getDn());
        LOG.info("Found User '{}' with uid '{}' and key '{}'", new Object[]{foundUser, foundUser.getUserId(), foundUser.getDn()});
        LOG.info("Custom attributes '{}'", foundUser.getCustomAttributes());
        for (CustomAttribute customAttribute : foundUser.getCustomAttributes()) {
            LOG.info("Found custom attribute '{}' with value '{}'", (Object)customAttribute.getName(), (Object)customAttribute.getValue());
        }
        Filter jsExternalUidFilter = Filter.createEqualityFilter((String)"jansExtUid", (Object)randomExternalUid).multiValued();
        List foundUsers = sqlEntryManager.findEntries("ou=people,o=jans", SimpleCustomStringUser.class, jsExternalUidFilter);
        for (SimpleCustomStringUser foundUser2 : foundUsers) {
            LOG.info("Found User '{}' by jansExtUid with uid '{}' and key '{}'", new Object[]{foundUser2, foundUser2.getUserId(), foundUser2.getDn()});
        }
    }
}

