/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.cloud.spanner;

import io.jans.orm.cloud.spanner.impl.SpannerEntryManager;
import io.jans.orm.cloud.spanner.model.SimpleCacheEntry;
import io.jans.orm.cloud.spanner.operation.impl.SpannerConnectionProvider;
import io.jans.orm.cloud.spanner.persistence.SpannerEntryManagerSample;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpannerUpateCacheEntrySample {
    private static final Logger LOG = LoggerFactory.getLogger(SpannerConnectionProvider.class);

    private SpannerUpateCacheEntrySample() {
    }

    public static void main(String[] args) {
        SpannerEntryManagerSample sqlEntryManagerSample = new SpannerEntryManagerSample();
        SpannerEntryManager sqlEntryManager = sqlEntryManagerSample.createSpannerEntryManager();
        String key = UUID.randomUUID().toString();
        String cacheDn = String.format("uuid=%s,%s", key, "ou=cache,o=jans");
        int expirationInSeconds = 60;
        Calendar expirationDate = Calendar.getInstance();
        expirationDate.setTime(new Date());
        expirationDate.add(13, expirationInSeconds);
        SimpleCacheEntry entity = new SimpleCacheEntry();
        entity.setTtl(expirationInSeconds);
        entity.setData("sample_data");
        entity.setId(key);
        entity.setDn(cacheDn);
        entity.setCreationDate(new Date());
        entity.setExpirationDate(expirationDate.getTime());
        entity.setDeletable(true);
        sqlEntryManager.persist((Object)entity);
        sqlEntryManager.merge((Object)entity);
        entity.setData(null);
        sqlEntryManager.merge((Object)entity);
    }
}

