/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.cloud.spanner;

import io.jans.orm.cloud.spanner.LoggingHelper;
import io.jans.orm.cloud.spanner.impl.SpannerEntryManager;
import io.jans.orm.cloud.spanner.model.SimpleSessionState;
import io.jans.orm.cloud.spanner.persistence.SpannerEntryManagerSample;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.status.StatusLogger;

public final class SpannerConcurentSessionUpdateSample {
    private static final Logger LOG;

    private SpannerConcurentSessionUpdateSample() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        SpannerEntryManagerSample sqlEntryManagerSample = new SpannerEntryManagerSample();
        final SpannerEntryManager sqlEntryManager = sqlEntryManagerSample.createSpannerEntryManager();
        try {
            String sessionId = UUID.randomUUID().toString();
            final String sessionDn = "uniqueIdentifier=" + sessionId + ",ou=session,o=jans";
            String userDn = "inum=@!E8F2.853B.1E7B.ACE2!0001!39A4.C163!0000!A8F2.DE1E.D7FB,ou=people,o=jans";
            SimpleSessionState simpleSessionState = new SimpleSessionState();
            simpleSessionState.setDn(sessionDn);
            simpleSessionState.setId(sessionId);
            simpleSessionState.setLastUsedAt(new Date());
            sqlEntryManager.persist((Object)simpleSessionState);
            System.out.println("Persisted");
            int threadCount = 500;
            ExecutorService executorService = Executors.newFixedThreadPool(threadCount, SpannerConcurentSessionUpdateSample.daemonThreadFactory());
            int i = 0;
            while (i < threadCount) {
                final int count = i++;
                executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        SimpleSessionState simpleSessionStateFromSQL = (SimpleSessionState)sqlEntryManager.find(SimpleSessionState.class, (Object)sessionDn);
                        String beforeUserDn = simpleSessionStateFromSQL.getUserDn();
                        String randomUserDn = count % 2 == 0 ? "inum=@!E8F2.853B.1E7B.ACE2!0001!39A4.C163!0000!A8F2.DE1E.D7FB,ou=people,o=jans" : "";
                        try {
                            simpleSessionStateFromSQL.setUserDn(randomUserDn);
                            simpleSessionStateFromSQL.setLastUsedAt(new Date());
                            sqlEntryManager.merge((Object)simpleSessionStateFromSQL);
                            System.out.println("Merged thread: " + count + ", userDn: " + randomUserDn + ", before userDn: " + beforeUserDn);
                        }
                        catch (Throwable e) {
                            System.out.println("ERROR !!!, thread: " + count + ", userDn: " + randomUserDn + ", before userDn: " + beforeUserDn + ", error:" + e.getMessage());
                        }
                    }
                });
            }
            Thread.sleep(5000L);
        }
        finally {
            sqlEntryManager.destroy();
        }
    }

    public static ThreadFactory daemonThreadFactory() {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    static {
        StatusLogger.getLogger().setLevel(Level.OFF);
        LoggingHelper.configureConsoleAppender();
        LOG = Logger.getLogger(SpannerConcurentSessionUpdateSample.class);
    }
}

