/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.cloud.spanner;

import io.jans.orm.cloud.spanner.impl.SpannerEntryManager;
import io.jans.orm.cloud.spanner.model.SimpleSessionState;
import io.jans.orm.cloud.spanner.operation.impl.SpannerConnectionProvider;
import io.jans.orm.cloud.spanner.persistence.SpannerEntryManagerSample;
import io.jans.orm.exception.EntryPersistenceException;
import java.util.Date;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpannerUpateMissingEntrySample {
    private static final Logger LOG = LoggerFactory.getLogger(SpannerConnectionProvider.class);

    private SpannerUpateMissingEntrySample() {
    }

    public static void main(String[] args) {
        SpannerEntryManagerSample sqlEntryManagerSample = new SpannerEntryManagerSample();
        SpannerEntryManager sqlEntryManager = sqlEntryManagerSample.createSpannerEntryManager();
        String sessionId = UUID.randomUUID().toString();
        String sessionDn = "uniqueIdentifier=" + sessionId + ",ou=session,o=jans";
        SimpleSessionState simpleSessionState = new SimpleSessionState();
        simpleSessionState.setDn(sessionDn);
        simpleSessionState.setId(sessionId);
        simpleSessionState.setLastUsedAt(new Date());
        try {
            sqlEntryManager.merge((Object)simpleSessionState);
            System.out.println("Updated");
        }
        catch (EntryPersistenceException ex) {
            LOG.info("Failed to update, root case exception: {}", ex.getCause().getClass(), (Object)ex);
        }
    }
}

