/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.cloud.spanner.impl;

import com.google.cloud.Timestamp;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.cloud.spanner.impl.SpannerBatchOperationWraper;
import io.jans.orm.cloud.spanner.impl.SpannerEntryManagerFactory;
import io.jans.orm.cloud.spanner.impl.SpannerFilterConverter;
import io.jans.orm.cloud.spanner.model.ConvertedExpression;
import io.jans.orm.cloud.spanner.model.SearchReturnDataType;
import io.jans.orm.cloud.spanner.model.TableMapping;
import io.jans.orm.cloud.spanner.operation.SpannerOperationService;
import io.jans.orm.event.DeleteNotifier;
import io.jans.orm.exception.AuthenticationException;
import io.jans.orm.exception.EntryDeleteException;
import io.jans.orm.exception.EntryPersistenceException;
import io.jans.orm.exception.MappingException;
import io.jans.orm.exception.operation.SearchException;
import io.jans.orm.impl.BaseEntryManager;
import io.jans.orm.impl.GenericKeyConverter;
import io.jans.orm.impl.model.ParsedKey;
import io.jans.orm.model.AttributeData;
import io.jans.orm.model.AttributeDataModification;
import io.jans.orm.model.BatchOperation;
import io.jans.orm.model.EntryData;
import io.jans.orm.model.PagedResult;
import io.jans.orm.model.SearchScope;
import io.jans.orm.model.Sort;
import io.jans.orm.model.SortOrder;
import io.jans.orm.reflect.property.PropertyAnnotation;
import io.jans.orm.search.filter.Filter;
import io.jans.orm.search.filter.FilterProcessor;
import io.jans.orm.util.ArrayHelper;
import io.jans.orm.util.StringHelper;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpannerEntryManager
extends BaseEntryManager
implements Serializable {
    private static final long serialVersionUID = 2127241817126412574L;
    private static final Logger LOG = LoggerFactory.getLogger(SpannerEntryManager.class);
    private static final String JSON_DATA_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    @Inject
    private Logger log;
    private final SpannerFilterConverter filterConverter;
    private FilterProcessor filterProcessor;
    private static final GenericKeyConverter KEY_CONVERTER = new GenericKeyConverter(false);
    private List<DeleteNotifier> subscribers;

    protected SpannerEntryManager(SpannerOperationService operationService) {
        this.operationService = operationService;
        this.filterConverter = new SpannerFilterConverter(operationService);
        this.filterProcessor = new FilterProcessor();
        this.subscribers = new LinkedList<DeleteNotifier>();
    }

    public boolean destroy() {
        if (this.operationService == null) {
            return true;
        }
        return ((SpannerOperationService)this.operationService).destroy();
    }

    public SpannerOperationService getOperationService() {
        return (SpannerOperationService)this.operationService;
    }

    public void addDeleteSubscriber(DeleteNotifier subscriber) {
        this.subscribers.add(subscriber);
    }

    public void removeDeleteSubscriber(DeleteNotifier subscriber) {
        this.subscribers.remove(subscriber);
    }

    public Void merge(Object entry) {
        Class<?> entryClass = entry.getClass();
        this.checkEntryClass(entryClass, true);
        if (this.isSchemaEntry(entryClass)) {
            throw new UnsupportedOperationException("Server doesn't support dynamic schema modifications");
        }
        return this.merge(entry, false, false, null);
    }

    protected List<String> buildAttributesListForUpdate(Object entry, String[] objectClasses, List<PropertyAnnotation> propertiesAnnotations) {
        List attributesList = this.getAttributesList(entry, propertiesAnnotations, false);
        Set<String> childAttributes = this.getOperationService().getTabeChildAttributes(objectClasses[0]);
        if (childAttributes != null) {
            attributesList.addAll(childAttributes);
        }
        return attributesList;
    }

    protected <T> void updateMergeChanges(String baseDn, T entry, boolean isConfigurationUpdate, Class<?> entryClass, Map<String, AttributeData> attributesFromDbMap, List<AttributeDataModification> attributeDataModifications, boolean forceUpdate) {
        if (forceUpdate) {
            return;
        }
        if (!isConfigurationUpdate) {
            Object[] objectClasses = this.getObjectClasses(entry, entryClass);
            if (ArrayHelper.isEmpty((Object[])objectClasses)) {
                throw new UnsupportedOperationException(String.format("There is no attribute with objectClasses to persist! Entry is invalid: '%s'", entry));
            }
            AttributeData objectClassAttributeData = attributesFromDbMap.get("objectClass".toLowerCase());
            if (objectClassAttributeData == null) {
                throw new UnsupportedOperationException(String.format("There is no attribute with objectClasses in DB! Entry is invalid: '%s'", entry));
            }
            Object[] objectClassesFromDb = objectClassAttributeData.getStringValues();
            if (ArrayHelper.isEmpty((Object[])objectClassesFromDb)) {
                throw new UnsupportedOperationException(String.format("There is no attribute with objectClasses in DB! Entry is invalid: '%s'", entry));
            }
            if (!StringHelper.equals((String)objectClassesFromDb[0], (String)objectClasses[0])) {
                throw new UnsupportedOperationException(String.format("It's not possible to change objectClasses of already persisted entry! Entry is invalid: '%s'", entry));
            }
        }
    }

    public void remove(Object entry) {
        Class<?> entryClass = entry.getClass();
        this.checkEntryClass(entryClass, true);
        if (this.isSchemaEntry(entryClass)) {
            throw new UnsupportedOperationException("Server doesn't support dynamic schema modifications");
        }
        Object dnValue = this.getDNValue(entry, entryClass);
        LOG.debug("LDAP entry to remove: '{}'", (Object)dnValue.toString());
        this.remove(dnValue.toString(), entryClass);
    }

    protected void persist(String dn, String[] objectClasses, List<AttributeData> attributes, Integer expiration) {
        ArrayList<AttributeData> resultAttributes = new ArrayList<AttributeData>(attributes.size() + 1);
        for (AttributeData attribute : attributes) {
            String attributeName = attribute.getName();
            Object[] attributeValues = attribute.getValues();
            Boolean multiValued = attribute.getMultiValued();
            if (!ArrayHelper.isNotEmpty((Object[])attributeValues) || attributeValues[0] == null) continue;
            Object[] realValues = attributeValues;
            if (StringHelper.equalsIgnoreCase((String)"objectClass", (String)attributeName) && !ArrayHelper.isEmpty((Object[])realValues)) {
                realValues = new Object[]{realValues[0]};
                multiValued = false;
            }
            if (StringHelper.equalsIgnoreCase((String)"userPassword", (String)attributeName)) {
                realValues = this.getOperationService().createStoragePassword(StringHelper.toStringArray((Object[])attributeValues));
            }
            this.escapeValues(realValues);
            AttributeData resultAttributeData = Boolean.TRUE.equals(multiValued) ? new AttributeData(this.toInternalAttribute(attributeName), realValues, multiValued) : new AttributeData(this.toInternalAttribute(attributeName), realValues[0]);
            resultAttributes.add(resultAttributeData);
        }
        try {
            ParsedKey parsedKey = this.toSQLKey(dn);
            resultAttributes.add(new AttributeData("dn", (Object)dn));
            resultAttributes.add(new AttributeData("doc_id", (Object)parsedKey.getKey()));
            boolean result = this.getOperationService().addEntry(parsedKey.getKey(), objectClasses[0], resultAttributes);
            if (!result) {
                throw new EntryPersistenceException(String.format("Failed to persist entry: '%s'", dn));
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to persist entry: '%s'", dn), (Throwable)ex);
        }
    }

    public void merge(String dn, String[] objectClasses, List<AttributeDataModification> attributeDataModifications, Integer expirationValue) {
        try {
            boolean result;
            ArrayList<AttributeDataModification> modifications = new ArrayList<AttributeDataModification>(attributeDataModifications.size());
            for (AttributeDataModification attributeDataModification : attributeDataModifications) {
                AttributeData attribute = attributeDataModification.getAttribute();
                AttributeData oldAttribute = attributeDataModification.getOldAttribute();
                String attributeName = null;
                Object[] attributeValues = null;
                Boolean multiValued = null;
                if (attribute != null) {
                    attributeName = attribute.getName();
                    attributeValues = attribute.getValues();
                    multiValued = attribute.getMultiValued();
                }
                String oldAttributeName = null;
                Object[] oldAttributeValues = null;
                if (oldAttribute != null) {
                    oldAttributeName = oldAttribute.getName();
                    oldAttributeValues = oldAttribute.getValues();
                }
                AttributeDataModification modification = null;
                AttributeDataModification.AttributeModificationType modificationType = attributeDataModification.getModificationType();
                if (AttributeDataModification.AttributeModificationType.ADD == modificationType || AttributeDataModification.AttributeModificationType.FORCE_UPDATE == modificationType) {
                    modification = this.createModification(modificationType, this.toInternalAttribute(attributeName), multiValued, attributeValues, oldAttributeValues);
                } else if (AttributeDataModification.AttributeModificationType.REMOVE == modificationType) {
                    if (attribute == null && this.isEmptyAttributeValues(oldAttribute)) continue;
                    modification = this.createModification(AttributeDataModification.AttributeModificationType.REMOVE, this.toInternalAttribute(oldAttributeName), multiValued, oldAttributeValues, null);
                } else if (AttributeDataModification.AttributeModificationType.REPLACE == modificationType) {
                    modification = this.createModification(AttributeDataModification.AttributeModificationType.REPLACE, this.toInternalAttribute(attributeName), multiValued, attributeValues, oldAttributeValues);
                }
                if (modification == null) continue;
                modifications.add(modification);
            }
            if (modifications.size() > 0 && !(result = this.getOperationService().updateEntry(this.toSQLKey(dn).getKey(), objectClasses[0], modifications))) {
                throw new EntryPersistenceException(String.format("Failed to update entry: '%s'", dn));
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to update entry: '%s'", dn), (Throwable)ex);
        }
    }

    protected <T> void removeByDn(String dn, String[] objectClasses) {
        if (ArrayHelper.isEmpty((Object[])objectClasses)) {
            throw new UnsupportedOperationException("Entry class is manadatory for remove operation!");
        }
        try {
            for (DeleteNotifier subscriber : this.subscribers) {
                subscriber.onBeforeRemove(dn, objectClasses);
            }
            this.getOperationService().delete(this.toSQLKey(dn).getKey(), objectClasses[0]);
            for (DeleteNotifier subscriber : this.subscribers) {
                subscriber.onAfterRemove(dn, objectClasses);
            }
        }
        catch (Exception ex) {
            throw new EntryDeleteException(String.format("Failed to remove entry: '%s'", dn), (Throwable)ex);
        }
    }

    protected <T> void removeRecursivelyFromDn(String dn, String[] objectClasses) {
        if (ArrayHelper.isEmpty((Object[])objectClasses)) {
            throw new UnsupportedOperationException("Entry class is manadatory for recursive remove operation!");
        }
        try {
            for (DeleteNotifier subscriber : this.subscribers) {
                subscriber.onBeforeRemove(dn, objectClasses);
            }
            this.getOperationService().deleteRecursively(this.toSQLKey(dn).getKey(), objectClasses[0]);
            for (DeleteNotifier subscriber : this.subscribers) {
                subscriber.onAfterRemove(dn, objectClasses);
            }
        }
        catch (Exception ex) {
            throw new EntryDeleteException(String.format("Failed to remove entry: '%s'", dn), (Throwable)ex);
        }
    }

    public <T> int remove(String dn, Class<T> entryClass, Filter filter, int count) {
        if (StringHelper.isEmptyString((Object)dn)) {
            throw new MappingException("Base DN to delete entries is null");
        }
        return this.removeImpl(dn, entryClass, filter, count);
    }

    protected <T> int removeImpl(String dn, Class<T> entryClass, Filter filter, int count) {
        ConvertedExpression convertedExpression;
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getTypeObjectClasses(entryClass);
        if (objectClasses.length <= 0) {
            throw new EntryDeleteException(String.format("Failed to delete entries with DN: '%s', filter: '%s' because objectClass is not specified", dn, filter));
        }
        LOG.trace("Filter: {}", (Object)filter);
        Filter searchFilter = this.addObjectClassFilter(filter, objectClasses);
        LOG.trace("-------------------------------------------------------");
        LOG.trace("Filter: {}", (Object)filter);
        LOG.trace("objectClasses count: {} ", (Object)objectClasses.length);
        LOG.trace("objectClasses: {}", (Object)objectClasses.toString());
        LOG.trace("Search filter: {}", (Object)searchFilter);
        List propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Map propertiesAnnotationsMap = this.prepareEntryPropertiesTypes(entryClass, propertiesAnnotations);
        String key = this.toSQLKey(dn).getKey();
        try {
            convertedExpression = this.toSqlFilterWithEmptyAlias(key, objectClasses[0], searchFilter, propertiesAnnotationsMap);
        }
        catch (SearchException ex) {
            throw new EntryDeleteException(String.format("Failed to convert filter '%s' to expression", searchFilter));
        }
        try {
            int processed = (int)this.getOperationService().delete(key, objectClasses[0], convertedExpression, count);
            return processed;
        }
        catch (Exception ex) {
            throw new EntryDeleteException(String.format("Failed to delete entries with key: '%s', expression: '%s'", key, convertedExpression), (Throwable)ex);
        }
    }

    protected List<AttributeData> find(String dn, String[] objectClasses, Map<String, PropertyAnnotation> propertiesAnnotationsMap, String ... ldapReturnAttributes) {
        try {
            ParsedKey keyWithInum = this.toSQLKey(dn);
            List<AttributeData> result = this.getOperationService().lookup(keyWithInum.getKey(), objectClasses[0], this.toInternalAttributes(ldapReturnAttributes));
            if (result != null) {
                return result;
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to find entry: '%s'", dn), (Throwable)ex);
        }
        throw new EntryPersistenceException(String.format("Failed to find entry: '%s'", dn));
    }

    public <T> List<T> findEntries(String baseDN, Class<T> entryClass, Filter filter, SearchScope scope, String[] ldapReturnAttributes, BatchOperation<T> batchOperation, int start, int count, int chunkSize) {
        if (StringHelper.isEmptyString((Object)baseDN)) {
            throw new MappingException("Base DN to find entries is null");
        }
        PagedResult<EntryData> searchResult = this.findEntriesImpl(baseDN, entryClass, filter, scope, ldapReturnAttributes, null, null, batchOperation, SearchReturnDataType.SEARCH, start, count, chunkSize);
        if (searchResult.getEntriesCount() == 0) {
            return new ArrayList(0);
        }
        List<T> entries = this.createEntities(baseDN, entryClass, searchResult);
        return entries;
    }

    public <T> PagedResult<T> findPagedEntries(String baseDN, Class<T> entryClass, Filter filter, String[] ldapReturnAttributes, String sortBy, SortOrder sortOrder, int start, int count, int chunkSize) {
        if (StringHelper.isEmptyString((Object)baseDN)) {
            throw new MappingException("Base DN to find entries is null");
        }
        PagedResult<EntryData> searchResult = this.findEntriesImpl(baseDN, entryClass, filter, SearchScope.SUB, ldapReturnAttributes, sortBy, sortOrder, null, SearchReturnDataType.SEARCH_COUNT, start, count, chunkSize);
        PagedResult result = new PagedResult();
        result.setEntriesCount(searchResult.getEntriesCount());
        result.setStart(searchResult.getStart());
        result.setTotalEntriesCount(searchResult.getTotalEntriesCount());
        if (searchResult.getEntriesCount() == 0) {
            result.setEntries(new ArrayList(0));
            return result;
        }
        List<T> entries = this.createEntities(baseDN, entryClass, searchResult);
        result.setEntries(entries);
        return result;
    }

    protected <T> PagedResult<EntryData> findEntriesImpl(String baseDN, Class<T> entryClass, Filter filter, SearchScope scope, String[] ldapReturnAttributes, String sortBy, SortOrder sortOrder, BatchOperation<T> batchOperation, SearchReturnDataType returnDataType, int start, int count, int chunkSize) {
        ConvertedExpression convertedExpression;
        Filter searchFilter;
        this.checkEntryClass(entryClass, false);
        Object[] objectClasses = this.getTypeObjectClasses(entryClass);
        List propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Object[] currentLdapReturnAttributes = ldapReturnAttributes;
        if (ArrayHelper.isEmpty((Object[])currentLdapReturnAttributes)) {
            currentLdapReturnAttributes = this.getAttributes(null, propertiesAnnotations, false);
        }
        if (objectClasses.length > 0) {
            LOG.trace("Filter: {}", (Object)filter);
            searchFilter = this.addObjectClassFilter(filter, (String[])objectClasses);
        } else {
            searchFilter = filter;
        }
        LOG.trace("-------------------------------------------------------");
        LOG.trace("Filter: {}", (Object)filter);
        LOG.trace("objectClasses count: {} ", (Object)objectClasses.length);
        LOG.trace("objectClasses: {}", (Object)ArrayHelper.toString((Object[])objectClasses));
        LOG.trace("Search filter: {}", (Object)searchFilter);
        Object[] defaultSort = this.getDefaultSort(entryClass);
        if (StringHelper.isNotEmpty((String)sortBy)) {
            Sort requestedSort = this.buildSort(sortBy, sortOrder);
            defaultSort = ArrayHelper.isEmpty((Object[])defaultSort) ? new Sort[]{requestedSort} : (Sort[])ArrayHelper.arrayMerge((Object[][])new Sort[][]{{requestedSort}, defaultSort});
        }
        Map propertiesAnnotationsMap = this.prepareEntryPropertiesTypes(entryClass, propertiesAnnotations);
        String key = this.toSQLKey(baseDN).getKey();
        try {
            convertedExpression = this.toSqlFilter(key, (String)objectClasses[0], searchFilter, propertiesAnnotationsMap);
        }
        catch (SearchException ex) {
            throw new EntryPersistenceException(String.format("Failed to convert filter '%s' to expression", searchFilter), (Throwable)ex);
        }
        PagedResult<EntryData> searchResult = null;
        try {
            SpannerBatchOperationWraper<T> batchOperationWraper = null;
            if (batchOperation != null) {
                batchOperationWraper = new SpannerBatchOperationWraper<T>(batchOperation, this, entryClass, propertiesAnnotations);
            }
            if ((searchResult = this.searchImpl(key, (String)objectClasses[0], convertedExpression, scope, (String[])currentLdapReturnAttributes, (Sort[])defaultSort, batchOperationWraper, returnDataType, start, count, chunkSize)) == null) {
                throw new EntryPersistenceException(String.format("Failed to find entries with key: '%s', expression: '%s'", key, convertedExpression));
            }
            return searchResult;
        }
        catch (SearchException ex) {
            throw new EntryPersistenceException(String.format("Failed to find entries with key: '%s'", key), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to find entries with key: '%s', expression: '%s'", key, convertedExpression), (Throwable)ex);
        }
    }

    protected <T> boolean contains(String baseDN, String[] objectClasses, Class<T> entryClass, List<PropertyAnnotation> propertiesAnnotations, Filter filter, String[] ldapReturnAttributes) {
        ConvertedExpression convertedExpression;
        if (StringHelper.isEmptyString((Object)baseDN)) {
            throw new MappingException("Base DN to check contain entries is null");
        }
        Filter searchFilter = objectClasses.length > 0 ? this.addObjectClassFilter(filter, objectClasses) : filter;
        Map propertiesAnnotationsMap = this.prepareEntryPropertiesTypes(entryClass, propertiesAnnotations);
        String key = this.toSQLKey(baseDN).getKey();
        try {
            convertedExpression = this.toSqlFilter(key, objectClasses[0], searchFilter, propertiesAnnotationsMap);
        }
        catch (SearchException ex) {
            throw new EntryPersistenceException(String.format("Failed to convert filter '%s' to expression", searchFilter));
        }
        PagedResult<EntryData> searchResult = null;
        try {
            searchResult = this.searchImpl(key, objectClasses[0], convertedExpression, SearchScope.SUB, ldapReturnAttributes, null, null, SearchReturnDataType.SEARCH, 0, 1, 0);
            if (searchResult == null) {
                throw new EntryPersistenceException(String.format("Failed to find entry with baseDN: '%s', filter: '%s'", baseDN, searchFilter));
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to find entry with baseDN: '%s', filter: '%s'", baseDN, searchFilter), (Throwable)ex);
        }
        return searchResult != null && searchResult.getEntriesCount() > 0;
    }

    private <O> PagedResult<EntryData> searchImpl(String key, String objectClass, ConvertedExpression expression, SearchScope scope, String[] attributes, Sort[] orderBy, SpannerBatchOperationWraper<O> batchOperationWraper, SearchReturnDataType returnDataType, int start, int count, int pageSize) throws SearchException {
        return this.getOperationService().search(key, objectClass, expression, scope, this.toInternalAttributes(attributes), orderBy, batchOperationWraper, returnDataType, start, count, pageSize);
    }

    protected <T> List<T> createEntities(String baseDN, Class<T> entryClass, PagedResult<EntryData> searchResult) {
        ParsedKey keyWithInum = this.toSQLKey(baseDN);
        List propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        List<T> entries = this.createEntities(entryClass, propertiesAnnotations, keyWithInum, searchResult.getEntries().toArray(new EntryData[searchResult.getEntriesCount()]));
        return entries;
    }

    protected <T> List<T> createEntities(Class<T> entryClass, List<PropertyAnnotation> propertiesAnnotations, ParsedKey baseDn, EntryData ... searchResultEntries) {
        ArrayList result = new ArrayList(searchResultEntries.length);
        LinkedHashMap<String, List> entriesAttributes = new LinkedHashMap<String, List>(100);
        int count = 0;
        for (int i = 0; i < searchResultEntries.length; ++i) {
            ++count;
            EntryData entryData = searchResultEntries[i];
            AttributeData attributeDataDn = entryData.getAttributeDate("dn");
            if (attributeDataDn == null || attributeDataDn.getValue() == null) {
                throw new MappingException("Failed to convert EntryData to Entry because DN is missing");
            }
            entriesAttributes.put(attributeDataDn.getValue().toString(), entryData.getAttributeData());
            searchResultEntries[i] = null;
            if (count < 100) continue;
            List currentResult = this.createEntities(entryClass, propertiesAnnotations, entriesAttributes);
            result.addAll(currentResult);
            entriesAttributes = new LinkedHashMap(100);
            count = 0;
        }
        List currentResult = this.createEntities(entryClass, propertiesAnnotations, entriesAttributes);
        result.addAll(currentResult);
        return result;
    }

    public <T> boolean authenticate(String baseDN, Class<T> entryClass, String userName, String password) {
        ConvertedExpression convertedExpression;
        if (StringHelper.isEmptyString((Object)baseDN)) {
            throw new MappingException("Base DN to find entries is null");
        }
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getTypeObjectClasses(entryClass);
        List propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Filter searchFilter = Filter.createEqualityFilter((String)"uid", (Object)StringHelper.toLowerCase((String)userName));
        if (objectClasses.length > 0) {
            searchFilter = this.addObjectClassFilter(searchFilter, objectClasses);
        }
        Map propertiesAnnotationsMap = this.prepareEntryPropertiesTypes(entryClass, propertiesAnnotations);
        String key = this.toSQLKey(baseDN).getKey();
        try {
            convertedExpression = this.toSqlFilter(key, objectClasses[0], searchFilter, propertiesAnnotationsMap);
        }
        catch (SearchException ex) {
            throw new EntryPersistenceException(String.format("Failed to convert filter '%s' to expression", searchFilter));
        }
        try {
            PagedResult<EntryData> searchResult = this.searchImpl(key, objectClasses[0], convertedExpression, SearchScope.SUB, SpannerOperationService.UID_ARRAY, null, null, SearchReturnDataType.SEARCH, 0, 1, 1);
            if (searchResult == null || searchResult.getEntriesCount() != 1) {
                return false;
            }
            AttributeData attributeData = ((EntryData)searchResult.getEntries().get(0)).getAttributeDate("dn");
            if (attributeData == null || attributeData.getValue() == null) {
                throw new AuthenticationException("Failed to find user DN in entry: '%s'");
            }
            String bindDn = attributeData.getValue().toString();
            return this.authenticate(bindDn, entryClass, password);
        }
        catch (SearchException ex) {
            throw new AuthenticationException(String.format("Failed to find user DN: '%s'", userName), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new AuthenticationException(String.format("Failed to authenticate user: '%s'", userName), (Throwable)ex);
        }
    }

    @Deprecated
    public boolean authenticate(String bindDn, String password) {
        return this.authenticate(bindDn, null, password);
    }

    public <T> boolean authenticate(String bindDn, Class<T> entryClass, String password) {
        if (entryClass == null) {
            throw new UnsupportedOperationException("Entry class is manadatory for authenticate operation!");
        }
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getTypeObjectClasses(entryClass);
        try {
            return this.getOperationService().authenticate(this.toSQLKey(bindDn).getKey(), this.escapeValue(password), objectClasses[0]);
        }
        catch (Exception ex) {
            throw new AuthenticationException(String.format("Failed to authenticate DN: '%s'", bindDn), (Throwable)ex);
        }
    }

    public <T> int countEntries(String baseDN, Class<T> entryClass, Filter filter) {
        return this.countEntries(baseDN, entryClass, filter, SearchScope.SUB);
    }

    public <T> int countEntries(String baseDN, Class<T> entryClass, Filter filter, SearchScope scope) {
        PagedResult<EntryData> searchResult;
        ConvertedExpression convertedExpression;
        if (StringHelper.isEmptyString((Object)baseDN)) {
            throw new MappingException("Base DN to find entries is null");
        }
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getTypeObjectClasses(entryClass);
        List propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Filter searchFilter = objectClasses.length > 0 ? this.addObjectClassFilter(filter, objectClasses) : filter;
        Map propertiesAnnotationsMap = this.prepareEntryPropertiesTypes(entryClass, propertiesAnnotations);
        String key = this.toSQLKey(baseDN).getKey();
        try {
            convertedExpression = this.toSqlFilter(key, objectClasses[0], searchFilter, propertiesAnnotationsMap);
        }
        catch (SearchException ex) {
            throw new EntryPersistenceException(String.format("Failed to convert filter '%s' to expression", searchFilter));
        }
        try {
            searchResult = this.searchImpl(this.toSQLKey(baseDN).getKey(), objectClasses[0], convertedExpression, scope, null, null, null, SearchReturnDataType.COUNT, 0, 0, 0);
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to calculate the number of entries with baseDN: '%s', filter: '%s'", baseDN, searchFilter), (Throwable)ex);
        }
        return searchResult.getTotalEntriesCount();
    }

    private AttributeDataModification createModification(AttributeDataModification.AttributeModificationType type, String attributeName, Boolean multiValued, Object[] attributeValues, Object[] oldAttributeValues) {
        String realAttributeName = attributeName;
        Object[] realValues = attributeValues;
        if (StringHelper.equalsIgnoreCase((String)"userPassword", (String)realAttributeName)) {
            realValues = this.getOperationService().createStoragePassword(StringHelper.toStringArray((Object[])attributeValues));
        }
        this.escapeValues(realValues);
        if (AttributeDataModification.AttributeModificationType.REPLACE == type) {
            this.escapeValues(oldAttributeValues);
            return new AttributeDataModification(type, new AttributeData(realAttributeName, realValues, multiValued), new AttributeData(realAttributeName, oldAttributeValues, multiValued));
        }
        return new AttributeDataModification(type, new AttributeData(realAttributeName, realValues, multiValued));
    }

    protected Sort buildSort(String sortBy, SortOrder sortOrder) {
        Sort requestedSort = null;
        requestedSort = SortOrder.DESCENDING == sortOrder ? new Sort(sortBy, SortOrder.DESCENDING) : (SortOrder.ASCENDING == sortOrder ? new Sort(sortBy, SortOrder.ASCENDING) : new Sort(sortBy, SortOrder.ASCENDING));
        return requestedSort;
    }

    protected <T> Sort[] getDefaultSort(Class<T> entryClass) {
        Object[] sortByProperties = this.getEntrySortByNames(entryClass);
        if (ArrayHelper.isEmpty((Object[])sortByProperties) && ArrayHelper.isEmpty((Object[])(sortByProperties = this.getEntrySortByProperties(entryClass)))) {
            return null;
        }
        Sort[] sort = new Sort[sortByProperties.length];
        for (int i = 0; i < sortByProperties.length; ++i) {
            sort[i] = new Sort((String)sortByProperties[i], SortOrder.ASCENDING);
        }
        return sort;
    }

    public List<AttributeData> exportEntry(String dn) {
        throw new EntryPersistenceException("This is deprectated method. Use exportEntry(String dn, Class<T> entryClass) instead of it!");
    }

    public List<AttributeData> exportEntry(String dn, String objectClass) {
        if (StringHelper.isEmpty((String)objectClass)) {
            throw new MappingException("Object class isn't defined!");
        }
        try {
            ParsedKey keyWithInum = this.toSQLKey(dn);
            List<AttributeData> entry = this.getOperationService().lookup(keyWithInum.getKey(), objectClass, new String[0]);
            if (entry != null) {
                return entry;
            }
            return null;
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to find entry: '%s'", dn), (Throwable)ex);
        }
    }

    private ConvertedExpression toSqlFilter(String key, String objectClass, Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap) throws SearchException {
        TableMapping tableMapping = this.getOperationService().getTabeMapping(key, objectClass);
        if (tableMapping == null) {
            throw new MappingException(String.format("Failed to get table mapping by key '%s' and objectClass '%s'", key, objectClass));
        }
        return this.filterConverter.convertToSqlFilter(tableMapping, this.excludeObjectClassFilters(genericFilter), propertiesAnnotationsMap);
    }

    private ConvertedExpression toSqlFilterWithEmptyAlias(String key, String objectClass, Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap) throws SearchException {
        TableMapping tableMapping = this.getOperationService().getTabeMapping(key, objectClass);
        if (tableMapping == null) {
            throw new MappingException(String.format("Failed to get table mapping by key '%s' and objectClass '%s'", key, objectClass));
        }
        return this.filterConverter.convertToSqlFilter(tableMapping, this.excludeObjectClassFilters(genericFilter), propertiesAnnotationsMap, true);
    }

    private Filter excludeObjectClassFilters(Filter genericFilter) {
        return this.filterProcessor.excludeFilter(genericFilter, new Filter[]{FilterProcessor.OBJECT_CLASS_EQUALITY_FILTER, FilterProcessor.OBJECT_CLASS_PRESENCE_FILTER});
    }

    private ParsedKey toSQLKey(String dn) {
        return KEY_CONVERTER.convertToKey(dn);
    }

    protected Filter addObjectClassFilter(Filter filter, String[] objectClasses) {
        return filter;
    }

    public String encodeTime(String baseDN, Date date) {
        if (date == null) {
            return null;
        }
        return Timestamp.of((Date)date).toString();
    }

    protected String encodeTime(Date date) {
        return this.encodeTime(null, date);
    }

    public Date decodeTime(String baseDN, String date) {
        Date decodedDate;
        if (StringHelper.isEmpty((String)date)) {
            return null;
        }
        try {
            decodedDate = Timestamp.parseTimestamp((String)date).toDate();
        }
        catch (Exception ex) {
            LOG.error("Failed to decode generalized time '{}'", (Object)date, (Object)ex);
            return null;
        }
        return decodedDate;
    }

    public Date decodeTime(String date) {
        return this.decodeTime(null, date);
    }

    public boolean hasBranchesSupport(String dn) {
        return false;
    }

    public boolean hasExpirationSupport(String primaryKey) {
        return false;
    }

    public String getPersistenceType() {
        return SpannerEntryManagerFactory.PERSISTENCE_TYPE;
    }

    public String getPersistenceType(String primaryKey) {
        return SpannerEntryManagerFactory.PERSISTENCE_TYPE;
    }

    public PersistenceEntryManager getPersistenceEntryManager(String persistenceType) {
        if (SpannerEntryManagerFactory.PERSISTENCE_TYPE.equals(persistenceType)) {
            return this;
        }
        return null;
    }

    protected Object convertJsonToValue(Class<?> parameterType, Object propertyValue) {
        return super.convertJsonToValue(parameterType, propertyValue);
    }

    protected Object getNativeDateAttributeValue(Date dateValue) {
        return dateValue;
    }

    protected Object getNativeDateMultiAttributeValue(Date dateValue) {
        SimpleDateFormat jsonDateFormat = new SimpleDateFormat(JSON_DATA_FORMAT);
        return jsonDateFormat.format(dateValue);
    }

    protected boolean isStoreFullEntry() {
        return true;
    }

    private String escapeValue(String value) {
        return ((SpannerOperationService)this.operationService).escapeValue(value);
    }

    private void escapeValues(Object[] realValues) {
        ((SpannerOperationService)this.operationService).escapeValues(realValues);
    }

    public String toInternalAttribute(String attributeName) {
        return ((SpannerOperationService)this.operationService).toInternalAttribute(attributeName);
    }

    public String[] toInternalAttributes(String[] attributeNames) {
        return ((SpannerOperationService)this.operationService).toInternalAttributes(attributeNames);
    }

    public String fromInternalAttribute(String internalAttributeName) {
        return ((SpannerOperationService)this.operationService).fromInternalAttribute(internalAttributeName);
    }

    public String[] fromInternalAttributes(String[] internalAttributeNames) {
        return ((SpannerOperationService)this.operationService).fromInternalAttributes(internalAttributeNames);
    }

    protected boolean isSupportForceUpdate() {
        return true;
    }
}

