/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.cloud.spanner.operation.impl;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Type;
import io.jans.orm.cloud.spanner.model.TableMapping;
import io.jans.orm.exception.KeyConversionException;
import io.jans.orm.exception.MappingException;
import io.jans.orm.exception.operation.ConfigurationException;
import io.jans.orm.exception.operation.ConnectionException;
import io.jans.orm.operation.auth.PasswordEncryptionMethod;
import io.jans.orm.util.ArrayHelper;
import io.jans.orm.util.PropertiesHelper;
import io.jans.orm.util.StringHelper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpannerConnectionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SpannerConnectionProvider.class);
    private static final String QUERY_HEALTH_CHECK = "SELECT 1";
    private static final String QUERY_PARENT_TABLE = "SELECT TABLE_NAME, PARENT_TABLE_NAME FROM information_schema.tables WHERE table_catalog = '' and table_schema = '' and parent_table_name is NOT NULL";
    private static final String QUERY_TABLE_SCHEMA = "SELECT TABLE_NAME, COLUMN_NAME, SPANNER_TYPE, IS_NULLABLE FROM information_schema.columns WHERE table_catalog = '' and table_schema = ''";
    private static final String CLIENT_PROPERTIES_PREFIX = "connection.client-property";
    private Properties props;
    private Properties clientConnectionProperties;
    private int creationResultCode;
    private ArrayList<String> binaryAttributes;
    private ArrayList<String> certificateAttributes;
    private PasswordEncryptionMethod passwordEncryptionMethod;
    private String connectionProject;
    private String connectionInstance;
    private String connectionDatabase;
    private String connectionEmulatorHost;
    private String connectionCredentialsFile;
    private long defaultMaximumResultSize;
    private long maximumResultDeleteSize;
    private Map<String, Map<String, Type.StructField>> tableColumnsMap;
    private Map<String, Set<String>> tableNullableColumnsSet;
    private Map<String, Set<String>> tableChildAttributesMap;
    private DatabaseClient dbClient;
    private Spanner spanner;

    protected SpannerConnectionProvider() {
    }

    public SpannerConnectionProvider(Properties props) {
        this.props = props;
        this.tableColumnsMap = new HashMap<String, Map<String, Type.StructField>>();
        this.tableNullableColumnsSet = new HashMap<String, Set<String>>();
        this.tableChildAttributesMap = new HashMap<String, Set<String>>();
    }

    public void create() {
        try {
            this.init();
        }
        catch (Exception ex) {
            this.creationResultCode = 1;
            Properties clonedProperties = (Properties)this.props.clone();
            LOG.error("Failed to create connection with properties: '{}'. Exception: {}", (Object)clonedProperties, (Object)ex);
        }
    }

    protected void init() throws Exception {
        String[] binaryAttrs;
        if (!this.props.containsKey("connection.project")) {
            throw new ConfigurationException("Property 'connection.project' is mandatory!");
        }
        this.connectionProject = this.props.getProperty("connection.project");
        if (!this.props.containsKey("connection.instance")) {
            throw new ConfigurationException("Property 'connection.instance' is mandatory!");
        }
        this.connectionInstance = this.props.getProperty("connection.instance");
        if (!this.props.containsKey("connection.database")) {
            throw new ConfigurationException("Property 'connection.database' is mandatory!");
        }
        this.connectionDatabase = this.props.getProperty("connection.database");
        if (this.props.containsKey("connection.emulator-host")) {
            this.connectionEmulatorHost = this.props.getProperty("connection.emulator-host");
        }
        Properties filteredDriverProperties = PropertiesHelper.findProperties((Properties)this.props, (String)CLIENT_PROPERTIES_PREFIX, (String)".");
        this.clientConnectionProperties = new Properties();
        for (Map.Entry<Object, Object> driverPropertyEntry : filteredDriverProperties.entrySet()) {
            String key = StringHelper.toString((Object)driverPropertyEntry.getKey()).substring(CLIENT_PROPERTIES_PREFIX.length() + 1);
            String value = StringHelper.toString((Object)driverPropertyEntry.getValue());
            this.clientConnectionProperties.put(key, value);
        }
        if (this.props.containsKey("statement.limit.default-maximum-result-size")) {
            this.defaultMaximumResultSize = StringHelper.toLong((String)this.props.getProperty("statement.limit.default-maximum-result-size"), (long)1000L);
        }
        if (this.props.containsKey("statement.limit.maximum-result-delete-size")) {
            this.maximumResultDeleteSize = StringHelper.toLong((String)this.props.getProperty("statement.limit.maximum-result-delete-size"), (long)10000L);
        }
        this.connectionCredentialsFile = null;
        if (this.props.containsKey("connection.credentials-file")) {
            this.connectionCredentialsFile = this.props.getProperty("connection.credentials-file");
        }
        this.openWithWaitImpl();
        LOG.info("Created connection pool");
        this.passwordEncryptionMethod = this.props.containsKey("password.encryption.method") ? PasswordEncryptionMethod.getMethod((String)this.props.getProperty("password.encryption.method")) : PasswordEncryptionMethod.HASH_METHOD_SHA256;
        this.binaryAttributes = new ArrayList();
        if (this.props.containsKey("binaryAttributes")) {
            binaryAttrs = StringHelper.split((String)this.props.get("binaryAttributes").toString().toLowerCase(), (String)",");
            this.binaryAttributes.addAll(Arrays.asList(binaryAttrs));
        }
        LOG.debug("Using next binary attributes: '{}'", this.binaryAttributes);
        this.certificateAttributes = new ArrayList();
        if (this.props.containsKey("certificateAttributes")) {
            binaryAttrs = StringHelper.split((String)this.props.get("certificateAttributes").toString().toLowerCase(), (String)",");
            this.certificateAttributes.addAll(Arrays.asList(binaryAttrs));
        }
        LOG.debug("Using next binary certificateAttributes: '{}'", this.certificateAttributes);
        this.loadTableMetaData();
        this.creationResultCode = 0;
    }

    private void loadTableMetaData() {
        LOG.info("Scanning DB metadata...");
        long takes = System.currentTimeMillis();
        try (ResultSet resultSet = this.executeQuery(QUERY_PARENT_TABLE);){
            if (resultSet.next()) {
                int tableNameIdx = resultSet.getColumnIndex("TABLE_NAME");
                int parentTableNameIdx = resultSet.getColumnIndex("PARENT_TABLE_NAME");
                do {
                    Set<Object> childAttributes;
                    String parentTableName = resultSet.getString(parentTableNameIdx);
                    String tableName = resultSet.getString(tableNameIdx);
                    if (this.tableChildAttributesMap.containsKey(parentTableName)) {
                        childAttributes = this.tableChildAttributesMap.get(parentTableName);
                    } else {
                        childAttributes = new HashSet();
                        this.tableChildAttributesMap.put(parentTableName, childAttributes);
                    }
                    if (tableName.startsWith(parentTableName + "_")) {
                        tableName = tableName.substring(parentTableName.length() + 1);
                    }
                    childAttributes.add(tableName);
                } while (resultSet.next());
            }
        }
        catch (SpannerException ex) {
            throw new ConnectionException("Failed to get database metadata", (Throwable)ex);
        }
        LOG.debug("Build child attributes map: '{}'.", this.tableChildAttributesMap);
        HashMap<String, Type> typeMap = this.buildSpannerTypesMap();
        try (ResultSet resultSet = this.executeQuery(QUERY_TABLE_SCHEMA);){
            if (resultSet.next()) {
                int tableNameIdx = resultSet.getColumnIndex("TABLE_NAME");
                int columnNameIdx = resultSet.getColumnIndex("COLUMN_NAME");
                int spannerTypeIdx = resultSet.getColumnIndex("SPANNER_TYPE");
                int isNullableIdx = resultSet.getColumnIndex("IS_NULLABLE");
                do {
                    Set<Object> nullableColumns;
                    Map<Object, Object> tableColumns;
                    String tableName = resultSet.getString(tableNameIdx);
                    String columnName = resultSet.getString(columnNameIdx);
                    String spannerType = resultSet.getString(spannerTypeIdx);
                    String isNullable = resultSet.getString(isNullableIdx);
                    if (this.tableColumnsMap.containsKey(tableName)) {
                        tableColumns = this.tableColumnsMap.get(tableName);
                    } else {
                        tableColumns = new HashMap();
                        this.tableColumnsMap.put(tableName, tableColumns);
                    }
                    String comparebleType = SpannerConnectionProvider.toComparableType(spannerType);
                    Type type = typeMap.get(comparebleType);
                    if (type == null) {
                        throw new ConnectionException(String.format("Failed to parse SPANNER_TYPE: '%s'", spannerType));
                    }
                    tableColumns.put(columnName.toLowerCase(), Type.StructField.of((String)columnName, (Type)type));
                    if (this.tableNullableColumnsSet.containsKey(tableName)) {
                        nullableColumns = this.tableNullableColumnsSet.get(tableName);
                    } else {
                        nullableColumns = new HashSet();
                        this.tableNullableColumnsSet.put(tableName, nullableColumns);
                    }
                    boolean nullable = "yes".equalsIgnoreCase(isNullable);
                    if (!nullable) continue;
                    nullableColumns.add(columnName.toLowerCase());
                } while (resultSet.next());
            }
        }
        catch (SpannerException ex) {
            throw new ConnectionException("Failed to get database metadata", (Throwable)ex);
        }
        LOG.debug("Build table columns map: '{}'.", this.tableColumnsMap);
        takes = System.currentTimeMillis() - takes;
        LOG.info("Metadata scan finisehd in {} milliseconds", (Object)takes);
    }

    private HashMap<String, Type> buildSpannerTypesMap() {
        HashMap<String, Type> typeMap = new HashMap<String, Type>();
        this.addSpannerType(typeMap, Type.bool());
        this.addSpannerType(typeMap, Type.int64());
        this.addSpannerType(typeMap, Type.numeric());
        this.addSpannerType(typeMap, Type.float64());
        this.addSpannerType(typeMap, Type.string());
        this.addSpannerType(typeMap, Type.bytes());
        this.addSpannerType(typeMap, Type.timestamp());
        this.addSpannerType(typeMap, Type.date());
        return typeMap;
    }

    private static String toComparableType(String spannerType) {
        int idx = spannerType.indexOf("(");
        if (idx != -1) {
            spannerType = spannerType.substring(0, idx);
        }
        if ((idx = spannerType.indexOf(">")) == -1) {
            return spannerType.toLowerCase();
        }
        return spannerType.substring(0, idx).toLowerCase();
    }

    private void addSpannerType(HashMap<String, Type> typeMap, Type type) {
        typeMap.put(type.toString().toLowerCase(), type);
        typeMap.put(Type.Code.ARRAY.name().toLowerCase() + "<" + type.toString().toLowerCase(), Type.array((Type)type));
    }

    private void openWithWaitImpl() throws Exception {
        long connectionMaxWaitTimeMillis = StringHelper.toLong((String)this.props.getProperty("connection.client.create-max-wait-time-millis"), (long)30000L);
        LOG.debug("Using connection timeout: '{}'", (Object)connectionMaxWaitTimeMillis);
        Exception lastException = null;
        int attempt = 0;
        long currentTime = System.currentTimeMillis();
        long maxWaitTime = currentTime + connectionMaxWaitTimeMillis;
        while (true) {
            if (++attempt > 0) {
                LOG.info("Attempting to create client connection: '{}'", (Object)attempt);
            }
            try {
                this.open();
                if (!this.isConnected()) {
                    LOG.info("Failed to connect to Spanner");
                    this.destroy();
                    throw new ConnectionException("Failed to create client connection");
                }
            }
            catch (Exception ex) {
                lastException = ex;
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException ex2) {
                    LOG.error("Exception happened in sleep", (Throwable)ex2);
                    return;
                }
                if (maxWaitTime > (currentTime = System.currentTimeMillis())) continue;
            }
            break;
        }
        if (lastException != null) {
            throw lastException;
        }
    }

    private void open() throws FileNotFoundException, IOException {
        SpannerOptions.Builder optionsBuilder = SpannerOptions.newBuilder();
        if (StringHelper.isNotEmpty((String)this.connectionEmulatorHost)) {
            optionsBuilder.setEmulatorHost(this.connectionEmulatorHost);
        }
        if (StringHelper.isNotEmpty((String)this.connectionCredentialsFile)) {
            optionsBuilder.setCredentials((Credentials)GoogleCredentials.fromStream((InputStream)new FileInputStream(this.connectionCredentialsFile)));
        } else {
            optionsBuilder.setCredentials((Credentials)NoCredentials.getInstance());
        }
        optionsBuilder.setProjectId(this.connectionProject);
        DatabaseId databaseId = DatabaseId.of((String)this.connectionProject, (String)this.connectionInstance, (String)this.connectionDatabase);
        this.spanner = (Spanner)optionsBuilder.build().getService();
        this.dbClient = this.spanner.getDatabaseClient(databaseId);
    }

    public boolean destroy() {
        boolean result = true;
        if (this.spanner != null) {
            try {
                this.spanner.close();
            }
            catch (RuntimeException ex) {
                LOG.error("Failed to close spanner instance", (Throwable)ex);
                result = false;
            }
        }
        return result;
    }

    public boolean isConnected() {
        boolean bl;
        block9: {
            if (this.dbClient == null) {
                return false;
            }
            boolean isConnected = true;
            ResultSet resultSet = this.executeQuery(QUERY_HEALTH_CHECK);
            try {
                bl = resultSet.next();
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    LOG.error("Failed to check connection", (Throwable)ex);
                    isConnected = false;
                    return isConnected;
                }
            }
            resultSet.close();
        }
        return bl;
    }

    public int getCreationResultCode() {
        return this.creationResultCode;
    }

    public boolean isCreated() {
        return 0 == this.creationResultCode;
    }

    public ArrayList<String> getBinaryAttributes() {
        return this.binaryAttributes;
    }

    public ArrayList<String> getCertificateAttributes() {
        return this.certificateAttributes;
    }

    public boolean isBinaryAttribute(String attributeName) {
        if (StringHelper.isEmpty((String)attributeName)) {
            return false;
        }
        return this.binaryAttributes.contains(attributeName.toLowerCase());
    }

    public boolean isCertificateAttribute(String attributeName) {
        if (StringHelper.isEmpty((String)attributeName)) {
            return false;
        }
        return this.certificateAttributes.contains(attributeName.toLowerCase());
    }

    public PasswordEncryptionMethod getPasswordEncryptionMethod() {
        return this.passwordEncryptionMethod;
    }

    public TableMapping getTableMappingByKey(String key, String objectClass, String tableName) {
        Map<String, Type.StructField> columTypes = this.tableColumnsMap.get(tableName);
        if (!this.tableColumnsMap.containsKey(tableName)) {
            throw new MappingException(String.format("Table '%s' metadata is not exists '", tableName));
        }
        if ("_".equals(key)) {
            return new TableMapping("", tableName, objectClass, columTypes);
        }
        Object[] baseNameParts = key.split("_");
        if (ArrayHelper.isEmpty((Object[])baseNameParts)) {
            throw new KeyConversionException("Failed to determine base key part!");
        }
        TableMapping tableMapping = new TableMapping((String)baseNameParts[0], tableName, objectClass, columTypes);
        return tableMapping;
    }

    public TableMapping getTableMappingByKey(String key, String objectClass) {
        return this.getTableMappingByKey(key, objectClass, objectClass);
    }

    public TableMapping getChildTableMappingByKey(String key, TableMapping tableMapping, String columnName) {
        String childTableName = tableMapping.getTableName() + "_" + columnName;
        TableMapping childTableMapping = this.getTableMappingByKey(key, tableMapping.getObjectClass(), childTableName);
        return childTableMapping;
    }

    public Set<String> getTableChildAttributes(String objectClass) {
        return this.tableChildAttributesMap.get(objectClass);
    }

    public Map<String, TableMapping> getChildTablesMapping(String key, TableMapping tableMapping) {
        Set<String> childAttributes = this.tableChildAttributesMap.get(tableMapping.getObjectClass());
        if (childAttributes == null) {
            return null;
        }
        HashMap<String, TableMapping> childTableMapping = new HashMap<String, TableMapping>();
        for (String childAttribute : childAttributes) {
            TableMapping childColumTypes = this.getChildTableMappingByKey(key, tableMapping, childAttribute);
            childTableMapping.put(childAttribute.toLowerCase(), childColumTypes);
        }
        return childTableMapping;
    }

    public Set<String> getTableNullableColumns(String objectClass) {
        return this.tableNullableColumnsSet.get(objectClass);
    }

    public DatabaseClient getClient() {
        return this.dbClient;
    }

    private ResultSet executeQuery(String sql) {
        return this.dbClient.singleUse().executeQuery(Statement.of((String)sql), new Options.QueryOption[0]);
    }

    public Map<String, Map<String, Type.StructField>> getDatabaseMetaData() {
        return this.tableColumnsMap;
    }

    public long getDefaultMaximumResultSize() {
        return this.defaultMaximumResultSize;
    }

    public long getMaximumResultDeleteSize() {
        return this.maximumResultDeleteSize;
    }
}

