/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.sql;

import io.jans.orm.model.SearchScope;
import io.jans.orm.search.filter.Filter;
import io.jans.orm.sql.impl.SqlEntryManager;
import io.jans.orm.sql.model.SimpleSession;
import io.jans.orm.sql.operation.impl.SqlConnectionProvider;
import io.jans.orm.sql.persistence.SqlEntryManagerSample;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SqlSessionSample {
    private static final Logger LOG = LoggerFactory.getLogger(SqlConnectionProvider.class);

    private SqlSessionSample() {
    }

    public static void main(String[] args) {
        SqlEntryManagerSample sqlEntryManagerSample = new SqlEntryManagerSample();
        SqlEntryManager sqlEntryManager = sqlEntryManagerSample.createSqlEntryManager();
        String key = UUID.randomUUID().toString();
        String sessionDn = String.format("jansId=%s,%s", key, "ou=sessions,o=jans");
        int expirationInSeconds = 60;
        Calendar expirationDate = Calendar.getInstance();
        expirationDate.setTime(new Date());
        expirationDate.add(13, expirationInSeconds);
        SimpleSession entity = new SimpleSession();
        entity.setDeviceSecrets(Arrays.asList("secret1", "secret2"));
        entity.setId(key);
        entity.setDn(sessionDn);
        entity.setSessionAttributes(new HashMap<String, Object>());
        entity.getSessionAttributes().put("exp", expirationDate.getTimeInMillis());
        entity.getSessionAttributes().put("uid", Math.random() > 0.5 ? "mike" : "jorge");
        entity.getSessionAttributes().put("test", Math.random() > 0.5);
        sqlEntryManager.persist((Object)entity);
        sqlEntryManager.merge((Object)entity);
        SimpleSession loadedEntity = (SimpleSession)sqlEntryManager.find(SimpleSession.class, (Object)sessionDn);
        System.out.println(String.format("Loaded entry with uid = %s, type = %s", loadedEntity.getSessionAttributes().get("uid"), loadedEntity.getSessionAttributes().get("uid").getClass()));
        System.out.println(String.format("Loaded entry with exp = %s, type = %s", loadedEntity.getSessionAttributes().get("exp"), loadedEntity.getSessionAttributes().get("exp").getClass()));
        System.out.println(String.format("Loaded entry with test = %s, type = %s", loadedEntity.getSessionAttributes().get("test"), loadedEntity.getSessionAttributes().get("test").getClass()));
        Filter filterAuthenticated = Filter.createEqualityFilter((String)"jansId", (Object)key);
        List sessions1 = sqlEntryManager.findEntries("o=jans", SimpleSession.class, filterAuthenticated, SearchScope.SUB, null, null, 0, 0, 0);
        LOG.info("Found sessions: " + sessions1.size());
        Filter filterDeviceSecret = Filter.createEqualityFilter((String)"deviceSecret", (Object)"secret2");
        List sessions2 = sqlEntryManager.findEntries("o=jans", SimpleSession.class, filterDeviceSecret, SearchScope.SUB, null, null, 0, 0, 0);
        LOG.info("Found sessions: " + sessions2.size());
        Filter filterSessAttr1 = Filter.createEqualityFilter((String)"jansSessAttr.uid", (Object)"mike");
        List sessAttr1 = sqlEntryManager.findEntries("o=jans", SimpleSession.class, filterSessAttr1, SearchScope.SUB, null, null, 0, 0, 0);
        LOG.info("Found sessions by uid=mike: " + sessAttr1.size());
        Filter filterSessAttr2 = Filter.createEqualityFilter((String)"jansSessAttr.uid", (Object)"jorge");
        List sessAttr2 = sqlEntryManager.findEntries("o=jans", SimpleSession.class, filterSessAttr2, SearchScope.SUB, null, null, 0, 0, 0);
        LOG.info("Found sessions by uid=jorge: " + sessAttr2.size());
        Filter filterSessAttr3 = Filter.createEqualityFilter((String)"jansSessAttr.exp", (Object)expirationDate.getTimeInMillis());
        List sessAttr3 = sqlEntryManager.findEntries("o=jans", SimpleSession.class, filterSessAttr3, SearchScope.SUB, null, null, 0, 0, 0);
        LOG.info(String.format("Found sessions by exp == %d: " + sessAttr3.size(), expirationDate.getTimeInMillis()));
        Filter filterSessAttr4 = Filter.createEqualityFilter((String)"jansSessAttr.test", (Object)true);
        List sessAttr4 = sqlEntryManager.findEntries("o=jans", SimpleSession.class, filterSessAttr4, SearchScope.SUB, null, null, 0, 0, 0);
        LOG.info("Found sessions by test == true: " + sessAttr4.size());
        Filter filterSessAttr5 = Filter.createEqualityFilter((String)"jansSessAttr.test", (Object)false);
        List sessAttr5 = sqlEntryManager.findEntries("o=jans", SimpleSession.class, filterSessAttr5, SearchScope.SUB, null, null, 0, 0, 0);
        LOG.info("Found sessions by test == false: " + sessAttr5.size());
        Filter filterSessAttr6 = Filter.createGreaterOrEqualFilter((String)"jansSessAttr.exp", (Object)expirationDate.getTimeInMillis());
        List sessAttr6 = sqlEntryManager.findEntries("o=jans", SimpleSession.class, filterSessAttr6, SearchScope.SUB, null, null, 0, 0, 0);
        LOG.info(String.format("Found sessions by exp >= %d: " + sessAttr6.size(), expirationDate.getTimeInMillis()));
        Filter filterSessAttr7 = Filter.createLessOrEqualFilter((String)"jansSessAttr.exp", (Object)expirationDate.getTimeInMillis());
        List sessAttr7 = sqlEntryManager.findEntries("o=jans", SimpleSession.class, filterSessAttr7, SearchScope.SUB, null, null, 0, 0, 0);
        LOG.info(String.format("Found sessions by exp <= %d: " + sessAttr7.size(), expirationDate.getTimeInMillis()));
        Filter filterSessAttr8 = Filter.createSubstringFilter((String)"jansSessAttr.uid", null, (String[])new String[]{"rg"}, null);
        List sessAttr8 = sqlEntryManager.findEntries("o=jans", SimpleSession.class, filterSessAttr8, SearchScope.SUB, null, null, 0, 0, 0);
        LOG.info("Found sessions by uid == *rg*: " + sessAttr8.size());
        Filter filterSessAttr9 = Filter.createPresenceFilter((String)"jansSessAttr.uid");
        List sessAttr9 = sqlEntryManager.findEntries("o=jans", SimpleSession.class, filterSessAttr9, SearchScope.SUB, null, null, 0, 0, 0);
        LOG.info("Found sessions by uid == *: " + sessAttr9.size());
    }
}

