/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.sql.model;

import io.jans.orm.annotation.AttributeEnum;
import java.util.HashMap;
import java.util.Map;

public enum Status implements AttributeEnum
{
    ACTIVE("active", "Active"),
    INACTIVE("inactive", "Inactive"),
    EXPIRED("expired", "Expired"),
    REGISTER("register", "Register");

    private String value;
    private String displayName;
    private static Map<String, Status> MAP_BY_VALUES;

    private Status(String value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static Status getByValue(String value) {
        return MAP_BY_VALUES.get(value);
    }

    public Enum<? extends AttributeEnum> resolveByValue(String value) {
        return Status.getByValue(value);
    }

    public String toString() {
        return this.value;
    }

    static {
        MAP_BY_VALUES = new HashMap<String, Status>();
        for (Status enumType : Status.values()) {
            MAP_BY_VALUES.put(enumType.getValue(), enumType);
        }
    }
}

