/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.sql;

import io.jans.orm.search.filter.Filter;
import io.jans.orm.sql.impl.SqlEntryManager;
import io.jans.orm.sql.model.SimpleClient;
import io.jans.orm.sql.operation.impl.SqlConnectionProvider;
import io.jans.orm.sql.persistence.SqlEntryManagerSample;
import io.jans.orm.util.ArrayHelper;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SqlSimpleClientSample {
    private static final Logger LOG = LoggerFactory.getLogger(SqlConnectionProvider.class);

    private SqlSimpleClientSample() {
    }

    public static void main(String[] args) {
        SqlEntryManagerSample sqlEntryManagerSample = new SqlEntryManagerSample();
        SqlEntryManager sqlEntryManager = sqlEntryManagerSample.createSqlEntryManager();
        SimpleClient newClient = new SimpleClient();
        newClient.setDn("inum=test_acr2,ou=client,o=jans");
        newClient.setDefaultAcrValues(new String[]{"test_acr2"});
        newClient.setClientName("test_acr2");
        sqlEntryManager.persist((Object)newClient);
        Filter presenceFilter = Filter.createEqualityFilter((String)"displayName", (Object)"test_acr2");
        List results = sqlEntryManager.findEntries("ou=client,o=jans", SimpleClient.class, presenceFilter);
        for (SimpleClient client : results) {
            Object[] acrs = client.getDefaultAcrValues();
            if (!ArrayHelper.isNotEmpty((Object[])acrs)) continue;
            System.out.println(Arrays.toString(acrs));
        }
        sqlEntryManager.remove(newClient.getDn(), SimpleClient.class);
    }
}

