/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.sql;

import io.jans.orm.model.base.CustomObjectAttribute;
import io.jans.orm.search.filter.Filter;
import io.jans.orm.sql.impl.SqlEntryManager;
import io.jans.orm.sql.model.SimpleUser;
import io.jans.orm.sql.operation.impl.SqlConnectionProvider;
import io.jans.orm.sql.persistence.SqlEntryManagerSample;
import io.jans.orm.util.StringHelper;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SqlCustomMultiValuedTypesSample {
    private static final Logger LOG = LoggerFactory.getLogger(SqlConnectionProvider.class);

    private SqlCustomMultiValuedTypesSample() {
    }

    public static void main(String[] args) {
        SqlEntryManagerSample sqlEntryManagerSample = new SqlEntryManagerSample();
        SqlEntryManager sqlEntryManager = sqlEntryManagerSample.createSqlEntryManager();
        SimpleUser newUser = new SimpleUser();
        newUser.setDn(String.format("inum=%s,ou=people,o=jans", System.currentTimeMillis()));
        newUser.setUserId("sample_user_" + System.currentTimeMillis());
        newUser.setUserPassword("test");
        newUser.getCustomAttributes().add(new CustomObjectAttribute("jansOptOuts", Arrays.asList("London", "Texas", "Kiev")));
        newUser.getCustomAttributes().add(new CustomObjectAttribute("jansExtUid", (Object)"test_value").multiValued());
        newUser.getCustomAttributes().add(new CustomObjectAttribute("jansPPID", (Object)"test_value").multiValued());
        newUser.setMemberOf(Arrays.asList("group_1", "group_2", "group_3"));
        newUser.setAttributeValue("givenName", "john");
        sqlEntryManager.persist((Object)newUser);
        LOG.info("Added User '{}' with uid '{}' and key '{}'", new Object[]{newUser, newUser.getUserId(), newUser.getDn()});
        LOG.info("Persisted custom attributes '{}'", newUser.getCustomAttributes());
        SimpleUser foundUser = (SimpleUser)sqlEntryManager.find(SimpleUser.class, (Object)newUser.getDn());
        LOG.info("Found User '{}' with uid '{}' and key '{}'", new Object[]{foundUser, foundUser.getUserId(), foundUser.getDn()});
        LOG.info("Custom attributes '{}'", foundUser.getCustomAttributes());
        for (CustomObjectAttribute attr : foundUser.getCustomAttributes()) {
            System.out.println(attr.getName() + " - " + attr.getValues());
        }
        foundUser.setAttributeValues("jansOptOuts", Arrays.asList("London", "Texas", "Kiev", "Dublin"));
        foundUser.setAttributeValues("jansExtUid", Arrays.asList("test_value_11", "test_value_22", "test_value_33", "test_value_44"));
        foundUser.setAttributeValues("jansExtUid", Arrays.asList(11, 22, 33, 44));
        foundUser.setAttributeValues("jansPPID", Arrays.asList("fuzzy_value_1", "fuzzy_value_2"));
        foundUser.setAttributeValue("jansGuid", "simple");
        CustomObjectAttribute multiValuedSingleValue = new CustomObjectAttribute("jansAssociatedClnt", (Object)"multivalued_single_valued");
        multiValuedSingleValue.setMultiValued(true);
        foundUser.getCustomAttributes().add(multiValuedSingleValue);
        sqlEntryManager.merge((Object)foundUser);
        LOG.info("Updated custom attributes '{}'", foundUser.getCustomAttributes());
        SimpleUser foundUpdatedUser = (SimpleUser)sqlEntryManager.find(SimpleUser.class, (Object)newUser.getDn());
        LOG.info("Found User '{}' with uid '{}' and key '{}'", new Object[]{foundUpdatedUser, foundUpdatedUser.getUserId(), foundUpdatedUser.getDn()});
        LOG.info("Cusom attributes '{}'", foundUpdatedUser.getCustomAttributes());
        for (CustomObjectAttribute attr : foundUser.getCustomAttributes()) {
            System.out.println(attr.getName() + " - " + attr.getValues());
        }
        Filter filter = Filter.createEqualityFilter((Filter)Filter.createLowercaseFilter((String)"givenName"), (Object)StringHelper.toLowerCase((String)"john"));
        List foundUpdatedUsers = sqlEntryManager.findEntries("o=jans", SimpleUser.class, filter);
        System.out.println(foundUpdatedUsers);
    }
}

