/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.sql;

import io.jans.orm.model.base.CustomObjectAttribute;
import io.jans.orm.search.filter.Filter;
import io.jans.orm.sql.impl.SqlEntryManager;
import io.jans.orm.sql.model.SimpleUser;
import io.jans.orm.sql.model.UserRole;
import io.jans.orm.sql.operation.impl.SqlConnectionProvider;
import io.jans.orm.sql.persistence.SqlEntryManagerSample;
import io.jans.orm.util.StringHelper;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SqlCustomObjectAttributesSample {
    private static final Logger LOG = LoggerFactory.getLogger(SqlConnectionProvider.class);

    private SqlCustomObjectAttributesSample() {
    }

    public static void main(String[] args) {
        SqlEntryManagerSample sqlEntryManagerSample = new SqlEntryManagerSample();
        SqlEntryManager sqlEntryManager = sqlEntryManagerSample.createSqlEntryManager();
        SimpleUser newUser = new SimpleUser();
        newUser.setDn(String.format("inum=%s,ou=people,o=jans", System.currentTimeMillis()));
        newUser.setUserId("sample_user_" + System.currentTimeMillis());
        newUser.setUserPassword("test");
        newUser.getCustomAttributes().add(new CustomObjectAttribute("address", Arrays.asList("London", "Texas", "Kiev")));
        newUser.getCustomAttributes().add(new CustomObjectAttribute("jansGuid", (Object)"test_value"));
        newUser.getCustomAttributes().add(new CustomObjectAttribute("birthdate", (Object)new Date()));
        newUser.getCustomAttributes().add(new CustomObjectAttribute("jansActive", (Object)false));
        newUser.getCustomAttributes().add(new CustomObjectAttribute("scimCustomThird", (Object)18));
        newUser.setUserRole(UserRole.ADMIN);
        newUser.setMemberOf(Arrays.asList("group_1", "group_2", "group_3"));
        sqlEntryManager.persist((Object)newUser);
        LOG.info("Added User '{}' with uid '{}' and key '{}'", new Object[]{newUser, newUser.getUserId(), newUser.getDn()});
        SimpleUser foundUser = (SimpleUser)sqlEntryManager.find(SimpleUser.class, (Object)newUser.getDn());
        LOG.info("Found User '{}' with uid '{}' and key '{}'", new Object[]{foundUser, foundUser.getUserId(), foundUser.getDn()});
        LOG.info("Custom attributes '{}'", foundUser.getCustomAttributes());
        for (CustomObjectAttribute customObjectAttribute : foundUser.getCustomAttributes()) {
            if (customObjectAttribute.getValue() instanceof Date) {
                LOG.info("Found date custom attribute '{}' with value '{}'", (Object)customObjectAttribute.getName(), customObjectAttribute.getValue());
                continue;
            }
            if (customObjectAttribute.getValue() instanceof Integer) {
                LOG.info("Found integer custom attribute '{}' with value '{}'", (Object)customObjectAttribute.getName(), customObjectAttribute.getValue());
                continue;
            }
            if (customObjectAttribute.getValue() instanceof Boolean) {
                LOG.info("Found boolean custom attribute '{}' with value '{}'", (Object)customObjectAttribute.getName(), customObjectAttribute.getValue());
                continue;
            }
            if (customObjectAttribute.getValues().size() <= 1) continue;
            LOG.info("Found list custom attribute '{}' with value '{}', multiValued: {}", new Object[]{customObjectAttribute.getName(), customObjectAttribute.getValues(), customObjectAttribute.isMultiValued()});
        }
        for (CustomObjectAttribute customObjectAttribute : foundUser.getCustomAttributes()) {
            if (!StringHelper.equalsIgnoreCase((String)customObjectAttribute.getName(), (String)"jansGuid")) continue;
            customObjectAttribute.setValue((Object)"");
            break;
        }
        sqlEntryManager.merge((Object)foundUser);
        SimpleUser foundUser2 = (SimpleUser)sqlEntryManager.find(SimpleUser.class, (Object)newUser.getDn());
        LOG.info("Found User '{}' with uid '{}' and key '{}'", new Object[]{foundUser2, foundUser2.getUserId(), foundUser2.getDn()});
        LOG.info("Custom attributes after merge '{}'", foundUser2.getCustomAttributes());
        for (CustomObjectAttribute customAttribute : foundUser2.getCustomAttributes()) {
            if (customAttribute.getValue() instanceof Date) {
                LOG.info("Found date custom attribute '{}' with value '{}'", (Object)customAttribute.getName(), customAttribute.getValue());
                continue;
            }
            if (customAttribute.getValue() instanceof Integer) {
                LOG.info("Found integer custom attribute '{}' with value '{}'", (Object)customAttribute.getName(), customAttribute.getValue());
                continue;
            }
            if (customAttribute.getValue() instanceof Boolean) {
                LOG.info("Found boolean custom attribute '{}' with value '{}'", (Object)customAttribute.getName(), customAttribute.getValue());
                continue;
            }
            if (customAttribute.getValues().size() <= 1) continue;
            LOG.info("Found list custom attribute '{}' with value '{}', multiValued: {}", new Object[]{customAttribute.getName(), customAttribute.getValues(), customAttribute.isMultiValued()});
        }
        Filter filter = Filter.createGreaterOrEqualFilter((String)"scimCustomThird", (Object)16);
        List foundUsers = sqlEntryManager.findEntries("ou=people,o=jans", SimpleUser.class, filter);
        if (foundUsers.size() > 0) {
            foundUser = (SimpleUser)foundUsers.get(0);
            LOG.info("Found User '{}' by filter '{}' with uid '{}' and key '{}'", new Object[]{foundUser, filter, foundUser, foundUser});
        } else {
            LOG.error("Can't find User by filter '{}'", (Object)filter);
        }
    }
}

