/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.sql;

import io.jans.orm.model.PagedResult;
import io.jans.orm.model.SortOrder;
import io.jans.orm.sql.impl.SqlEntryManager;
import io.jans.orm.sql.model.SimpleUser;
import io.jans.orm.sql.operation.impl.SqlConnectionProvider;
import io.jans.orm.sql.persistence.SqlEntryManagerSample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SqlPagedUserSearchSample {
    private static final Logger LOG = LoggerFactory.getLogger(SqlConnectionProvider.class);

    private SqlPagedUserSearchSample() {
    }

    public static void main(String[] args) throws InterruptedException {
        SqlEntryManagerSample sqlEntryManagerSample = new SqlEntryManagerSample();
        SqlEntryManager sqlEntryManager = sqlEntryManagerSample.createSqlEntryManager();
        try {
            int start = 0;
            int lastCount = 0;
            boolean first = true;
            while (first || lastCount > 0) {
                PagedResult listViewResponse = sqlEntryManager.findPagedEntries("o=gluu", SimpleUser.class, null, new String[]{"uid", "displayName", "gluuStatus"}, "uid", SortOrder.ASCENDING, start + 1000, 1000, 333);
                lastCount = listViewResponse.getEntriesCount();
                start += 1000;
                first = false;
                System.out.println("Loaded count: " + lastCount + " / " + listViewResponse.getTotalEntriesCount());
                LOG.info("Found persons: " + listViewResponse.getEntriesCount() + ", total persons: " + listViewResponse.getTotalEntriesCount());
            }
        }
        catch (Exception ex) {
            LOG.info("Failed to search", (Throwable)ex);
        }
    }
}

