/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.sql;

import io.jans.orm.exception.EntryPersistenceException;
import io.jans.orm.sql.impl.SqlEntryManager;
import io.jans.orm.sql.model.SimpleSessionState;
import io.jans.orm.sql.operation.impl.SqlConnectionProvider;
import io.jans.orm.sql.persistence.SqlEntryManagerSample;
import java.util.Date;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SqlUpateMissingEntrySample {
    private static final Logger LOG = LoggerFactory.getLogger(SqlConnectionProvider.class);

    private SqlUpateMissingEntrySample() {
    }

    public static void main(String[] args) {
        SqlEntryManagerSample sqlEntryManagerSample = new SqlEntryManagerSample();
        SqlEntryManager sqlEntryManager = sqlEntryManagerSample.createSqlEntryManager();
        String sessionId = UUID.randomUUID().toString();
        String sessionDn = "uniqueIdentifier=" + sessionId + ",ou=session,o=jans";
        SimpleSessionState simpleSessionState = new SimpleSessionState();
        simpleSessionState.setDn(sessionDn);
        simpleSessionState.setId(sessionId);
        simpleSessionState.setLastUsedAt(new Date());
        try {
            sqlEntryManager.merge((Object)simpleSessionState);
            System.out.println("Updated");
        }
        catch (EntryPersistenceException ex) {
            LOG.info("Failed to update, root case exception: {}", ex.getCause().getClass(), (Object)ex);
        }
    }
}

