/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.sql.model;

import io.jans.orm.annotation.AttributeName;
import io.jans.orm.annotation.AttributesList;
import io.jans.orm.annotation.CustomObjectClass;
import io.jans.orm.annotation.DN;
import io.jans.orm.annotation.DataEntry;
import io.jans.orm.annotation.ObjectClass;
import io.jans.orm.model.base.CustomAttribute;
import io.jans.orm.sql.model.UserRole;
import io.jans.orm.util.StringHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@DataEntry
@ObjectClass(value="jansPerson")
public class SimpleCustomStringUser
implements Serializable {
    private static final long serialVersionUID = -1634191420188575733L;
    @DN
    private String dn;
    @AttributeName(name="uid")
    private String userId;
    @AttributeName(name="userPassword")
    private String userPassword;
    @AttributeName(name="jansRole")
    private UserRole userRole;
    @AttributeName(name="memberOf")
    private List<String> memberOf;
    @AttributesList(name="name", value="values", multiValued="multiValued", sortByName=true)
    private List<CustomAttribute> customAttributes = new ArrayList<CustomAttribute>();
    @CustomObjectClass
    private String[] customObjectClasses;

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public UserRole getUserRole() {
        return this.userRole;
    }

    public void setUserRole(UserRole userRole) {
        this.userRole = userRole;
    }

    public List<String> getMemberOf() {
        return this.memberOf;
    }

    public void setMemberOf(List<String> memberOf) {
        this.memberOf = memberOf;
    }

    public List<CustomAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(List<CustomAttribute> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public String getAttribute(String attributeName) {
        String attribute = null;
        if (attributeName != null && !attributeName.isEmpty()) {
            for (CustomAttribute customAttribute : this.customAttributes) {
                if (!customAttribute.getName().equals(attributeName)) continue;
                attribute = customAttribute.getValue();
                break;
            }
        }
        return attribute;
    }

    public List<String> getAttributeValues(String attributeName) {
        List values = null;
        if (attributeName != null && !attributeName.isEmpty()) {
            for (CustomAttribute customAttribute : this.customAttributes) {
                if (!StringHelper.equalsIgnoreCase((String)customAttribute.getName(), (String)attributeName)) continue;
                values = customAttribute.getValues();
                break;
            }
        }
        return values;
    }

    public void setAttributeValue(String attributeName, String attributeValue) {
        if (attributeName != null && !attributeName.isEmpty()) {
            for (CustomAttribute customAttribute : this.customAttributes) {
                if (!StringHelper.equalsIgnoreCase((String)customAttribute.getName(), (String)attributeName)) continue;
                customAttribute.setValue(attributeValue);
                return;
            }
            this.customAttributes.add(new CustomAttribute(attributeName, attributeValue));
        }
    }

    public void setAttributeValues(String attributeName, List<String> attributeValues) {
        if (attributeName != null && !attributeName.isEmpty()) {
            for (CustomAttribute customAttribute : this.customAttributes) {
                if (!StringHelper.equalsIgnoreCase((String)customAttribute.getName(), (String)attributeName)) continue;
                customAttribute.setValues(attributeValues);
                return;
            }
            this.customAttributes.add(new CustomAttribute(attributeName, attributeValues));
        }
    }

    public String[] getCustomObjectClasses() {
        return this.customObjectClasses;
    }

    public void setCustomObjectClasses(String[] customObjectClasses) {
        this.customObjectClasses = customObjectClasses;
    }
}

