/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.sql.model;

import io.jans.orm.annotation.AttributeName;
import io.jans.orm.annotation.AttributesList;
import io.jans.orm.annotation.CustomObjectClass;
import io.jans.orm.annotation.DN;
import io.jans.orm.annotation.DataEntry;
import io.jans.orm.annotation.JsonObject;
import io.jans.orm.annotation.ObjectClass;
import io.jans.orm.model.base.CustomAttribute;
import io.jans.orm.util.StringHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@DataEntry
@ObjectClass(value="jansSessId")
public class SimpleSession
implements Serializable {
    private static final long serialVersionUID = -1534191420188575733L;
    @DN
    private String dn;
    @AttributeName(name="jansId")
    private String id;
    @AttributeName(name="deviceSecret")
    private List<String> deviceSecrets;
    @AttributesList(name="name", value="values", sortByName=true)
    private List<CustomAttribute> customAttributes = new ArrayList<CustomAttribute>();
    @JsonObject
    @AttributeName(name="jansSessAttr")
    private Map<String, Object> sessionAttributes;
    @CustomObjectClass
    private String[] customObjectClasses;

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getDeviceSecrets() {
        return this.deviceSecrets;
    }

    public void setDeviceSecrets(List<String> deviceSecrets) {
        this.deviceSecrets = deviceSecrets;
    }

    public Map<String, Object> getSessionAttributes() {
        return this.sessionAttributes;
    }

    public void setSessionAttributes(Map<String, Object> sessionAttributes) {
        this.sessionAttributes = sessionAttributes;
    }

    public List<CustomAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(List<CustomAttribute> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public String getAttribute(String ldapAttribute) {
        String attribute = null;
        if (ldapAttribute != null && !ldapAttribute.isEmpty()) {
            for (CustomAttribute customAttribute : this.customAttributes) {
                if (!customAttribute.getName().equals(ldapAttribute)) continue;
                attribute = customAttribute.getValue();
                break;
            }
        }
        return attribute;
    }

    public List<String> getAttributeValues(String ldapAttribute) {
        List values = null;
        if (ldapAttribute != null && !ldapAttribute.isEmpty()) {
            for (CustomAttribute customAttribute : this.customAttributes) {
                if (!StringHelper.equalsIgnoreCase((String)customAttribute.getName(), (String)ldapAttribute)) continue;
                values = customAttribute.getValues();
                break;
            }
        }
        return values;
    }

    public String[] getCustomObjectClasses() {
        return this.customObjectClasses;
    }

    public void setCustomObjectClasses(String[] customObjectClasses) {
        this.customObjectClasses = customObjectClasses;
    }
}

