/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.sql;

import io.jans.orm.model.SearchScope;
import io.jans.orm.search.filter.Filter;
import io.jans.orm.sql.impl.SqlEntryManager;
import io.jans.orm.sql.model.SimpleUser;
import io.jans.orm.sql.operation.impl.SqlConnectionProvider;
import io.jans.orm.sql.persistence.SqlEntryManagerSample;
import java.util.List;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SqlComplexFilterSample {
    private static final Logger LOG = LoggerFactory.getLogger(SqlConnectionProvider.class);

    private SqlComplexFilterSample() {
        TimeZone newTimeZone = TimeZone.getTimeZone("America/Los_Angeles");
        TimeZone.setDefault(newTimeZone);
    }

    public static void main(String[] args) {
        SqlEntryManagerSample sqlEntryManagerSample = new SqlEntryManagerSample();
        SqlEntryManager sqlEntryManager = sqlEntryManagerSample.createSqlEntryManager();
        String[] targetArray = new String[]{"001-220-3456"};
        Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
        Filter descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
        Filter mailFilter = Filter.createSubstringFilter((String)"mail", null, (String[])targetArray, null);
        Filter givenNameFilter = Filter.createSubstringFilter((String)"givenName", null, (String[])targetArray, null);
        Filter middleNameFilter = Filter.createSubstringFilter((String)"middleName", null, (String[])targetArray, null);
        Filter nicknameFilter = Filter.createSubstringFilter((String)"nickname", null, (String[])targetArray, null);
        Filter snFilter = Filter.createSubstringFilter((String)"sn", null, (String[])targetArray, null);
        Filter uidFilter = Filter.createSubstringFilter((String)"uid", null, (String[])targetArray, null);
        Filter mobileFilter = Filter.createSubstringFilter((String)"mobile", null, (String[])targetArray, null).multiValued(3);
        Filter inumFilter = Filter.createSubstringFilter((String)"test", null, (String[])targetArray, null);
        Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, descriptionFilter, mailFilter, uidFilter, givenNameFilter, middleNameFilter, nicknameFilter, snFilter, inumFilter, mobileFilter});
        List users = sqlEntryManager.findEntries("ou=people,o=jans", SimpleUser.class, mobileFilter, SearchScope.SUB, null, null, 0, 0, 0);
        for (SimpleUser user : users) {
            LOG.info("User: " + user.getCustomAttributes());
        }
    }
}

