/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.sql;

import io.jans.orm.search.filter.Filter;
import io.jans.orm.sql.impl.SqlEntryManager;
import io.jans.orm.sql.model.Document;
import io.jans.orm.sql.persistence.SqlEntryManagerSample;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SqlDocumentStoreSample {
    private static final Logger LOG = LoggerFactory.getLogger(SqlDocumentStoreSample.class);

    private SqlDocumentStoreSample() {
    }

    public static void main(String[] args) {
        SqlEntryManagerSample entryManagerSample = new SqlEntryManagerSample();
        SqlEntryManager entryManager = entryManagerSample.createSqlEntryManager();
        Document document = new Document();
        document.setInum(String.valueOf(System.currentTimeMillis()));
        String dn = String.format("inum=%s,ou=document,o=jans", document.getInum());
        document.setDocument("TEST DATA");
        document.setDisplayName(String.format("doc%s.txt", document.getInum()));
        document.setDn(dn);
        document.setDescription("test description");
        document.setJansEnabled(true);
        document.setJansService(Arrays.asList("jans-config-api", "jans-kc-link", "jans-scim"));
        entryManager.persist((Object)document);
        List documents = entryManager.findEntries("o=jans", Document.class, null);
        for (Document doc : documents) {
            LOG.debug("Document with display name: " + doc.getDisplayName());
        }
        Filter filter = Filter.createEqualityFilter((String)"jansService", (Object)"jans-kc-link").multiValued();
        List documentsByFilter = entryManager.findEntries("o=jans", Document.class, filter);
        for (Document doc : documentsByFilter) {
            LOG.debug("Found document with display name: " + doc.getDisplayName());
        }
    }
}

