/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.sql.persistence;

import io.jans.orm.sql.impl.SqlEntryManager;
import io.jans.orm.sql.impl.SqlEntryManagerFactory;
import java.util.Properties;
import org.apache.log4j.Logger;

public class SqlEntryManagerSample {
    private static final Logger LOG = Logger.getLogger(SqlEntryManagerSample.class);

    private Properties getSampleConnectionProperties() {
        Properties connectionProperties = new Properties();
        boolean mysql = false;
        if (mysql) {
            connectionProperties.put("sql#db.schema.name", "jansdb");
            connectionProperties.put("sql#connection.uri", "jdbc:mysql://localhost:3306/jansdb?profileSQL=true");
            connectionProperties.put("sql#connection.driver-property.serverTimezone", "GMT+2");
            connectionProperties.put("sql#mysql.simple-json", "true");
        } else {
            connectionProperties.put("sql#db.schema.name", "public");
            connectionProperties.put("sql#connection.uri", "jdbc:postgresql://localhost:5432/jansdb");
            connectionProperties.put("sql#db.disable.time-zone", "true");
        }
        connectionProperties.put("sql#connection.driver-property.serverTimezone", "GMT+2");
        connectionProperties.put("sql#connection.pool.max-total", "300");
        connectionProperties.put("sql#connection.pool.max-idle", "300");
        connectionProperties.put("sql#connection.pool.test-on-create", "true");
        connectionProperties.put("sql#connection.pool.test-on-return", "true");
        connectionProperties.put("sql#auth.userName", "jans");
        connectionProperties.put("sql#auth.userPassword", "secret");
        connectionProperties.put("sql#password.encryption.method", "SSHA-256");
        connectionProperties.put("sql#connection.pool.create-max-wait-time-millis", "20000");
        connectionProperties.put("sql#connection.pool.max-wait-time-millis", "20000");
        connectionProperties.put("sql#connection.pool.min-evictable-idle-time-millis", "1800000");
        connectionProperties.put("sql#binaryAttributes", "objectGUID");
        connectionProperties.put("sql#certificateAttributes", "userCertificate");
        return connectionProperties;
    }

    public SqlEntryManager createSqlEntryManager() {
        SqlEntryManagerFactory sqlEntryManagerFactory = new SqlEntryManagerFactory();
        sqlEntryManagerFactory.create();
        Properties connectionProperties = this.getSampleConnectionProperties();
        SqlEntryManager sqlEntryManager = sqlEntryManagerFactory.createEntryManager(connectionProperties);
        LOG.debug((Object)("Created SqlEntryManager: " + sqlEntryManager));
        return sqlEntryManager;
    }
}

