/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.sql.impl;

import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.PersistenceEntryManagerFactory;
import io.jans.orm.exception.operation.ConfigurationException;
import io.jans.orm.service.BaseFactoryService;
import io.jans.orm.sql.impl.SqlEntryManager;
import io.jans.orm.sql.operation.impl.SqlConnectionProvider;
import io.jans.orm.sql.operation.impl.SqlOperationServiceImpl;
import io.jans.orm.util.PropertiesHelper;
import io.jans.orm.util.StringHelper;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.HashMap;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class SqlEntryManagerFactory
implements PersistenceEntryManagerFactory {
    public static final String PERSISTENCE_TYPE = PersistenceEntryManager.PERSITENCE_TYPES.sql.name();
    public static final String PROPERTIES_FILE = "jans-sql%s.properties";
    private static final Logger LOG = LoggerFactory.getLogger(SqlEntryManagerFactory.class);

    @PostConstruct
    public void create() {
    }

    @PreDestroy
    public void destroy() {
    }

    public String getPersistenceType() {
        return PERSISTENCE_TYPE;
    }

    public HashMap<String, String> getConfigurationFileNames(String alias) {
        Object usedAlias = StringHelper.isEmpty((String)alias) ? "" : "." + alias;
        HashMap<String, String> confs = new HashMap<String, String>();
        String confFileName = String.format(PROPERTIES_FILE, usedAlias);
        confs.put(PERSISTENCE_TYPE + (String)usedAlias, confFileName);
        return confs;
    }

    public SqlEntryManager createEntryManager(Properties conf) {
        Properties entryManagerConf = PropertiesHelper.filterProperties((Properties)conf, (String)"#");
        SqlConnectionProvider connectionProvider = new SqlConnectionProvider(entryManagerConf);
        connectionProvider.create();
        if (!connectionProvider.isCreated()) {
            throw new ConfigurationException(String.format("Failed to create SQL connection pool! Result code: '%s'", connectionProvider.getCreationResultCode()));
        }
        LOG.debug("Created connectionProvider '{}' with code '{}'", (Object)connectionProvider, (Object)connectionProvider.getCreationResultCode());
        SqlEntryManager sqlEntryManager = new SqlEntryManager(new SqlOperationServiceImpl(entryManagerConf, connectionProvider));
        LOG.info("Created SqlEntryManager: {}", (Object)sqlEntryManager.getOperationService());
        return sqlEntryManager;
    }

    public void initStandalone(BaseFactoryService persistanceFactoryService) {
    }
}

