/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.sql.operation;

import java.util.HashMap;
import java.util.Map;

public enum SupportedDbType {
    MYSQL("mysql"),
    MARIADB("mariadb"),
    POSTGRESQL("postgresql");

    private String dbType;
    private static Map<String, SupportedDbType> MAP_BY_VALUES;

    private SupportedDbType(String dbType) {
        this.dbType = dbType;
    }

    public static SupportedDbType resolveDbType(String dbType) {
        return MAP_BY_VALUES.get(dbType);
    }

    public String toString() {
        return this.dbType;
    }

    static {
        MAP_BY_VALUES = new HashMap<String, SupportedDbType>();
        for (SupportedDbType enumType : SupportedDbType.values()) {
            MAP_BY_VALUES.put(enumType.dbType, enumType);
        }
    }
}

