/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.sql.impl.test;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLTemplates;
import io.jans.orm.exception.operation.SearchException;
import io.jans.orm.search.filter.Filter;
import io.jans.orm.search.filter.FilterProcessor;
import io.jans.orm.sql.dsl.template.MySQLJsonTemplates;
import io.jans.orm.sql.impl.SqlFilterConverter;
import io.jans.orm.sql.model.ConvertedExpression;
import io.jans.orm.sql.operation.SqlOperationService;
import io.jans.orm.sql.operation.impl.SqlConnectionProvider;
import io.jans.orm.sql.operation.impl.SqlOperationServiceImpl;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SqlFilterConverterCheckExcludeFilterTest {
    private SqlFilterConverter simpleConverter;
    private FilterProcessor filterProcessor;
    private Path<Object> tablePath;
    private Path<Object> docAlias;
    private SimpleExpression<Object> tableAlieasPath;
    private StringPath allPath;
    private SQLTemplates sqlTemplates;
    private Configuration configuration;

    @BeforeClass
    public void init() {
        this.simpleConverter = new SqlFilterConverter((SqlOperationService)new SqlOperationServiceImpl(null, new SqlConnectionProvider(null)));
        this.filterProcessor = new FilterProcessor();
        this.tablePath = ExpressionUtils.path(Object.class, (String)"table");
        this.docAlias = ExpressionUtils.path(Object.class, (String)"doc");
        this.tableAlieasPath = Expressions.as(this.tablePath, this.docAlias);
        this.allPath = Expressions.stringPath(this.docAlias, (String)"*");
        this.sqlTemplates = MySQLJsonTemplates.builder().printSchema().build();
        this.configuration = new Configuration(this.sqlTemplates);
    }

    @Test
    public void checkObjectClassExcludeFilter() throws SearchException {
        Filter filterEq1 = Filter.createEqualityFilter((String)"uid", (Object)"test");
        Filter filterEq2 = Filter.createEqualityFilter((Filter)Filter.createLowercaseFilter((String)"uid"), (Object)"test");
        Filter filterEq3 = Filter.createEqualityFilter((String)"objectClass", (Object)"jansPerson");
        Filter filterEq4 = Filter.createEqualityFilter((String)"added", (Object)SqlFilterConverterCheckExcludeFilterTest.getUtcDateFromMillis(1608130698398L)).multiValued();
        Filter andFilter = Filter.createANDFilter((Filter[])new Filter[]{filterEq1, filterEq2, filterEq3, filterEq4});
        Filter orFilter = Filter.createANDFilter((Filter[])new Filter[]{filterEq1, filterEq2, filterEq3, andFilter, filterEq4});
        Filter filter1 = Filter.createANDFilter((Filter[])new Filter[]{filterEq3, orFilter});
        ConvertedExpression expression1 = this.simpleConverter.convertToSqlFilter(null, filter1, null);
        String query1 = this.toSelectSQL(expression1);
        Assert.assertEquals((String)query1, (String)"select doc.`*` from `table` as doc where doc.objectClass = 'jansPerson' and (doc.uid = 'test' and lower(doc.uid) = 'test' and doc.objectClass = 'jansPerson' and (doc.uid = 'test' and lower(doc.uid) = 'test' and doc.objectClass = 'jansPerson' and JSON_CONTAINS(doc.added->>'$', CAST('[\"2020-12-16T14:58:18.398\"]' AS JSON))) and JSON_CONTAINS(doc.added->>'$', CAST('[\"2020-12-16T14:58:18.398\"]' AS JSON)))");
        Filter filter2 = this.filterProcessor.excludeFilter(filter1, new Filter[]{filterEq3});
        ConvertedExpression expression2 = this.simpleConverter.convertToSqlFilter(null, filter2, null);
        String query2 = this.toSelectSQL(expression2);
        Assert.assertEquals((String)query2, (String)"select doc.`*` from `table` as doc where doc.uid = 'test' and lower(doc.uid) = 'test' and (doc.uid = 'test' and lower(doc.uid) = 'test' and JSON_CONTAINS(doc.added->>'$', CAST('[\"2020-12-16T14:58:18.398\"]' AS JSON))) and JSON_CONTAINS(doc.added->>'$', CAST('[\"2020-12-16T14:58:18.398\"]' AS JSON))");
        Filter filter3 = this.filterProcessor.excludeFilter(filter1, new Filter[]{Filter.createEqualityFilter((String)"objectClass", null)});
        ConvertedExpression expression3 = this.simpleConverter.convertToSqlFilter(null, filter3, null);
        String query3 = this.toSelectSQL(expression3);
        Assert.assertEquals((String)query3, (String)"select doc.`*` from `table` as doc where doc.uid = 'test' and lower(doc.uid) = 'test' and (doc.uid = 'test' and lower(doc.uid) = 'test' and JSON_CONTAINS(doc.added->>'$', CAST('[\"2020-12-16T14:58:18.398\"]' AS JSON))) and JSON_CONTAINS(doc.added->>'$', CAST('[\"2020-12-16T14:58:18.398\"]' AS JSON))");
    }

    private String toSelectSQL(ConvertedExpression convertedExpression) {
        SQLQuery sqlQuery = (SQLQuery)new SQLQuery(this.configuration).select((Expression)this.allPath).from(this.tableAlieasPath).where((Predicate)convertedExpression.expression());
        sqlQuery.setUseLiterals(true);
        String queryStr = sqlQuery.getSQL().getSQL().replace("\n", " ");
        return queryStr;
    }

    private static Date getUtcDateFromMillis(long millis) {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(millis);
        calendar.set(15, TimeZone.getTimeZone("UTC").getRawOffset());
        Date date = calendar.getTime();
        return date;
    }
}

