/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.sql.impl.test;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLTemplates;
import io.jans.orm.exception.operation.SearchException;
import io.jans.orm.search.filter.Filter;
import io.jans.orm.sql.dsl.template.MySQLJsonTemplates;
import io.jans.orm.sql.impl.SqlFilterConverter;
import io.jans.orm.sql.model.ConvertedExpression;
import io.jans.orm.sql.operation.SqlOperationService;
import io.jans.orm.sql.operation.impl.SqlConnectionProvider;
import io.jans.orm.sql.operation.impl.SqlOperationServiceImpl;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SqlFilterConverterTest {
    private SqlFilterConverter simpleConverter;
    private Path<Object> tablePath;
    private Path<Object> docAlias;
    private SimpleExpression<Object> tableAlieasPath;
    private StringPath allPath;
    private SQLTemplates sqlTemplates;
    private Configuration configuration;

    @BeforeClass
    public void init() {
        this.simpleConverter = new SqlFilterConverter((SqlOperationService)new SqlOperationServiceImpl(null, new SqlConnectionProvider(null)));
        this.tablePath = ExpressionUtils.path(Object.class, (String)"table");
        this.docAlias = ExpressionUtils.path(Object.class, (String)"doc");
        this.tableAlieasPath = Expressions.as(this.tablePath, this.docAlias);
        this.allPath = Expressions.stringPath(this.docAlias, (String)"*");
        this.sqlTemplates = MySQLJsonTemplates.builder().printSchema().build();
        this.configuration = new Configuration(this.sqlTemplates);
    }

    @Test
    public void checkEqFilters() throws SearchException {
        Filter filterEq1 = Filter.createEqualityFilter((String)"uid", (Object)"test");
        ConvertedExpression expressionEq1 = this.simpleConverter.convertToSqlFilter(null, filterEq1, null);
        String queryEq1 = this.toSelectSQL(expressionEq1);
        Assert.assertEquals((String)queryEq1, (String)"select doc.`*` from `table` as doc where doc.uid = 'test'");
        Filter filterEq2 = Filter.createEqualityFilter((String)"age", (Object)23);
        ConvertedExpression expressionEq2 = this.simpleConverter.convertToSqlFilter(null, filterEq2, null);
        String queryEq2 = this.toSelectSQL(expressionEq2);
        Assert.assertEquals((String)queryEq2, (String)"select doc.`*` from `table` as doc where doc.age = 23");
        Filter filterEq3 = Filter.createEqualityFilter((String)"age", (Object)23L);
        ConvertedExpression expressionEq3 = this.simpleConverter.convertToSqlFilter(null, filterEq3, null);
        String queryEq3 = this.toSelectSQL(expressionEq3);
        Assert.assertEquals((String)queryEq3, (String)"select doc.`*` from `table` as doc where doc.age = 23");
        Filter filterEq4 = Filter.createEqualityFilter((String)"added", (Object)SqlFilterConverterTest.getUtcDateFromMillis(1608130698398L));
        ConvertedExpression expressionEq4 = this.simpleConverter.convertToSqlFilter(null, filterEq4, null);
        String queryEq4 = this.toSelectSQL(expressionEq4);
        Assert.assertEquals((String)queryEq4, (String)"select doc.`*` from `table` as doc where doc.added = (timestamp '2020-12-16 14:58:18')");
    }

    @Test
    public void checkMultivaluedEqFilters() throws SearchException {
        Filter filterEq1 = Filter.createEqualityFilter((String)"uid", (Object)"test").multiValued();
        ConvertedExpression expressionEq1 = this.simpleConverter.convertToSqlFilter(null, filterEq1, null);
        String queryEq1 = this.toSelectSQL(expressionEq1);
        Assert.assertEquals((String)queryEq1, (String)"select doc.`*` from `table` as doc where JSON_CONTAINS(doc.uid->>'$', CAST('[\"test\"]' AS JSON))");
        Filter filterEq2 = Filter.createEqualityFilter((String)"age", (Object)23).multiValued();
        ConvertedExpression expressionEq2 = this.simpleConverter.convertToSqlFilter(null, filterEq2, null);
        String queryEq2 = this.toSelectSQL(expressionEq2);
        Assert.assertEquals((String)queryEq2, (String)"select doc.`*` from `table` as doc where JSON_CONTAINS(doc.age->>'$', CAST('[23]' AS JSON))");
        Filter filterEq3 = Filter.createEqualityFilter((String)"age", (Object)23L).multiValued();
        ConvertedExpression expressionEq3 = this.simpleConverter.convertToSqlFilter(null, filterEq3, null);
        String queryEq3 = this.toSelectSQL(expressionEq3);
        Assert.assertEquals((String)queryEq3, (String)"select doc.`*` from `table` as doc where JSON_CONTAINS(doc.age->>'$', CAST('[23]' AS JSON))");
        Filter filterEq4 = Filter.createEqualityFilter((String)"added", (Object)SqlFilterConverterTest.getUtcDateFromMillis(1608130698398L)).multiValued();
        ConvertedExpression expressionEq4 = this.simpleConverter.convertToSqlFilter(null, filterEq4, null);
        String queryEq4 = this.toSelectSQL(expressionEq4);
        Assert.assertEquals((String)queryEq4, (String)"select doc.`*` from `table` as doc where JSON_CONTAINS(doc.added->>'$', CAST('[\"2020-12-16T14:58:18.398\"]' AS JSON))");
    }

    @Test
    public void checkLeFilters() throws SearchException {
        Filter filterLe1 = Filter.createLessOrEqualFilter((String)"uid", (Object)"test");
        ConvertedExpression expressionLe1 = this.simpleConverter.convertToSqlFilter(null, filterLe1, null);
        String queryLe1 = this.toSelectSQL(expressionLe1);
        Assert.assertEquals((String)queryLe1, (String)"select doc.`*` from `table` as doc where doc.uid <= 'test'");
        Filter filterLe2 = Filter.createLessOrEqualFilter((String)"age", (Object)23);
        ConvertedExpression expressionLe2 = this.simpleConverter.convertToSqlFilter(null, filterLe2, null);
        String queryLe2 = this.toSelectSQL(expressionLe2);
        Assert.assertEquals((String)queryLe2, (String)"select doc.`*` from `table` as doc where doc.age <= 23");
        Filter filterLe3 = Filter.createLessOrEqualFilter((String)"age", (Object)23L);
        ConvertedExpression expressionLe3 = this.simpleConverter.convertToSqlFilter(null, filterLe3, null);
        String queryLe3 = this.toSelectSQL(expressionLe3);
        Assert.assertEquals((String)queryLe3, (String)"select doc.`*` from `table` as doc where doc.age <= 23");
        Filter filterLe4 = Filter.createLessOrEqualFilter((String)"added", (Object)SqlFilterConverterTest.getUtcDateFromMillis(1608130698398L));
        ConvertedExpression expressionLe4 = this.simpleConverter.convertToSqlFilter(null, filterLe4, null);
        String queryLe4 = this.toSelectSQL(expressionLe4);
        Assert.assertEquals((String)queryLe4, (String)"select doc.`*` from `table` as doc where doc.added <= (timestamp '2020-12-16 14:58:18')");
    }

    @Test
    public void checkMultivaluedLeFilters() throws SearchException {
        Filter filterLe1 = Filter.createLessOrEqualFilter((String)"uid", (Object)"test").multiValued();
        ConvertedExpression expressionLe1 = this.simpleConverter.convertToSqlFilter(null, filterLe1, null);
        String queryLe1 = this.toSelectSQL(expressionLe1);
        Assert.assertEquals((String)queryLe1, (String)"select doc.`*` from `table` as doc where doc.uid->>'$[0]' <= 'test'");
        Filter filterLe2 = Filter.createLessOrEqualFilter((String)"age", (Object)23).multiValued();
        ConvertedExpression expressionLe2 = this.simpleConverter.convertToSqlFilter(null, filterLe2, null);
        String queryLe2 = this.toSelectSQL(expressionLe2);
        Assert.assertEquals((String)queryLe2, (String)"select doc.`*` from `table` as doc where doc.age->>'$[0]' <= 23");
        Filter filterLe3 = Filter.createLessOrEqualFilter((String)"age", (Object)23L).multiValued();
        ConvertedExpression expressionLe3 = this.simpleConverter.convertToSqlFilter(null, filterLe3, null);
        String queryLe3 = this.toSelectSQL(expressionLe3);
        Assert.assertEquals((String)queryLe3, (String)"select doc.`*` from `table` as doc where doc.age->>'$[0]' <= 23");
        Filter filterLe4 = Filter.createLessOrEqualFilter((String)"added", (Object)SqlFilterConverterTest.getUtcDateFromMillis(1608130698398L)).multiValued();
        ConvertedExpression expressionLe4 = this.simpleConverter.convertToSqlFilter(null, filterLe4, null);
        String queryLe4 = this.toSelectSQL(expressionLe4);
        Assert.assertEquals((String)queryLe4, (String)"select doc.`*` from `table` as doc where doc.added->>'$[0]' <= (timestamp '2020-12-16 14:58:18')");
        Filter filterLe5 = Filter.createLessOrEqualFilter((String)"added", (Object)SqlFilterConverterTest.getUtcDateFromMillis(1608130698398L)).multiValued(3);
        ConvertedExpression expressionLe5 = this.simpleConverter.convertToSqlFilter(null, filterLe5, null);
        String queryLe5 = this.toSelectSQL(expressionLe5);
        Assert.assertEquals((String)queryLe5, (String)"select doc.`*` from `table` as doc where doc.added->>'$[0]' <= (timestamp '2020-12-16 14:58:18') or doc.added->>'$[1]' <= (timestamp '2020-12-16 14:58:18') or doc.added->>'$[2]' <= (timestamp '2020-12-16 14:58:18')");
    }

    @Test
    public void checkGeFilters() throws SearchException {
        Filter filterGe1 = Filter.createGreaterOrEqualFilter((String)"uid", (Object)"test");
        ConvertedExpression expressionGe1 = this.simpleConverter.convertToSqlFilter(null, filterGe1, null);
        String queryGe1 = this.toSelectSQL(expressionGe1);
        Assert.assertEquals((String)queryGe1, (String)"select doc.`*` from `table` as doc where doc.uid >= 'test'");
        Filter filterGe2 = Filter.createGreaterOrEqualFilter((String)"age", (Object)23);
        ConvertedExpression expressionGe2 = this.simpleConverter.convertToSqlFilter(null, filterGe2, null);
        String queryGe2 = this.toSelectSQL(expressionGe2);
        Assert.assertEquals((String)queryGe2, (String)"select doc.`*` from `table` as doc where doc.age >= 23");
        Filter filterGe3 = Filter.createGreaterOrEqualFilter((String)"age", (Object)23L);
        ConvertedExpression expressionGe3 = this.simpleConverter.convertToSqlFilter(null, filterGe3, null);
        String queryGe3 = this.toSelectSQL(expressionGe3);
        Assert.assertEquals((String)queryGe3, (String)"select doc.`*` from `table` as doc where doc.age >= 23");
        Filter filterGe4 = Filter.createGreaterOrEqualFilter((String)"added", (Object)SqlFilterConverterTest.getUtcDateFromMillis(1608130698398L));
        ConvertedExpression expressionGe4 = this.simpleConverter.convertToSqlFilter(null, filterGe4, null);
        String queryGe4 = this.toSelectSQL(expressionGe4);
        Assert.assertEquals((String)queryGe4, (String)"select doc.`*` from `table` as doc where doc.added >= (timestamp '2020-12-16 14:58:18')");
    }

    @Test
    public void checkMultivaluedGeFilters() throws SearchException {
        Filter filterGe1 = Filter.createGreaterOrEqualFilter((String)"uid", (Object)"test").multiValued();
        ConvertedExpression expressionGe1 = this.simpleConverter.convertToSqlFilter(null, filterGe1, null);
        String queryGe1 = this.toSelectSQL(expressionGe1);
        Assert.assertEquals((String)queryGe1, (String)"select doc.`*` from `table` as doc where doc.uid->>'$[0]' >= 'test'");
        Filter filterGe2 = Filter.createGreaterOrEqualFilter((String)"age", (Object)23).multiValued();
        ConvertedExpression expressionGe2 = this.simpleConverter.convertToSqlFilter(null, filterGe2, null);
        String queryGe2 = this.toSelectSQL(expressionGe2);
        Assert.assertEquals((String)queryGe2, (String)"select doc.`*` from `table` as doc where doc.age->>'$[0]' >= 23");
        Filter filterGe3 = Filter.createGreaterOrEqualFilter((String)"age", (Object)23L).multiValued();
        ConvertedExpression expressionGe3 = this.simpleConverter.convertToSqlFilter(null, filterGe3, null);
        String queryGe3 = this.toSelectSQL(expressionGe3);
        Assert.assertEquals((String)queryGe3, (String)"select doc.`*` from `table` as doc where doc.age->>'$[0]' >= 23");
        Filter filterGe4 = Filter.createGreaterOrEqualFilter((String)"added", (Object)SqlFilterConverterTest.getUtcDateFromMillis(1608130698398L)).multiValued();
        ConvertedExpression expressionGe4 = this.simpleConverter.convertToSqlFilter(null, filterGe4, null);
        String queryGe4 = this.toSelectSQL(expressionGe4);
        Assert.assertEquals((String)queryGe4, (String)"select doc.`*` from `table` as doc where doc.added->>'$[0]' >= (timestamp '2020-12-16 14:58:18')");
        Filter filterGe5 = Filter.createGreaterOrEqualFilter((String)"added", (Object)SqlFilterConverterTest.getUtcDateFromMillis(1608130698398L)).multiValued(3);
        ConvertedExpression expressionGe5 = this.simpleConverter.convertToSqlFilter(null, filterGe5, null);
        String queryGe5 = this.toSelectSQL(expressionGe5);
        Assert.assertEquals((String)queryGe5, (String)"select doc.`*` from `table` as doc where doc.added->>'$[0]' >= (timestamp '2020-12-16 14:58:18') or doc.added->>'$[1]' >= (timestamp '2020-12-16 14:58:18') or doc.added->>'$[2]' >= (timestamp '2020-12-16 14:58:18')");
    }

    @Test
    public void checkPresenceFilters() throws SearchException {
        Filter filterPresence = Filter.createPresenceFilter((String)"uid");
        ConvertedExpression expressionPresence = this.simpleConverter.convertToSqlFilter(null, filterPresence, null);
        String queryPresence = this.toSelectSQL(expressionPresence);
        Assert.assertEquals((String)queryPresence, (String)"select doc.`*` from `table` as doc where doc.uid is not null");
    }

    @Test
    public void checkMultivaluedPresenceFilters() throws SearchException {
        Filter filterPresence1 = Filter.createPresenceFilter((String)"uid").multiValued();
        ConvertedExpression expressionPresence1 = this.simpleConverter.convertToSqlFilter(null, filterPresence1, null);
        String queryPresence1 = this.toSelectSQL(expressionPresence1);
        Assert.assertEquals((String)queryPresence1, (String)"select doc.`*` from `table` as doc where doc.uid->>'$[0]' is not null");
        Filter filterPresence2 = Filter.createPresenceFilter((String)"uid").multiValued(3);
        ConvertedExpression expressionPresence2 = this.simpleConverter.convertToSqlFilter(null, filterPresence2, null);
        String queryPresence2 = this.toSelectSQL(expressionPresence2);
        Assert.assertEquals((String)queryPresence2, (String)"select doc.`*` from `table` as doc where doc.uid->>'$[0]' is not null or doc.uid->>'$[1]' is not null or doc.uid->>'$[2]' is not null");
    }

    @Test
    public void checkSubFilters() throws SearchException {
        Filter filterSub1 = Filter.createSubstringFilter((String)"uid", null, (String[])new String[]{"test"}, null);
        ConvertedExpression expressionSub1 = this.simpleConverter.convertToSqlFilter(null, filterSub1, null);
        String querySub1 = this.toSelectSQL(expressionSub1);
        Assert.assertEquals((String)querySub1, (String)"select doc.`*` from `table` as doc where doc.uid like '%test%'");
        Filter filterSub2 = Filter.createSubstringFilter((String)"uid", (String)"a", (String[])new String[]{"test"}, null);
        ConvertedExpression expressionSub2 = this.simpleConverter.convertToSqlFilter(null, filterSub2, null);
        String querySub2 = this.toSelectSQL(expressionSub2);
        Assert.assertEquals((String)querySub2, (String)"select doc.`*` from `table` as doc where doc.uid like 'a%test%'");
        Filter filterSub3 = Filter.createSubstringFilter((String)"uid", null, (String[])new String[]{"test"}, (String)"z");
        ConvertedExpression expressionSub3 = this.simpleConverter.convertToSqlFilter(null, filterSub3, null);
        String querySub3 = this.toSelectSQL(expressionSub3);
        Assert.assertEquals((String)querySub3, (String)"select doc.`*` from `table` as doc where doc.uid like '%test%z'");
    }

    @Test
    public void checkMultivaluedSubFilters() throws SearchException {
        Filter filterSub1 = Filter.createSubstringFilter((String)"uid", null, (String[])new String[]{"test"}, null).multiValued();
        ConvertedExpression expressionSub1 = this.simpleConverter.convertToSqlFilter(null, filterSub1, null);
        String querySub1 = this.toSelectSQL(expressionSub1);
        Assert.assertEquals((String)querySub1, (String)"select doc.`*` from `table` as doc where doc.uid->>'$[0]' like '%test%'");
        Filter filterSub2 = Filter.createSubstringFilter((String)"uid", (String)"a", (String[])new String[]{"test"}, null).multiValued();
        ConvertedExpression expressionSub2 = this.simpleConverter.convertToSqlFilter(null, filterSub2, null);
        String querySub2 = this.toSelectSQL(expressionSub2);
        Assert.assertEquals((String)querySub2, (String)"select doc.`*` from `table` as doc where doc.uid->>'$[0]' like 'a%test%'");
        Filter filterSub3 = Filter.createSubstringFilter((String)"uid", null, (String[])new String[]{"test"}, (String)"z").multiValued();
        ConvertedExpression expressionSub3 = this.simpleConverter.convertToSqlFilter(null, filterSub3, null);
        String querySub3 = this.toSelectSQL(expressionSub3);
        Assert.assertEquals((String)querySub3, (String)"select doc.`*` from `table` as doc where doc.uid->>'$[0]' like '%test%z'");
        Filter filterSub4 = Filter.createSubstringFilter((String)"uid", null, (String[])new String[]{"test"}, (String)"z").multiValued(3);
        ConvertedExpression expressionSub4 = this.simpleConverter.convertToSqlFilter(null, filterSub4, null);
        String querySub4 = this.toSelectSQL(expressionSub4);
        Assert.assertEquals((String)querySub4, (String)"select doc.`*` from `table` as doc where doc.uid->>'$[0]' like '%test%z' or doc.uid->>'$[1]' like '%test%z' or doc.uid->>'$[2]' like '%test%z'");
    }

    @Test
    public void checkMultivaluedSubWithLowerFilters() throws SearchException {
        Filter filterSub1 = Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"uid"), null, (String[])new String[]{"test"}, null).multiValued();
        ConvertedExpression expressionSub1 = this.simpleConverter.convertToSqlFilter(null, filterSub1, null);
        String querySub1 = this.toSelectSQL(expressionSub1);
        Assert.assertEquals((String)querySub1, (String)"select doc.`*` from `table` as doc where lower(doc.uid)->>'$[0]' like '%test%'");
        Filter filterSub2 = Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"uid"), (String)"a", (String[])new String[]{"test"}, null).multiValued();
        ConvertedExpression expressionSub2 = this.simpleConverter.convertToSqlFilter(null, filterSub2, null);
        String querySub2 = this.toSelectSQL(expressionSub2);
        Assert.assertEquals((String)querySub2, (String)"select doc.`*` from `table` as doc where lower(doc.uid)->>'$[0]' like 'a%test%'");
        Filter filterSub3 = Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"uid"), null, (String[])new String[]{"test"}, (String)"z").multiValued();
        ConvertedExpression expressionSub3 = this.simpleConverter.convertToSqlFilter(null, filterSub3, null);
        String querySub3 = this.toSelectSQL(expressionSub3);
        Assert.assertEquals((String)querySub3, (String)"select doc.`*` from `table` as doc where lower(doc.uid)->>'$[0]' like '%test%z'");
        Filter filterSub4 = Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"uid"), null, (String[])new String[]{"test"}, (String)"z").multiValued(3);
        ConvertedExpression expressionSub4 = this.simpleConverter.convertToSqlFilter(null, filterSub4, null);
        String querySub4 = this.toSelectSQL(expressionSub4);
        Assert.assertEquals((String)querySub4, (String)"select doc.`*` from `table` as doc where lower(doc.uid)->>'$[0]' like '%test%z' or lower(doc.uid)->>'$[1]' like '%test%z' or lower(doc.uid)->>'$[2]' like '%test%z'");
    }

    @Test
    public void checkLowerFilters() throws SearchException {
        Filter userUidFilter1 = Filter.createEqualityFilter((Filter)Filter.createLowercaseFilter((String)"uid"), (Object)"test");
        ConvertedExpression expressionUserUid1 = this.simpleConverter.convertToSqlFilter(null, userUidFilter1, null);
        String queryUserUid1 = this.toSelectSQL(expressionUserUid1);
        Assert.assertEquals((String)queryUserUid1, (String)"select doc.`*` from `table` as doc where lower(doc.uid) = 'test'");
    }

    @Test
    public void checkMultivaluedLowerFilters() throws SearchException {
        Filter userUidFilter = Filter.createEqualityFilter((Filter)Filter.createLowercaseFilter((String)"uid"), (Object)"test").multiValued();
        ConvertedExpression expressionUserUid = this.simpleConverter.convertToSqlFilter(null, userUidFilter, null);
        String queryUserUid = this.toSelectSQL(expressionUserUid);
        Assert.assertEquals((String)queryUserUid, (String)"select doc.`*` from `table` as doc where JSON_CONTAINS(lower(doc.uid)->>'$', CAST('[\"test\"]' AS JSON))");
    }

    @Test
    public void checkNotFilters() throws SearchException {
        Filter notFilter1 = Filter.createNOTFilter((Filter)Filter.createLessOrEqualFilter((String)"age", (Object)23));
        ConvertedExpression expressionNot1 = this.simpleConverter.convertToSqlFilter(null, notFilter1, null);
        String queryUserUid1 = this.toSelectSQL(expressionNot1);
        Assert.assertEquals((String)queryUserUid1, (String)"select doc.`*` from `table` as doc where not doc.age <= 23");
        Filter notFilter2 = Filter.createNOTFilter((Filter)Filter.createANDFilter((Filter[])new Filter[]{Filter.createLessOrEqualFilter((String)"age", (Object)23), Filter.createGreaterOrEqualFilter((String)"age", (Object)25)}));
        ConvertedExpression expressionNot2 = this.simpleConverter.convertToSqlFilter(null, notFilter2, null);
        String queryUserUid2 = this.toSelectSQL(expressionNot2);
        Assert.assertEquals((String)queryUserUid2, (String)"select doc.`*` from `table` as doc where not (doc.age <= 23 and doc.age >= 25)");
    }

    @Test
    public void checkAndFilters() throws SearchException {
        Filter filterEq1 = Filter.createEqualityFilter((String)"uid", (Object)"test");
        Filter filterPresence1 = Filter.createPresenceFilter((String)"mail");
        Filter filterLe1 = Filter.createLessOrEqualFilter((String)"age", (Object)23);
        Filter filterAnd1 = Filter.createANDFilter((Filter[])new Filter[]{filterPresence1, filterEq1, filterLe1});
        ConvertedExpression expressionAnd1 = this.simpleConverter.convertToSqlFilter(null, filterAnd1, null);
        String queryAnd1 = this.toSelectSQL(expressionAnd1);
        Assert.assertEquals((String)queryAnd1, (String)"select doc.`*` from `table` as doc where doc.mail is not null and doc.uid = 'test' and doc.age <= 23");
    }

    @Test
    public void checkOrFilters() throws SearchException {
        Filter filterEq1 = Filter.createEqualityFilter((String)"uid", (Object)"test");
        Filter filterPresence1 = Filter.createPresenceFilter((String)"mail");
        Filter filterLe1 = Filter.createLessOrEqualFilter((String)"age", (Object)23);
        Filter filterOr1 = Filter.createORFilter((Filter[])new Filter[]{filterPresence1, filterEq1, filterLe1});
        ConvertedExpression expressionAnd1 = this.simpleConverter.convertToSqlFilter(null, filterOr1, null);
        String queryAnd1 = this.toSelectSQL(expressionAnd1);
        Assert.assertEquals((String)queryAnd1, (String)"select doc.`*` from `table` as doc where doc.mail is not null or doc.uid = 'test' or doc.age <= 23");
    }

    @Test
    public void checkOrJoinFilters() throws SearchException {
        Filter filterEq1 = Filter.createEqualityFilter((String)"uid", (Object)"test");
        Filter filterEq2 = Filter.createEqualityFilter((String)"uid", (Object)"test2");
        Filter filterEq3 = Filter.createEqualityFilter((String)"uid", (Object)"test3");
        Filter filterOr1 = Filter.createORFilter((Filter[])new Filter[]{filterEq1, filterEq2, filterEq3}).multiValued(Boolean.valueOf(false));
        ConvertedExpression expressionOr1 = this.simpleConverter.convertToSqlFilter(null, filterOr1, null);
        String queryOr1 = this.toSelectSQL(expressionOr1);
        Assert.assertEquals((String)queryOr1, (String)"select doc.`*` from `table` as doc where doc.uid in ('test', 'test2', 'test3')");
        Filter filterOr2 = Filter.createORFilter((Filter[])new Filter[]{filterEq1, filterEq2, filterEq3});
        ConvertedExpression expressionOr2 = this.simpleConverter.convertToSqlFilter(null, filterOr2, null);
        String queryOr2 = this.toSelectSQL(expressionOr2);
        Assert.assertEquals((String)queryOr2, (String)"select doc.`*` from `table` as doc where doc.uid = 'test' or doc.uid = 'test2' or doc.uid = 'test3'");
    }

    @Test
    public void checkOrWithLowerCaseFilter() throws SearchException {
        Filter displayNameFilter;
        Filter descriptionFilter;
        boolean useLowercaseFilter = true;
        String[] targetArray = new String[]{"test_value"};
        if (useLowercaseFilter) {
            descriptionFilter = Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"description"), null, (String[])targetArray, null);
            displayNameFilter = Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"displayName"), null, (String[])targetArray, null);
        } else {
            descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
            displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
        }
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{descriptionFilter, displayNameFilter});
        Filter typeFilter = Filter.createEqualityFilter((String)"jansScrTyp", (Object)"person_authentication");
        Filter filter = Filter.createANDFilter((Filter[])new Filter[]{searchFilter, typeFilter});
        ConvertedExpression expression = this.simpleConverter.convertToSqlFilter(null, filter, null);
        String query = this.toSelectSQL(expression);
        Assert.assertEquals((String)query, (String)"select doc.`*` from `table` as doc where (lower(doc.description) like '%test_value%' or lower(doc.displayName) like '%test_value%') and doc.jansScrTyp = 'person_authentication'");
    }

    private String toSelectSQL(ConvertedExpression convertedExpression) {
        SQLQuery sqlQuery = (SQLQuery)new SQLQuery(this.configuration).select((Expression)this.allPath).from(this.tableAlieasPath).where((Predicate)convertedExpression.expression());
        sqlQuery.setUseLiterals(true);
        String queryStr = sqlQuery.getSQL().getSQL().replace("\n", " ");
        return queryStr;
    }

    private static Date getUtcDateFromMillis(long millis) {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(millis);
        calendar.set(15, TimeZone.getTimeZone("UTC").getRawOffset());
        Date date = calendar.getTime();
        return date;
    }
}

