/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.sql.operation.impl;

import io.jans.orm.exception.operation.ConfigurationException;
import io.jans.orm.exception.operation.ConnectionException;
import io.jans.orm.util.PropertiesHelper;
import io.jans.orm.util.StringHelper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqConnectionProviderPool {
    private static final Logger LOG = LoggerFactory.getLogger(SqConnectionProviderPool.class);
    private static final String DRIVER_PROPERTIES_PREFIX = "connection.driver-property";
    protected Properties props;
    private String connectionUri;
    private Properties connectionProperties;
    private GenericObjectPoolConfig<PoolableConnection> objectPoolConfig;
    protected PoolingDataSource<PoolableConnection> poolingDataSource;
    protected int creationResultCode;

    protected SqConnectionProviderPool() {
    }

    public SqConnectionProviderPool(Properties props) {
        this.props = props;
    }

    public void create() {
        try {
            this.init();
        }
        catch (Exception ex) {
            this.creationResultCode = 1;
            Properties clonedProperties = (Properties)this.props.clone();
            if (clonedProperties.getProperty("auth.userName") != null) {
                clonedProperties.setProperty("auth.userPassword", "REDACTED");
            }
            LOG.error("Failed to create connection pool with properties: '{}'. Exception: {}", (Object)clonedProperties, (Object)ex);
        }
    }

    protected void init() throws Exception {
        Boolean testOnReturn;
        Boolean testOnCreate;
        Integer cpMaxWaitTimeMillis;
        Integer cpMinIdle;
        Integer cpMaxIdle;
        if (!this.props.containsKey("db.schema.name")) {
            throw new ConfigurationException("Property 'db.schema.name' is mandatory!");
        }
        if (!this.props.containsKey("connection.uri")) {
            throw new ConfigurationException("Property 'connection.uri' is mandatory!");
        }
        this.connectionUri = this.props.getProperty("connection.uri");
        Properties filteredDriverProperties = PropertiesHelper.findProperties((Properties)this.props, (String)DRIVER_PROPERTIES_PREFIX, (String)".");
        this.connectionProperties = new Properties();
        for (Map.Entry<Object, Object> driverPropertyEntry : filteredDriverProperties.entrySet()) {
            String key = StringHelper.toString((Object)driverPropertyEntry.getKey()).substring(DRIVER_PROPERTIES_PREFIX.length() + 1);
            String value = StringHelper.toString((Object)driverPropertyEntry.getValue());
            this.connectionProperties.put(key, value);
        }
        String userName = this.props.getProperty("auth.userName");
        String userPassword = this.props.getProperty("auth.userPassword");
        this.connectionProperties.setProperty("user", userName);
        this.connectionProperties.setProperty("password", userPassword);
        this.objectPoolConfig = new GenericObjectPoolConfig();
        Integer cpMaxTotal = StringHelper.toInteger((String)this.props.getProperty("connection.pool.max-total"), null);
        if (cpMaxTotal != null) {
            this.objectPoolConfig.setMaxTotal(cpMaxTotal.intValue());
        }
        if ((cpMaxIdle = StringHelper.toInteger((String)this.props.getProperty("connection.pool.max-idle"), null)) != null) {
            this.objectPoolConfig.setMaxIdle(cpMaxIdle.intValue());
        }
        if ((cpMinIdle = StringHelper.toInteger((String)this.props.getProperty("connection.pool.min-idle"), null)) != null) {
            this.objectPoolConfig.setMinIdle(cpMinIdle.intValue());
        }
        if ((cpMaxWaitTimeMillis = StringHelper.toInteger((String)this.props.getProperty("connection.pool.max-wait-time-millis"), null)) != null) {
            this.objectPoolConfig.setMaxWaitMillis((long)cpMaxWaitTimeMillis.intValue());
        }
        Integer cpMinEvictableIdleTimeMillis = StringHelper.toInteger((String)this.props.getProperty("connection.pool.min-evictable-idle-time-millis"), null);
        if (cpMaxWaitTimeMillis != null) {
            this.objectPoolConfig.setMinEvictableIdleTimeMillis((long)cpMinEvictableIdleTimeMillis.intValue());
        }
        if ((testOnCreate = StringHelper.toBoolean((String)this.props.getProperty("connection.pool.test-on-create"), null)) != null) {
            this.objectPoolConfig.setTestOnCreate(testOnCreate.booleanValue());
        }
        if ((testOnReturn = StringHelper.toBoolean((String)this.props.getProperty("connection.pool.test-on-return"), null)) != null) {
            this.objectPoolConfig.setTestOnReturn(testOnReturn.booleanValue());
        }
        this.openWithWaitImpl();
        this.creationResultCode = 0;
        LOG.info("Created connection pool");
    }

    private void openWithWaitImpl() throws Exception {
        long connectionMaxWaitTimeMillis = StringHelper.toLong((String)this.props.getProperty("connection.pool.create-max-wait-time-millis"), (long)30000L);
        LOG.debug("Using connection timeout: '{}'", (Object)connectionMaxWaitTimeMillis);
        Exception lastException = null;
        int attempt = 0;
        long currentTime = System.currentTimeMillis();
        long maxWaitTime = currentTime + connectionMaxWaitTimeMillis;
        while (true) {
            if (++attempt > 0) {
                LOG.info("Attempting to create connection pool: '{}'", (Object)attempt);
            }
            try {
                this.open();
                if (!this.isConnected()) {
                    LOG.info("Failed to connect to DB");
                    this.destroy();
                    throw new ConnectionException("Failed to create connection pool");
                }
            }
            catch (Exception ex) {
                lastException = ex;
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException ex2) {
                    LOG.error("Exception happened in sleep", (Throwable)ex2);
                    return;
                }
                if (maxWaitTime > (currentTime = System.currentTimeMillis())) continue;
            }
            break;
        }
        if (lastException != null) {
            throw lastException;
        }
    }

    private void open() throws ClassNotFoundException {
        this.preloadJdbcDriver();
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(this.connectionUri, this.connectionProperties);
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
        GenericObjectPool objectPool = new GenericObjectPool((PooledObjectFactory)poolableConnectionFactory, this.objectPoolConfig);
        poolableConnectionFactory.setPool((ObjectPool)objectPool);
        this.poolingDataSource = new PoolingDataSource((ObjectPool)objectPool);
    }

    public void preloadJdbcDriver() throws ClassNotFoundException {
        if (this.props.containsKey("jdbc.driver.class-name")) {
            Class.forName(this.props.getProperty("jdbc.driver.class-name"));
        }
    }

    public int getCreationResultCode() {
        return this.creationResultCode;
    }

    public boolean isCreated() {
        return 0 == this.creationResultCode;
    }

    public boolean isConnected() {
        boolean bl;
        block9: {
            if (this.poolingDataSource == null) {
                return false;
            }
            boolean isConnected = true;
            Connection con = this.poolingDataSource.getConnection();
            try {
                bl = con.isValid(30);
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    LOG.error("Failed to check connection", (Throwable)ex);
                    isConnected = false;
                    return isConnected;
                }
            }
            con.close();
        }
        return bl;
    }

    public Connection getConnection() {
        try {
            return this.poolingDataSource.getConnection();
        }
        catch (SQLException ex) {
            throw new ConnectionException("Failed to get connection from pool", (Throwable)ex);
        }
    }

    public boolean destroy() {
        boolean result = true;
        if (this.poolingDataSource != null) {
            try {
                this.poolingDataSource.close();
            }
            catch (RuntimeException ex) {
                LOG.error("Failed to close connection pool", (Throwable)ex);
                result = false;
            }
            catch (SQLException ex) {
                LOG.error("Failed to close connection pool. Erorr code: '{}'", (Object)ex.getErrorCode(), (Object)ex);
                result = false;
            }
        }
        return result;
    }
}

