/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.service;

import io.jans.orm.PersistenceEntryManagerFactory;
import io.jans.orm.exception.PropertyNotFoundException;
import io.jans.orm.exception.operation.ConfigurationException;
import io.jans.orm.model.PersistenceConfiguration;
import io.jans.orm.reflect.util.ReflectHelper;
import io.jans.orm.service.BaseFactoryService;
import io.jans.orm.service.PersistanceFactoryService;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class StandalonePersistanceFactoryService
extends PersistanceFactoryService {
    private HashMap<String, PersistenceEntryManagerFactory> persistenceEntryManagerFactoryNames;
    private HashMap<Class<? extends PersistenceEntryManagerFactory>, PersistenceEntryManagerFactory> persistenceEntryManagerFactoryTypes;
    private Set<String> initializedFactories = new HashSet<String>();

    public PersistenceEntryManagerFactory getPersistenceEntryManagerFactory(PersistenceConfiguration persistenceConfiguration) {
        return this.getPersistenceEntryManagerFactory(persistenceConfiguration.getEntryManagerFactoryType());
    }

    public PersistenceEntryManagerFactory getPersistenceEntryManagerFactory(Class<? extends PersistenceEntryManagerFactory> persistenceEntryManagerFactoryClass) {
        if (this.persistenceEntryManagerFactoryTypes == null) {
            this.initPersistenceManagerMaps();
        }
        PersistenceEntryManagerFactory persistenceEntryManagerFactory = this.persistenceEntryManagerFactoryTypes.get(persistenceEntryManagerFactoryClass);
        this.initFactory(persistenceEntryManagerFactory);
        return persistenceEntryManagerFactory;
    }

    private void initFactory(PersistenceEntryManagerFactory persistenceEntryManagerFactory) {
        String persistenceType = persistenceEntryManagerFactory.getPersistenceType();
        if (!this.initializedFactories.contains(persistenceType)) {
            persistenceEntryManagerFactory.initStandalone((BaseFactoryService)this);
            this.initializedFactories.add(persistenceType);
        }
    }

    public PersistenceEntryManagerFactory getPersistenceEntryManagerFactory(String persistenceType) {
        if (this.persistenceEntryManagerFactoryNames == null) {
            this.initPersistenceManagerMaps();
        }
        PersistenceEntryManagerFactory persistenceEntryManagerFactory = this.persistenceEntryManagerFactoryNames.get(persistenceType);
        this.initFactory(persistenceEntryManagerFactory);
        return persistenceEntryManagerFactory;
    }

    private void initPersistenceManagerMaps() {
        this.persistenceEntryManagerFactoryNames = new HashMap();
        this.persistenceEntryManagerFactoryTypes = new HashMap();
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)"io.jans.orm", (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{Scanners.SubTypes}));
        Set classes = reflections.getSubTypesOf(PersistenceEntryManagerFactory.class);
        this.getLog().info("Found '{}' PersistenceEntryManagerFactory", (Object)classes.size());
        ArrayList classesList = new ArrayList(classes);
        for (Class clazz : classesList) {
            this.getLog().info("Found PersistenceEntryManagerFactory '{}'", (Object)clazz);
            PersistenceEntryManagerFactory persistenceEntryManagerFactory = this.createPersistenceEntryManagerFactoryImpl(clazz);
            this.persistenceEntryManagerFactoryNames.put(persistenceEntryManagerFactory.getPersistenceType(), persistenceEntryManagerFactory);
            this.persistenceEntryManagerFactoryTypes.put(clazz, persistenceEntryManagerFactory);
        }
    }

    private PersistenceEntryManagerFactory createPersistenceEntryManagerFactoryImpl(Class<? extends PersistenceEntryManagerFactory> persistenceEntryManagerFactoryClass) {
        PersistenceEntryManagerFactory persistenceEntryManagerFactory;
        try {
            persistenceEntryManagerFactory = (PersistenceEntryManagerFactory)ReflectHelper.createObjectByDefaultConstructor(persistenceEntryManagerFactoryClass);
        }
        catch (PropertyNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new ConfigurationException(String.format("Failed to create PersistenceEntryManagerFactory by type '%s'!", persistenceEntryManagerFactoryClass));
        }
        return persistenceEntryManagerFactory;
    }
}

