/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim2.client.rest.provider;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.scim.model.scim2.BaseScimResource;
import io.jans.scim.model.scim2.ListResponse;
import io.jans.scim.model.scim2.util.IntrospectUtil;
import io.jans.scim.model.scim2.util.ScimResourceUtil;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Provider
@Consumes(value={"application/scim+json", "application/json"})
public class ListResponseProvider
implements MessageBodyReader<ListResponse> {
    private Logger logger = LogManager.getLogger(this.getClass());
    private ObjectMapper mapper = new ObjectMapper();

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(ListResponse.class);
    }

    public ListResponse readFrom(Class type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        InputStreamReader isr = new InputStreamReader(entityStream, Charset.forName("UTF-8"));
        ArrayList<BaseScimResource> resources = null;
        Map map = (Map)this.mapper.readValue((Reader)isr, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Object branch = map.remove("Resources");
        if (branch != null) {
            resources = new ArrayList<BaseScimResource>();
            for (Object resource : (Collection)branch) {
                Map resourceAsMap = IntrospectUtil.strObjMap(resource);
                List schemas = (List)resourceAsMap.get("schemas");
                block1: for (String schema : schemas) {
                    for (Class cls : IntrospectUtil.allAttrs.keySet()) {
                        if (!ScimResourceUtil.getSchemaAnnotation((Class)cls).id().equals(schema)) continue;
                        resources.add((BaseScimResource)this.mapper.convertValue(resource, cls));
                        this.logger.trace("Found resource of class {} in ListResponse", (Object)cls.getSimpleName());
                        continue block1;
                    }
                }
            }
        }
        ListResponse response = (ListResponse)this.mapper.convertValue((Object)map, ListResponse.class);
        response.setResources(resources);
        return response;
    }
}

