/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim.model;

import io.jans.orm.annotation.CustomObjectClass;
import io.jans.orm.model.base.Entry;
import io.jans.scim.model.JansCustomAttribute;
import io.jans.util.StringHelper;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public abstract class CustomEntry
extends Entry
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 5079582184398161111L;
    @CustomObjectClass
    private String[] customObjectClasses;

    public abstract List<JansCustomAttribute> getCustomAttributes();

    public abstract void setCustomAttributes(List<JansCustomAttribute> var1);

    public String[] getCustomObjectClasses() {
        return this.customObjectClasses;
    }

    public void setCustomObjectClasses(String[] customObjectClasses) {
        this.customObjectClasses = customObjectClasses;
    }

    public String[] getAttributes(String attributeName) {
        if (StringHelper.isEmpty((String)attributeName)) {
            return null;
        }
        String[] values = null;
        for (JansCustomAttribute attribute : this.getCustomAttributes()) {
            if (!StringHelper.equalsIgnoreCase((String)attribute.getName(), (String)attributeName)) continue;
            values = attribute.getValues();
            break;
        }
        return values;
    }

    public String getAttribute(String attributeName) {
        if (StringHelper.isEmpty((String)attributeName)) {
            return null;
        }
        String value = null;
        for (JansCustomAttribute attribute : this.getCustomAttributes()) {
            if (!StringHelper.equalsIgnoreCase((String)attribute.getName(), (String)attributeName)) continue;
            value = attribute.getValue();
            break;
        }
        return value;
    }

    public String getAttribute(String attributeName, String defaultValue) {
        String result = this.getAttribute(attributeName);
        if (StringHelper.isEmpty((String)result)) {
            result = defaultValue;
        }
        return result;
    }

    public void setAttribute(String attributeName, String attributeValue) {
        this.setAttribute(new JansCustomAttribute(attributeName, attributeValue));
    }

    public void setAttribute(String attributeName, String[] attributeValue) {
        this.setAttribute(new JansCustomAttribute(attributeName, attributeValue));
    }

    public void setAttribute(JansCustomAttribute attribute) {
        List<JansCustomAttribute> customAttributes = this.getCustomAttributes();
        customAttributes.remove(attribute);
        customAttributes.add(attribute);
    }

    public String toString() {
        return String.format("CustomEntry [customAttributes=%s, customObjectClasses=%s, toString()=%s]", this.getCustomAttributes(), Arrays.toString(this.customObjectClasses), super.toString());
    }
}

