/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.jans.orm.annotation.AttributeName;
import io.jans.orm.annotation.DataEntry;
import io.jans.orm.annotation.JsonObject;
import io.jans.orm.annotation.ObjectClass;
import io.jans.scim.model.JansCustomAttribute;
import io.jans.scim.model.OTPDevice;
import io.jans.scim.model.User;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

@DataEntry(sortBy={"displayName"})
@ObjectClass(value="jansPerson")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class JansCustomPerson
extends User
implements Serializable {
    private static final long serialVersionUID = -1879582184398161112L;
    private transient boolean selected;
    private String sourceServerName;
    private String sourceServerUserDn;
    @AttributeName(name="jansGuid")
    private String guid;
    @AttributeName(name="jansOptOuts")
    private List<String> optOuts;
    @AttributeName(name="jansAssociatedClnt")
    private List<String> associatedClient;
    @AttributeName(name="jansPPID")
    private List<String> ppid;
    @AttributeName(name="jansExtUid")
    private List<String> externalUid;
    @JsonObject
    @AttributeName(name="jansOTPDevices")
    private OTPDevice otpDevices;
    @AttributeName(name="jansMobileDevices")
    private String mobileDevices;
    @AttributeName(name="jansCreationTimestamp")
    private Date creationDate;
    @AttributeName
    private Date updatedAt;

    public String getMobileDevices() {
        return this.mobileDevices;
    }

    public void setMobileDevices(String mobileDevices) {
        this.mobileDevices = mobileDevices;
    }

    public OTPDevice getOtpDevices() {
        return this.otpDevices;
    }

    public void setOtpDevices(OTPDevice otpDevices) {
        this.otpDevices = otpDevices;
    }

    public String getMail() {
        return this.getAttribute("mail");
    }

    public void setMail(String value) {
        this.setAttribute("mail", value);
    }

    public String getNetworkPoken() {
        return this.getAttribute("networkPoken");
    }

    public void setNetworkPoken(String value) {
        this.setAttribute("networkPoken", value);
    }

    public String getCommonName() {
        return this.getAttribute("cn");
    }

    public void setCommonName(String value) {
        this.setAttribute("cn", value);
    }

    public String getGivenName() {
        return this.getAttribute("givenName");
    }

    public void setGivenName(String value) {
        this.setAttribute("givenName", value);
    }

    public String getStatus() {
        return this.getAttribute("jansStatus");
    }

    public void setStatus(String value) {
        this.setAttribute("jansStatus", value);
    }

    public String getUserPassword() {
        return this.getAttribute("userPassword");
    }

    public void setUserPassword(String value) {
        this.setAttribute("userPassword", value);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public Boolean getSLAManager() {
        return Boolean.valueOf(this.getAttribute("jansSLAManager"));
    }

    public void setSLAManager(Boolean value) {
        this.setAttribute("jansSLAManager", value.toString());
    }

    public List<String> getMemberOf() {
        String[] value = new String[]{};
        for (JansCustomAttribute attribute : this.customAttributes) {
            if (!attribute.getName().equalsIgnoreCase("memberOf")) continue;
            value = attribute.getValues();
            break;
        }
        return Arrays.asList(value);
    }

    public void setMemberOf(List<String> value) {
        this.setAttribute("memberOf", value.toArray(new String[0]));
    }

    public String getSurname() {
        return this.getAttribute("sn");
    }

    public void setSurname(String value) {
        this.setAttribute("sn", value);
    }

    public void setTimezone(String value) {
        this.setAttribute("zoneinfo", value);
    }

    public String getTimezone() {
        return this.getAttribute("zoneinfo");
    }

    public void setPreferredLanguage(String value) {
        this.setAttribute("preferredLanguage", value);
    }

    public String getPreferredLanguage() {
        return this.getAttribute("preferredLanguage");
    }

    public int getAttributeIndex(String attributeName) {
        int idx = 0;
        for (JansCustomAttribute attribute : this.customAttributes) {
            if (attribute.getName().equalsIgnoreCase(attributeName)) {
                return idx;
            }
            ++idx;
        }
        return idx;
    }

    @Override
    public String getAttribute(String attributeName) {
        String value = null;
        for (JansCustomAttribute attribute : this.customAttributes) {
            if (!attribute.getName().equalsIgnoreCase(attributeName)) continue;
            value = attribute.getValue();
            break;
        }
        return value;
    }

    public String[] getAttributeValues(String attributeName) {
        String[] value = null;
        for (JansCustomAttribute attribute : this.customAttributes) {
            if (!attribute.getName().equalsIgnoreCase(attributeName)) continue;
            value = attribute.getValues();
            break;
        }
        return value;
    }

    public String[] getAttributeArray(String attributeName) {
        JansCustomAttribute gluuCustomAttribute = this.getJansCustomAttribute(attributeName);
        if (gluuCustomAttribute == null) {
            return null;
        }
        return gluuCustomAttribute.getValues();
    }

    public JansCustomAttribute getJansCustomAttribute(String attributeName) {
        for (JansCustomAttribute gluuCustomAttribute : this.customAttributes) {
            if (!gluuCustomAttribute.getName().equalsIgnoreCase(attributeName)) continue;
            return gluuCustomAttribute;
        }
        return null;
    }

    @Override
    public void setAttribute(String attributeName, String attributeValue) {
        JansCustomAttribute attribute = new JansCustomAttribute(attributeName, attributeValue);
        this.customAttributes.remove(attribute);
        this.customAttributes.add(attribute);
    }

    @Override
    public void setAttribute(String attributeName, String[] attributeValue) {
        JansCustomAttribute attribute = new JansCustomAttribute(attributeName, attributeValue);
        this.customAttributes.remove(attribute);
        this.customAttributes.add(attribute);
    }

    public void removeAttribute(String attributeName) {
        Iterator it = this.customAttributes.iterator();
        while (it.hasNext()) {
            JansCustomAttribute attribute = (JansCustomAttribute)it.next();
            if (!attribute.getName().equalsIgnoreCase(attributeName)) continue;
            it.remove();
            break;
        }
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public List<String> getOptOuts() {
        return this.optOuts;
    }

    public void setOptOuts(List<String> optOuts) {
        this.optOuts = optOuts;
    }

    public List<String> getAssociatedClient() {
        return this.associatedClient;
    }

    public void setAssociatedClient(List<String> jsAssociatedClntDNs) {
        this.associatedClient = jsAssociatedClntDNs;
    }

    public String getSourceServerName() {
        return this.sourceServerName;
    }

    public void setSourceServerName(String sourceServerName) {
        this.sourceServerName = sourceServerName;
    }

    public final String getSourceServerUserDn() {
        return this.sourceServerUserDn;
    }

    public final void setSourceServerUserDn(String sourceServerUserDn) {
        this.sourceServerUserDn = sourceServerUserDn;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public List<String> getExternalUid() {
        return this.externalUid;
    }

    public void setExternalUid(List<String> externalUid) {
        this.externalUid = externalUid;
    }

    public List<String> getPpid() {
        return this.ppid;
    }

    public void setPpid(List<String> ppid) {
        this.ppid = ppid;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && this.getInum() != null && obj instanceof JansCustomPerson) {
            result = this.getInum().equals(((JansCustomPerson)obj).getInum());
        }
        return result;
    }

    public JansCustomPerson clone() throws CloneNotSupportedException {
        return (JansCustomPerson)super.clone();
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }
}

