/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.jans.model.GluuStatus;
import io.jans.orm.annotation.AttributeName;
import io.jans.orm.annotation.AttributesList;
import io.jans.orm.annotation.DataEntry;
import io.jans.orm.annotation.ObjectClass;
import io.jans.orm.model.base.Entry;
import io.jans.scim.model.JansCustomAttribute;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@DataEntry(sortBy={"displayName"})
@ObjectClass(value="jansGrp")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class JansGroup
extends Entry
implements Serializable {
    private static final long serialVersionUID = -2812480357430436503L;
    private transient boolean selected;
    @AttributeName(ignoreDuringUpdate=true)
    private String inum;
    @NotNull
    @Size(min=0, max=60, message="Length of the Display Name should not exceed 60")
    @AttributeName
    private @NotNull @Size(min=0, max=60, message="Length of the Display Name should not exceed 60") String displayName;
    @Size(min=0, max=4000, message="Length of the Description should not exceed 4000")
    @AttributeName
    private @Size(min=0, max=4000, message="Length of the Description should not exceed 4000") String description;
    @NotNull
    @AttributeName
    private String owner;
    @AttributeName(name="member")
    private List<String> members = new ArrayList<String>();
    @AttributeName(name="c")
    private String countryName;
    @AttributeName(name="o")
    private String organization;
    @AttributeName
    private String seeAlso;
    @AttributeName(name="jansStatus")
    private GluuStatus status;
    @AttributesList(name="name", value="values", sortByName=true, attributesConfiguration={@AttributeName(name="inum", ignoreDuringUpdate=true)})
    private List<JansCustomAttribute> customAttributes = new ArrayList<JansCustomAttribute>();

    public String getInum() {
        return this.inum;
    }

    public void setInum(String inum) {
        this.inum = inum;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public List<String> getMembers() {
        return this.members;
    }

    public void setMembers(List<String> members) {
        this.members = members;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getSeeAlso() {
        return this.seeAlso;
    }

    public void setSeeAlso(String seeAlso) {
        this.seeAlso = seeAlso;
    }

    public GluuStatus getStatus() {
        return this.status;
    }

    public void setStatus(GluuStatus status) {
        this.status = status;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String toString() {
        return String.format("JansGroup [countryName=%s, description=%s, displayName=%s,  inum=%s, members=%s, organization=%s, owner=%s, seeAlso=%s, status=%s, toString()=%s]", this.countryName, this.description, this.displayName, this.inum, this.members, this.organization, this.owner, this.seeAlso, this.status, super.toString());
    }

    public List<JansCustomAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(List<JansCustomAttribute> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public String getAttribute(String attributeName) {
        String value = null;
        for (JansCustomAttribute attribute : this.customAttributes) {
            if (!attribute.getName().equalsIgnoreCase(attributeName)) continue;
            value = attribute.getValue();
            break;
        }
        return value;
    }

    public String[] getAttributeArray(String attributeName) {
        JansCustomAttribute gluuCustomAttribute = this.getJansCustomAttribute(attributeName);
        if (gluuCustomAttribute == null) {
            return null;
        }
        return gluuCustomAttribute.getValues();
    }

    public JansCustomAttribute getJansCustomAttribute(String attributeName) {
        for (JansCustomAttribute gluuCustomAttribute : this.customAttributes) {
            if (!gluuCustomAttribute.getName().equalsIgnoreCase(attributeName)) continue;
            return gluuCustomAttribute;
        }
        return null;
    }

    public void setAttribute(String attributeName, String attributeValue) {
        JansCustomAttribute attribute = new JansCustomAttribute(attributeName, attributeValue);
        this.customAttributes.remove(attribute);
        this.customAttributes.add(attribute);
    }

    public void setAttribute(String attributeName, String[] attributeValue) {
        JansCustomAttribute attribute = new JansCustomAttribute(attributeName, attributeValue);
        this.customAttributes.remove(attribute);
        this.customAttributes.add(attribute);
    }
}

