/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim.service;

import io.jans.model.ApplicationType;
import io.jans.orm.PersistenceEntryManager;
import io.jans.scim.model.JansOrganization;
import io.jans.scim.model.conf.AppConfiguration;
import io.jans.service.BaseCacheService;
import io.jans.service.CacheService;
import io.jans.service.LocalCacheService;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.slf4j.Logger;

@ApplicationScoped
@Priority(value=5)
@Named(value="organizationService")
public class OrganizationService
extends io.jans.service.OrganizationService {
    private static final long serialVersionUID = -1959146007518514678L;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private CacheService cacheService;
    @Inject
    private LocalCacheService localCacheService;
    @Inject
    private AppConfiguration appConfiguration;

    public JansOrganization getOrganization() {
        String key;
        BaseCacheService usedCacheService = this.getCacheService();
        JansOrganization organization = (JansOrganization)usedCacheService.get(key = this.getDnForOrganization());
        if (organization == null) {
            organization = (JansOrganization)this.persistenceEntryManager.find(JansOrganization.class, (Object)key);
            usedCacheService.put(key, (Object)organization);
        }
        return organization;
    }

    public String getDnForOrganization() {
        return this.getDnForOrganization(this.appConfiguration.getBaseDN());
    }

    public String getBaseDn() {
        return this.appConfiguration.getBaseDN();
    }

    private BaseCacheService getCacheService() {
        if (this.appConfiguration.getUseLocalCache().booleanValue()) {
            return this.localCacheService;
        }
        return this.cacheService;
    }

    public ApplicationType getApplicationType() {
        return ApplicationType.SCIM;
    }
}

