/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim.service;

import io.jans.as.model.common.IdType;
import io.jans.model.JansAttribute;
import io.jans.model.user.SimpleUser;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.exception.operation.DuplicateEntryException;
import io.jans.orm.model.AttributeData;
import io.jans.orm.model.SearchScope;
import io.jans.orm.model.base.SimpleBranch;
import io.jans.orm.search.filter.Filter;
import io.jans.scim.exception.DuplicateEmailException;
import io.jans.scim.model.JansCustomAttribute;
import io.jans.scim.model.JansCustomPerson;
import io.jans.scim.model.User;
import io.jans.scim.service.AttributeService;
import io.jans.scim.service.ExternalIdGeneratorService;
import io.jans.scim.service.OrganizationService;
import io.jans.util.ArrayHelper;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;

@ApplicationScoped
public class PersonService
implements Serializable {
    private static final long serialVersionUID = 6685720517520443399L;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private AttributeService attributeService;
    @Inject
    private OrganizationService organizationService;
    @Inject
    private ExternalIdGeneratorService idGeneratorService;
    private List<JansCustomAttribute> mandatoryAttributes;

    public void addCustomObjectClass(JansCustomPerson person) {
        String customObjectClass = this.attributeService.getCustomOrigin();
        Object[] customObjectClassesArray = person.getCustomObjectClasses();
        if (ArrayHelper.isNotEmpty((Object[])customObjectClassesArray)) {
            List<Object> customObjectClassesList = Arrays.asList(customObjectClassesArray);
            if (!customObjectClassesList.contains(customObjectClass)) {
                ArrayList<Object> customObjectClassesListUpdated = new ArrayList<Object>();
                customObjectClassesListUpdated.addAll(customObjectClassesList);
                customObjectClassesListUpdated.add(customObjectClass);
                customObjectClassesList = customObjectClassesListUpdated;
            }
            person.setCustomObjectClasses(customObjectClassesList.toArray(new String[0]));
        } else {
            person.setCustomObjectClasses(new String[]{customObjectClass});
        }
    }

    public void addPerson(JansCustomPerson person) throws Exception {
        try {
            List<JansCustomPerson> persons = this.getPersonsByUid(person.getUid(), new String[0]);
            if (persons != null && persons.size() != 0) {
                throw new DuplicateEntryException("Duplicate UID value: " + person.getUid());
            }
            person.setCreationDate(new Date());
            this.attributeService.applyMetaData(person.getCustomAttributes());
            this.ignoreCustomObjectClassesForNonLDAP(person);
            this.persistenceEntryManager.persist((Object)person);
        }
        catch (Exception e) {
            if (e.getCause().getMessage().contains("unique attribute conflict was detected for attribute mail")) {
                throw new DuplicateEmailException("Email Already Registered");
            }
            throw new Exception("Duplicate UID value: " + person.getUid());
        }
    }

    private JansCustomPerson ignoreCustomObjectClassesForNonLDAP(JansCustomPerson person) {
        String persistenceType = this.persistenceEntryManager.getPersistenceType();
        this.log.debug("persistenceType: {}", (Object)persistenceType);
        if (!PersistenceEntryManager.PERSITENCE_TYPES.ldap.name().equals(persistenceType)) {
            this.log.debug("Setting CustomObjectClasses :{} to null as it's used only for LDAP and current persistenceType is {} ", (Object)person.getCustomObjectClasses(), (Object)persistenceType);
            person.setCustomObjectClasses(null);
        }
        return person;
    }

    public void updatePerson(JansCustomPerson person) throws Exception {
        try {
            Date updateDate = new Date();
            person.setUpdatedAt(updateDate);
            if (person.getAttribute("jansMetaLastMod") != null) {
                person.setAttribute("jansMetaLastMod", Instant.ofEpochMilli(updateDate.getTime()).toString());
            }
            this.attributeService.applyMetaData(person.getCustomAttributes());
            this.persistenceEntryManager.merge((Object)person);
        }
        catch (Exception e) {
            if (e.getCause().getMessage().contains("unique attribute conflict was detected for attribute mail")) {
                throw new DuplicateEmailException("Email Already Registered");
            }
            throw new Exception("Duplicate UID value: " + person.getUid(), e);
        }
    }

    public void removePerson(JansCustomPerson person) {
        this.persistenceEntryManager.removeRecursively(person.getDn(), JansCustomPerson.class);
    }

    public List<JansCustomPerson> searchPersons(String pattern, int sizeLimit) {
        Filter searchFilter = this.buildFilter(pattern);
        return this.persistenceEntryManager.findEntries(this.getDnForPerson(null), JansCustomPerson.class, searchFilter, sizeLimit);
    }

    public List<JansCustomPerson> searchPersons(String pattern) {
        Filter searchFilter = this.buildFilter(pattern);
        return this.persistenceEntryManager.findEntries(this.getDnForPerson(null), JansCustomPerson.class, searchFilter);
    }

    private Filter buildFilter(String pattern) {
        String[] targetArray = new String[]{pattern};
        Filter uidFilter = Filter.createSubstringFilter((String)"uid", null, (String[])targetArray, null);
        Filter mailFilter = Filter.createSubstringFilter((String)"mail", null, (String[])targetArray, null);
        Filter nameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
        Filter ppidFilter = Filter.createSubstringFilter((String)"jansPPID", null, (String[])targetArray, null);
        Filter inumFilter = Filter.createSubstringFilter((String)"inum", null, (String[])targetArray, null);
        Filter snFilter = Filter.createSubstringFilter((String)"sn", null, (String[])targetArray, null);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{uidFilter, mailFilter, nameFilter, ppidFilter, inumFilter, snFilter});
        return searchFilter;
    }

    public List<JansCustomPerson> findPersons(JansCustomPerson person, int sizeLimit) {
        person.setBaseDn(this.getDnForPerson(null));
        return this.persistenceEntryManager.findEntries((Object)person, sizeLimit);
    }

    public List<JansCustomPerson> searchPersons(String pattern, int sizeLimit, List<JansCustomPerson> excludedPersons) throws Exception {
        Filter orFilter;
        Filter searchFilter = orFilter = this.buildFilter(pattern);
        if (excludedPersons != null && excludedPersons.size() > 0) {
            ArrayList<Filter> excludeFilters = new ArrayList<Filter>();
            for (JansCustomPerson excludedPerson : excludedPersons) {
                Filter eqFilter = Filter.createEqualityFilter((String)"uid", (Object)excludedPerson.getUid());
                excludeFilters.add(eqFilter);
            }
            Filter orExcludeFilter = null;
            orExcludeFilter = excludedPersons.size() == 1 ? (Filter)excludeFilters.get(0) : Filter.createORFilter(excludeFilters);
            Filter notFilter = Filter.createNOTFilter((Filter)orExcludeFilter);
            searchFilter = Filter.createANDFilter((Filter[])new Filter[]{orFilter, notFilter});
        }
        return this.persistenceEntryManager.findEntries(this.getDnForPerson(null), JansCustomPerson.class, searchFilter, sizeLimit);
    }

    public List<JansCustomPerson> findAllPersons(String[] returnAttributes) {
        return this.persistenceEntryManager.findEntries(this.getDnForPerson(null), JansCustomPerson.class, null, returnAttributes);
    }

    public List<JansCustomPerson> findPersonsByUids(List<String> uids, String[] returnAttributes) throws Exception {
        ArrayList<Filter> uidFilters = new ArrayList<Filter>();
        for (String uid : uids) {
            uidFilters.add(Filter.createEqualityFilter((String)"uid", (Object)uid));
        }
        Filter filter = Filter.createORFilter(uidFilters);
        return this.persistenceEntryManager.findEntries(this.getDnForPerson(null), JansCustomPerson.class, filter, returnAttributes);
    }

    public List<JansCustomPerson> findPersonsByMailids(List<String> mailids, String[] returnAttributes) throws Exception {
        ArrayList<Filter> mailidFilters = new ArrayList<Filter>();
        for (String mailid : mailids) {
            mailidFilters.add(Filter.createEqualityFilter((String)"mail", (Object)mailid));
        }
        Filter filter = Filter.createORFilter(mailidFilters);
        return this.persistenceEntryManager.findEntries(this.getDnForPerson(null), JansCustomPerson.class, filter, returnAttributes);
    }

    public JansCustomPerson findPersonByDn(String dn, String ... returnAttributes) {
        return (JansCustomPerson)this.persistenceEntryManager.find((Object)dn, JansCustomPerson.class, returnAttributes);
    }

    public boolean containsPerson(JansCustomPerson person) {
        boolean result = false;
        try {
            result = this.persistenceEntryManager.contains(JansCustomPerson.class);
        }
        catch (Exception e) {
            this.log.debug(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public boolean contains(String dn) {
        return this.persistenceEntryManager.contains(dn, JansCustomPerson.class);
    }

    public JansCustomPerson getPersonByDn(String dn) {
        JansCustomPerson result = (JansCustomPerson)this.persistenceEntryManager.find(JansCustomPerson.class, (Object)dn);
        return result;
    }

    public JansCustomPerson getPersonByInum(String inum) {
        JansCustomPerson person = null;
        try {
            person = (JansCustomPerson)this.persistenceEntryManager.find(JansCustomPerson.class, (Object)this.getDnForPerson(inum));
        }
        catch (Exception e) {
            this.log.error("Failed to find Person by Inum " + inum, (Throwable)e);
        }
        return person;
    }

    public JansCustomPerson getPersonByUid(String uid, String ... returnAttributes) {
        List<JansCustomPerson> entries = this.getPersonsByUid(uid, returnAttributes);
        if (entries.size() > 0) {
            return entries.get(0);
        }
        return null;
    }

    public int countPersons() {
        String dn = this.getDnForPerson(null);
        Class<JansCustomPerson> searchClass = JansCustomPerson.class;
        if (this.persistenceEntryManager.hasBranchesSupport(dn)) {
            searchClass = SimpleBranch.class;
        }
        return this.persistenceEntryManager.countEntries(dn, searchClass, null, SearchScope.BASE);
    }

    public String generateInumForNewPerson() {
        JansCustomPerson person = null;
        String newInum = null;
        String newDn = null;
        do {
            newInum = this.generateInumForNewPersonImpl();
            newDn = this.getDnForPerson(newInum);
            person = new JansCustomPerson();
            person.setDn(newDn);
        } while (this.persistenceEntryManager.contains(newDn, JansCustomPerson.class));
        return newInum;
    }

    private String generateInumForNewPersonImpl() {
        String id = null;
        if (this.idGeneratorService.isEnabled()) {
            id = this.idGeneratorService.executeExternalGenerateIdMethod(this.idGeneratorService.getCustomScriptConfigurations().stream().findFirst().orElse(null), "", IdType.PEOPLE.getType(), "");
        }
        return id == null ? UUID.randomUUID().toString() : id;
    }

    public String getDnForPerson(String inum) {
        String orgDn = this.organizationService.getDnForOrganization();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=people,%s", orgDn);
        }
        return String.format("inum=%s,ou=people,%s", inum, orgDn);
    }

    public boolean authenticate(String userName, String password) {
        return this.persistenceEntryManager.authenticate(userName, password);
    }

    public List<JansCustomAttribute> getMandatoryAtributes() {
        if (this.mandatoryAttributes == null) {
            this.mandatoryAttributes = new ArrayList<JansCustomAttribute>();
            this.mandatoryAttributes.add(new JansCustomAttribute("uid", "", true, true));
            this.mandatoryAttributes.add(new JansCustomAttribute("givenName", "", true, true));
            this.mandatoryAttributes.add(new JansCustomAttribute("displayName", "", true, true));
            this.mandatoryAttributes.add(new JansCustomAttribute("sn", "", true, true));
            this.mandatoryAttributes.add(new JansCustomAttribute("mail", "", true, true));
            this.mandatoryAttributes.add(new JansCustomAttribute("userPassword", "", true, true));
            this.mandatoryAttributes.add(new JansCustomAttribute("jansStatus", "", true, true));
        }
        return this.mandatoryAttributes;
    }

    public String getPersonUids(List<JansCustomPerson> persons) throws Exception {
        StringBuilder sb = new StringBuilder();
        Iterator<JansCustomPerson> iterator = persons.iterator();
        while (iterator.hasNext()) {
            JansCustomPerson call = iterator.next();
            sb.append('\'').append(call.getUid()).append('\'');
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public String getPersonMailids(List<JansCustomPerson> persons) throws Exception {
        StringBuilder sb = new StringBuilder();
        Iterator<JansCustomPerson> iterator = persons.iterator();
        while (iterator.hasNext()) {
            JansCustomPerson call = iterator.next();
            sb.append('\'').append(call.getMail()).append('\'');
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public List<JansCustomPerson> createEntities(Map<String, List<AttributeData>> entriesAttributes) throws Exception {
        return this.persistenceEntryManager.createEntities(JansCustomPerson.class, entriesAttributes);
    }

    public JansCustomPerson getPersonByEmail(String mail, String ... returnAttributes) {
        List<JansCustomPerson> persons = this.getPersonsByEmail(mail, returnAttributes);
        if (persons != null && persons.size() > 0) {
            return persons.get(0);
        }
        return null;
    }

    public List<JansCustomPerson> getPersonsByUid(String uid, String ... returnAttributes) {
        this.log.debug("Getting user information from DB: userId = {}", (Object)uid);
        if (StringHelper.isEmpty((String)uid)) {
            return null;
        }
        Filter userUidFilter = Filter.createEqualityFilter((Filter)Filter.createLowercaseFilter((String)"uid"), (Object)StringHelper.toLowerCase((String)uid));
        List entries = this.persistenceEntryManager.findEntries(this.getDnForPerson(null), JansCustomPerson.class, userUidFilter, returnAttributes);
        this.log.debug("Found {} entries for userId = {}", (Object)entries.size(), (Object)uid);
        return entries;
    }

    public List<JansCustomPerson> getPersonsByEmail(String mail, String ... returnAttributes) {
        this.log.debug("Getting user information from DB: mail = {}", (Object)mail);
        if (StringHelper.isEmpty((String)mail)) {
            return null;
        }
        Filter userMailFilter = Filter.createEqualityFilter((Filter)Filter.createLowercaseFilter((String)"mail"), (Object)StringHelper.toLowerCase((String)mail));
        boolean multiValued = false;
        JansAttribute mailAttribute = this.attributeService.getAttributeByName("mail");
        if (mailAttribute != null && mailAttribute.getOxMultiValuedAttribute() != null && mailAttribute.getOxMultiValuedAttribute().booleanValue()) {
            multiValued = true;
        }
        userMailFilter.multiValued(Boolean.valueOf(multiValued));
        List entries = this.persistenceEntryManager.findEntries(this.getDnForPerson(null), JansCustomPerson.class, userMailFilter, returnAttributes);
        this.log.debug("Found {} entries for mail = {}", (Object)entries.size(), (Object)mail);
        return entries;
    }

    public JansCustomPerson getPersonByAttribute(String attribute, String value) throws Exception {
        JansCustomPerson person = new JansCustomPerson();
        person.setBaseDn(this.getDnForPerson(null));
        person.setAttribute(attribute, value);
        List persons = this.persistenceEntryManager.findEntries((Object)person);
        if (persons != null && persons.size() > 0) {
            return (JansCustomPerson)persons.get(0);
        }
        return null;
    }

    public User getUserByUid(String uid) {
        Filter userUidFilter = Filter.createEqualityFilter((Filter)Filter.createLowercaseFilter((String)"uid"), (Object)StringHelper.toLowerCase((String)uid));
        Filter userObjectClassFilter = Filter.createEqualityFilter((String)"objectClass", (Object)"gluuPerson");
        Filter filter = Filter.createANDFilter((Filter[])new Filter[]{userObjectClassFilter, userUidFilter});
        List users = this.persistenceEntryManager.findEntries(this.getDnForPerson(null), SimpleUser.class, filter, 1);
        if (users != null && users.size() > 0) {
            return (User)this.persistenceEntryManager.find(User.class, (Object)((SimpleUser)users.get(0)).getDn());
        }
        return null;
    }

    public List<JansCustomPerson> getPersonsByAttribute(String attribute, String value) throws Exception {
        JansCustomPerson person = new JansCustomPerson();
        person.setBaseDn(this.getDnForPerson(null));
        person.setAttribute(attribute, value);
        List persons = this.persistenceEntryManager.findEntries((Object)person);
        if (persons != null && persons.size() > 0) {
            return persons;
        }
        return null;
    }
}

