/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim.service.filter;

import io.jans.scim.auth.IProtectionService;
import io.jans.scim.auth.JansRestService;
import io.jans.scim.auth.ProtectionServiceSelector;
import io.jans.scim.service.filter.ProtectedApi;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import org.slf4j.Logger;

@Provider
@ProtectedApi
@Priority(value=1000)
@RequestScoped
public class AuthorizationProcessingFilter
implements ContainerRequestFilter {
    @Inject
    private Logger log;
    @Context
    private HttpHeaders httpHeaders;
    @Context
    private ResourceInfo resourceInfo;
    @Inject
    private ProtectionServiceSelector beanSelector;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        Response authorizationResponse = null;
        String path = requestContext.getUriInfo().getPath();
        this.log.debug("REST call to '{}' intercepted", (Object)path);
        JansRestService api = this.beanSelector.select(path);
        if (api == null) {
            this.log.warn("No REST service bean associated to this path (resource will be accessed anonymously)");
        } else if (!api.isEnabled()) {
            this.log.warn("Please activate {} API", (Object)api.getName());
            authorizationResponse = this.disabledApiResponse(api.getName());
        } else {
            IProtectionService protectionService = api.getProtectionService();
            if (protectionService == null) {
                this.log.warn("No concrete protection mechanism associated to this API. Denying access");
                authorizationResponse = this.unprotectedApiResponse(api.getName());
            } else {
                this.log.debug("Path is protected, proceeding with authorization processing...");
                authorizationResponse = protectionService.processAuthorization(this.httpHeaders, this.resourceInfo);
                if (authorizationResponse == null) {
                    this.log.debug("Authorization passed");
                }
            }
        }
        if (authorizationResponse != null) {
            requestContext.abortWith(authorizationResponse);
        }
    }

    private Response unprotectedApiResponse(String name) {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)(name + " API not protected")).build();
    }

    private Response disabledApiResponse(String name) {
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)(name + " API is disabled")).build();
    }
}

