/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim.auth;

import io.jans.scim.auth.BindingUrls;
import io.jans.scim.auth.IProtectionService;
import io.jans.scim.auth.JansRestService;
import io.jans.scim.auth.none.NoProtectionService;
import io.jans.scim.auth.oauth.DefaultOAuthProtectionService;
import io.jans.scim.model.conf.AppConfiguration;
import io.jans.scim.model.conf.ScimMode;
import io.jans.scim.service.ConfigurationService;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Optional;
import org.slf4j.Logger;

@ApplicationScoped
@BindingUrls(value={"/"})
public class ScimService
implements JansRestService {
    @Inject
    private Logger log;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private DefaultOAuthProtectionService oauthProtectionService;
    @Inject
    private NoProtectionService noProtectionService;

    @Override
    public String getName() {
        return "SCIM";
    }

    @Override
    public boolean isEnabled() {
        boolean enabled = this.configurationService.getConfiguration().isScimEnabled();
        if (!enabled) {
            this.log.debug("SCIM API is disabled.");
        }
        return enabled;
    }

    @Override
    public IProtectionService getProtectionService() {
        ScimMode mode = Optional.ofNullable(this.appConfiguration.getProtectionMode()).orElse(ScimMode.OAUTH);
        this.log.debug("SCIM protection mode is: {}", (Object)mode);
        switch (mode) {
            case OAUTH: {
                return this.oauthProtectionService;
            }
            case BYPASS: {
                return this.noProtectionService;
            }
        }
        return null;
    }
}

