/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim.auth;

import io.jans.scim.auth.BindingUrls;
import io.jans.scim.auth.JansRestService;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;

@ApplicationScoped
public class ProtectionServiceSelector {
    @Inject
    private Logger log;
    @Inject
    private BeanManager beanManager;
    @Inject
    private Instance<JansRestService> jansRestServiceInstance;
    private Map<String, Class<JansRestService>> mapping;

    public JansRestService select(String path) {
        return this.mapping.keySet().stream().filter(path::startsWith).findFirst().map(this.mapping::get).map(x$0 -> this.jansRestServiceInstance.select(x$0, new Annotation[0])).map(Provider::get).orElse(null);
    }

    @PostConstruct
    private void init() {
        this.mapping = new HashMap<String, Class<JansRestService>>();
        Set beans = this.beanManager.getBeans(JansRestService.class, new Annotation[]{Any.Literal.INSTANCE});
        for (Bean bean : beans) {
            Class beanClass = bean.getBeanClass();
            Optional.ofNullable(beanClass.getAnnotation(BindingUrls.class)).map(BindingUrls.class::cast).map(BindingUrls::value).map(Arrays::asList).orElse(Collections.emptyList()).forEach(pattern -> {
                if (pattern.length() > 0) {
                    this.mapping.put((String)pattern, beanClass);
                }
            });
        }
    }
}

