/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim.service;

import io.jans.model.SmtpConfiguration;
import io.jans.orm.PersistenceEntryManagerFactory;
import io.jans.orm.model.PersistenceConfiguration;
import io.jans.orm.service.PersistanceFactoryService;
import io.jans.scim.model.conf.AppConfiguration;
import io.jans.scim.service.ConfigurationFactory;
import io.jans.scim.service.ConfigurationService;
import io.jans.service.cache.CacheConfiguration;
import io.jans.service.cache.InMemoryConfiguration;
import io.jans.service.document.store.conf.DocumentStoreConfiguration;
import io.jans.service.document.store.conf.LocalDocumentStoreConfiguration;
import io.jans.service.message.model.config.MessageConfiguration;
import io.jans.service.message.model.config.MessageProviderType;
import io.jans.service.message.model.config.NullMessageConfiguration;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import org.slf4j.Logger;

@ApplicationScoped
public class ApplicationFactory {
    @Inject
    private Logger log;
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private PersistanceFactoryService persistanceFactoryService;
    @Inject
    private AppConfiguration appConfiguration;
    public static final String PERSISTENCE_ENTRY_MANAGER_FACTORY_NAME = "persistenceEntryManagerFactory";
    public static final String PERSISTENCE_ENTRY_MANAGER_NAME = "persistenceEntryManager";
    public static final String PERSISTENCE_METRIC_ENTRY_MANAGER_NAME = "persistenceMetricEntryManager";
    public static final String PERSISTENCE_CENTRAL_ENTRY_MANAGER_NAME = "centralPersistenceEntryManager";
    public static final String PERSISTENCE_METRIC_CONFIG_GROUP_NAME = "metric";

    @Produces
    @ApplicationScoped
    public CacheConfiguration getCacheConfiguration() {
        CacheConfiguration cacheConfiguration = this.configurationService.getConfiguration().getCacheConfiguration();
        if (cacheConfiguration == null || cacheConfiguration.getCacheProviderType() == null) {
            this.log.error("Failed to read cache configuration from DB. Please check configuration jsCacheConf attribute that must contain cache configuration JSON represented by CacheConfiguration.class. Appliance DN: " + this.configurationService.getConfiguration().getDn());
            this.log.info("Creating fallback IN-MEMORY cache configuration ... ");
            cacheConfiguration = new CacheConfiguration();
            cacheConfiguration.setInMemoryConfiguration(new InMemoryConfiguration());
            this.log.info("IN-MEMORY cache configuration is created.");
        } else if (cacheConfiguration.getNativePersistenceConfiguration() != null) {
            cacheConfiguration.getNativePersistenceConfiguration().setBaseDn(this.appConfiguration.getBaseDN());
        }
        this.log.info("Cache configuration: " + cacheConfiguration);
        return cacheConfiguration;
    }

    @Produces
    @ApplicationScoped
    public MessageConfiguration getMessageConfiguration() {
        MessageConfiguration messageConfiguration = this.configurationService.getConfiguration().getMessageConfiguration();
        if (messageConfiguration == null || messageConfiguration.getMessageProviderType() == null) {
            this.log.error("Failed to read message configuration from DB. Please check configuration jsMessageConf attribute that must contain message configuration JSON represented by MessageConfiguration.class. Appliance DN: " + this.configurationService.getConfiguration().getDn());
            this.log.info("Creating fallback Null message configuration ... ");
            messageConfiguration = new MessageConfiguration();
            messageConfiguration.setMessageProviderType(MessageProviderType.DISABLED);
            messageConfiguration.setNullConfiguration(new NullMessageConfiguration());
            this.log.info("NULL message configuration is created.");
        }
        this.log.info("Message configuration: " + messageConfiguration);
        return messageConfiguration;
    }

    @Produces
    @ApplicationScoped
    public DocumentStoreConfiguration getDocumentStoreConfiguration() {
        DocumentStoreConfiguration documentStoreConfiguration = this.configurationService.getConfiguration().getDocumentStoreConfiguration();
        if (documentStoreConfiguration == null || documentStoreConfiguration.getDocumentStoreType() == null) {
            this.log.error("Failed to read document store configuration from DB. Please check configuration jsDocStoreConf attribute that must contain document store configuration JSON represented by DocumentStoreConfiguration.class. Appliance DN: " + this.configurationService.getConfiguration().getDn());
            this.log.info("Creating fallback LOCAL document store configuration ... ");
            documentStoreConfiguration = new DocumentStoreConfiguration();
            documentStoreConfiguration.setLocalConfiguration(new LocalDocumentStoreConfiguration());
            this.log.info("LOCAL document store configuration is created.");
        }
        this.log.info("Document store configuration: " + documentStoreConfiguration);
        return documentStoreConfiguration;
    }

    @Produces
    @RequestScoped
    public SmtpConfiguration getSmtpConfiguration() {
        SmtpConfiguration smtpConfiguration = this.configurationService.getConfiguration().getSmtpConfiguration();
        if (smtpConfiguration == null) {
            return new SmtpConfiguration();
        }
        this.configurationService.decryptSmtpPasswords(smtpConfiguration);
        return smtpConfiguration;
    }

    public PersistenceEntryManagerFactory getPersistenceEntryManagerFactory() {
        PersistenceConfiguration persistenceConfiguration = this.configurationFactory.getPersistenceConfiguration();
        return this.persistanceFactoryService.getPersistenceEntryManagerFactory(persistenceConfiguration);
    }

    public PersistenceEntryManagerFactory getPersistenceEntryManagerFactory(PersistenceConfiguration persistenceConfiguration) {
        return this.persistanceFactoryService.getPersistenceEntryManagerFactory(persistenceConfiguration);
    }

    public PersistenceEntryManagerFactory getPersistenceEntryManagerFactory(Class<? extends PersistenceEntryManagerFactory> persistenceEntryManagerFactoryClass) {
        return this.persistanceFactoryService.getPersistenceEntryManagerFactory(persistenceEntryManagerFactoryClass);
    }
}

