/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim.service;

import io.jans.model.JansAttribute;
import io.jans.orm.model.base.CustomObjectAttribute;
import io.jans.scim.model.JansCustomAttribute;
import io.jans.scim.model.conf.AppConfiguration;
import io.jans.scim.service.OrganizationService;
import io.jans.scim.service.cdi.event.Events;
import io.jans.service.BaseCacheService;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Any;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@ApplicationScoped
public class AttributeService
extends io.jans.service.AttributeService {
    private static final long serialVersionUID = 8223624816948822765L;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private OrganizationService organizationService;
    @Inject
    @Any
    private Event<Events> event;

    public List<JansAttribute> getSCIMRelatedAttributes() throws Exception {
        List attributes = this.getAllAttributes();
        ArrayList<JansAttribute> result = new ArrayList<JansAttribute>();
        for (JansAttribute attribute : attributes) {
            boolean isEmpty = attribute.getScimCustomAttr() == null;
            if (isEmpty || attribute.getScimCustomAttr() == null || !attribute.getScimCustomAttr().booleanValue()) continue;
            result.add(attribute);
        }
        return result;
    }

    public String getDnForAttribute(String inum) {
        String organizationDn = this.organizationService.getDnForOrganization();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=attributes,%s", organizationDn);
        }
        return String.format("inum=%s,ou=attributes,%s", inum, organizationDn);
    }

    public String getCustomOrigin() {
        return this.appConfiguration.getPersonCustomObjectClass();
    }

    protected List<JansAttribute> getAllAtributesImpl(String baseDn) {
        List attributeList = this.persistenceEntryManager.findEntries(baseDn, JansAttribute.class, null);
        String customOrigin = this.getCustomOrigin();
        for (JansAttribute attribute : attributeList) {
            attribute.setCustom(customOrigin.equals(attribute.getOrigin()));
        }
        return attributeList;
    }

    protected BaseCacheService getCacheService() {
        return this.cacheService;
    }

    public void applyMetaData(List<JansCustomAttribute> customAttributes) {
        if (customAttributes == null || customAttributes.size() == 0) {
            return;
        }
        Map allAttributesMap = this.getAllAttributesMap();
        for (JansCustomAttribute customAttribute : customAttributes) {
            String attributeName = StringHelper.toLowerCase((String)customAttribute.getName());
            JansAttribute attribute = (JansAttribute)allAttributesMap.get(attributeName);
            if (attribute == null) continue;
            customAttribute.setMetadata(attribute);
        }
    }

    public void applyMultiValued(List<CustomObjectAttribute> customAttributes) {
        if (customAttributes == null || customAttributes.size() == 0) {
            return;
        }
        Map allAttributesMap = this.getAllAttributesMap();
        for (CustomObjectAttribute customAttribute : customAttributes) {
            String attributeName = StringHelper.toLowerCase((String)customAttribute.getName());
            JansAttribute attribute = (JansAttribute)allAttributesMap.get(attributeName);
            if (attribute == null) continue;
            boolean multiValued = Boolean.TRUE.equals(attribute.getOxMultiValuedAttribute());
            customAttribute.setMultiValued(multiValued);
        }
    }
}

