/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim.service;

import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.id.IdGeneratorType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Named;
import java.util.Map;

@ApplicationScoped
@Named(value="externalIdGeneratorService")
public class ExternalIdGeneratorService
extends ExternalScriptService {
    private static final long serialVersionUID = 1727751544454591273L;

    public ExternalIdGeneratorService() {
        super(CustomScriptType.ID_GENERATOR);
    }

    public String executeExternalGenerateIdMethod(CustomScriptConfiguration customScriptConfiguration, String appId, String idType, String idPrefix) {
        try {
            this.log.debug("Executing python 'generateId' method");
            IdGeneratorType externalType = (IdGeneratorType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return externalType.generateId(appId, idType, idPrefix, configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return null;
        }
    }

    public String executeExternalDefaultGenerateIdMethod(String appId, String idType, String idPrefix) {
        return this.executeExternalGenerateIdMethod(this.defaultExternalCustomScript, appId, idType, idPrefix);
    }
}

