/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim.service;

import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.exception.EntryPersistenceException;
import io.jans.orm.exception.operation.SearchException;
import io.jans.orm.model.fido2.Fido2RegistrationEntry;
import io.jans.orm.search.filter.Filter;
import io.jans.scim.model.JansCustomPerson;
import io.jans.scim.service.OrganizationService;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class Fido2DeviceService
implements Serializable {
    private static final long serialVersionUID = 5874835162873627676L;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private OrganizationService organizationService;

    public boolean removeFido2(JansCustomPerson person, String deviceID) {
        try {
            String finalDn = String.format("jansId=%s,ou=fido2_register,", deviceID);
            finalDn = finalDn.concat(person.getDn());
            this.ldapEntryManager.removeRecursively(finalDn, Fido2RegistrationEntry.class);
            return true;
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
            return false;
        }
    }

    public String getDnForFido2Device(String oxid, String personInum) {
        String orgDn = this.organizationService.getDnForOrganization();
        if (!StringHelper.isEmpty((String)personInum) && StringHelper.isEmpty((String)oxid)) {
            return String.format("ou=fido2_register,inum=%s,ou=people,%s", personInum, orgDn);
        }
        if (!StringHelper.isEmpty((String)oxid) && !StringHelper.isEmpty((String)personInum)) {
            return String.format("jansId=%s,ou=fido2_register,inum=%s,ou=people,%s", oxid, personInum, orgDn);
        }
        return String.format("ou=people,%s", orgDn);
    }

    public List<Fido2RegistrationEntry> findAllFido2Devices(JansCustomPerson person) {
        try {
            String baseDnForU2fDevices = this.getDnForFido2Device(null, person.getInum());
            Filter inumFilter = Filter.createEqualityFilter((String)"personInum", (Object)person.getInum());
            return this.ldapEntryManager.findEntries(baseDnForU2fDevices, Fido2RegistrationEntry.class, inumFilter);
        }
        catch (EntryPersistenceException e) {
            this.log.warn("No fido2 devices enrolled for " + person.getDisplayName());
            return new ArrayList<Fido2RegistrationEntry>();
        }
    }

    public Fido2RegistrationEntry getFido2DeviceById(String userId, String id) throws Exception {
        Fido2RegistrationEntry f2d = null;
        try {
            String dn = this.getDnForFido2Device(id, userId);
            if (StringUtils.isNotEmpty((CharSequence)userId)) {
                f2d = (Fido2RegistrationEntry)this.ldapEntryManager.find(Fido2RegistrationEntry.class, (Object)dn);
            } else {
                Filter filter = Filter.createEqualityFilter((String)"jansId", (Object)id);
                f2d = (Fido2RegistrationEntry)this.ldapEntryManager.findEntries(dn, Fido2RegistrationEntry.class, filter).get(0);
            }
        }
        catch (Exception e) {
            if (!SearchException.class.isInstance(e.getCause())) {
                this.log.error(e.getMessage(), e.getCause());
                throw e;
            }
            this.log.debug("Failed to find Fido 2 device with id {}", (Object)id);
        }
        return f2d;
    }

    public void updateFido2Device(Fido2RegistrationEntry fido2Device) {
        this.ldapEntryManager.merge((Object)fido2Device);
    }

    public void removeFido2Device(Fido2RegistrationEntry fido2Device) {
        this.ldapEntryManager.removeRecursively(fido2Device.getDn(), Fido2RegistrationEntry.class);
    }

    public Fido2RegistrationEntry getJansCustomFidoDeviceById(String id, String userId) {
        Fido2RegistrationEntry gluuCustomFidoDevice = null;
        try {
            String dn = this.getDnForFido2Device(id, userId);
            if (StringUtils.isNotEmpty((CharSequence)userId)) {
                gluuCustomFidoDevice = (Fido2RegistrationEntry)this.ldapEntryManager.find(Fido2RegistrationEntry.class, (Object)dn);
            } else {
                Filter filter = Filter.createEqualityFilter((String)"jansId", (Object)id);
                gluuCustomFidoDevice = (Fido2RegistrationEntry)this.ldapEntryManager.findEntries(dn, Fido2RegistrationEntry.class, filter).get(0);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to find device by id " + id, (Throwable)e);
        }
        return gluuCustomFidoDevice;
    }
}

