/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim.service;

import io.jans.as.model.common.IdType;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.exception.EntryPersistenceException;
import io.jans.orm.exception.operation.DuplicateEntryException;
import io.jans.orm.exception.operation.SearchException;
import io.jans.orm.model.SearchScope;
import io.jans.orm.model.base.SimpleBranch;
import io.jans.orm.search.filter.Filter;
import io.jans.scim.model.JansCustomPerson;
import io.jans.scim.model.JansGroup;
import io.jans.scim.service.ExternalIdGeneratorService;
import io.jans.scim.service.OrganizationService;
import io.jans.scim.service.PersonService;
import io.jans.util.ArrayHelper;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;

@ApplicationScoped
public class GroupService
implements Serializable {
    private static final long serialVersionUID = -9167587377957719152L;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private OrganizationService organizationService;
    @Inject
    private PersonService personService;
    @Inject
    private ExternalIdGeneratorService idGeneratorService;

    public void addGroup(JansGroup group) throws Exception {
        JansGroup displayNameGroup = new JansGroup();
        displayNameGroup.setDisplayName(group.getDisplayName());
        List<JansGroup> groups = this.findGroups(displayNameGroup, 1);
        if (groups != null && groups.size() != 0) {
            throw new DuplicateEntryException("Duplicate displayName: " + group.getDisplayName());
        }
        this.persistenceEntryManager.persist((Object)group);
    }

    public void updateGroup(JansGroup group) {
        this.persistenceEntryManager.merge((Object)group);
    }

    public void removeGroup(JansGroup group) {
        if (group.getMembers() != null) {
            List<String> memberDNs = group.getMembers();
            for (String memberDN : memberDNs) {
                if (!this.personService.contains(memberDN)) continue;
                JansCustomPerson person = this.personService.getPersonByDn(memberDN);
                List<String> groupDNs = person.getMemberOf();
                ArrayList<String> updatedGroupDNs = new ArrayList<String>();
                updatedGroupDNs.addAll(groupDNs);
                updatedGroupDNs.remove(group.getDn());
                person.setMemberOf(updatedGroupDNs);
                try {
                    this.personService.updatePerson(person);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.persistenceEntryManager.remove((Object)group);
    }

    public List<JansGroup> getAllGroups() {
        return this.persistenceEntryManager.findEntries(this.getDnForGroup(null), JansGroup.class, null);
    }

    public boolean isMemberOrOwner(String groupDN, String personDN) {
        Filter ownerFilter = Filter.createEqualityFilter((String)"owner", (Object)personDN);
        Filter memberFilter = Filter.createEqualityFilter((String)"member", (Object)personDN);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{ownerFilter, memberFilter});
        boolean isMemberOrOwner = false;
        try {
            isMemberOrOwner = this.persistenceEntryManager.findEntries(groupDN, JansGroup.class, searchFilter, 1).size() > 0;
        }
        catch (EntryPersistenceException ex) {
            this.log.error("Failed to determine if person '{}' memeber or owner of group '{}'", new Object[]{personDN, groupDN, ex});
        }
        return isMemberOrOwner;
    }

    public JansGroup getGroupByInum(String inum) throws Exception {
        JansGroup result = null;
        try {
            result = (JansGroup)this.persistenceEntryManager.find(JansGroup.class, (Object)this.getDnForGroup(inum));
        }
        catch (Exception e) {
            if (!SearchException.class.isInstance(e.getCause())) {
                this.log.error(e.getMessage(), e.getCause());
                throw e;
            }
            this.log.debug("Failed to find group by Inum {}", (Object)inum);
        }
        return result;
    }

    public String getDnForGroup(String inum) {
        String orgDn = this.organizationService.getDnForOrganization();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=groups,%s", orgDn);
        }
        return String.format("inum=%s,ou=groups,%s", inum, orgDn);
    }

    public int countGroups() {
        String dn = this.getDnForGroup(null);
        Class<JansGroup> searchClass = JansGroup.class;
        if (this.persistenceEntryManager.hasBranchesSupport(dn)) {
            searchClass = SimpleBranch.class;
        }
        return this.persistenceEntryManager.countEntries(dn, searchClass, null, SearchScope.BASE);
    }

    public boolean contains(String groupDn) {
        return this.persistenceEntryManager.contains(groupDn, JansCustomPerson.class);
    }

    public String generateInumForNewGroup() throws Exception {
        JansGroup group = new JansGroup();
        String newInum = null;
        String newDn = null;
        do {
            newInum = this.generateInumForNewGroupImpl();
            newDn = this.getDnForGroup(newInum);
            group.setDn(newDn);
        } while (this.persistenceEntryManager.contains(newDn, JansCustomPerson.class));
        return newInum;
    }

    public List<JansGroup> searchGroups(String pattern, int sizeLimit) throws Exception {
        String[] targetArray = new String[]{pattern};
        Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
        Filter descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, descriptionFilter});
        return this.persistenceEntryManager.findEntries(this.getDnForGroup(null), JansGroup.class, searchFilter, sizeLimit);
    }

    public List<JansGroup> getAllGroups(int sizeLimit) {
        return this.persistenceEntryManager.findEntries(this.getDnForGroup(null), JansGroup.class, null, sizeLimit);
    }

    private String generateInumForNewGroupImpl() throws Exception {
        String id = null;
        if (this.idGeneratorService.isEnabled()) {
            id = this.idGeneratorService.executeExternalGenerateIdMethod(this.idGeneratorService.getCustomScriptConfigurations().stream().findFirst().orElse(null), "", IdType.GROUP.getType(), "");
        }
        return id == null ? UUID.randomUUID().toString() : id;
    }

    public JansGroup getGroupByDn(String Dn) {
        return (JansGroup)this.persistenceEntryManager.find(JansGroup.class, (Object)Dn);
    }

    public JansGroup getGroupByDisplayName(String DisplayName) throws Exception {
        JansGroup group = new JansGroup();
        group.setBaseDn(this.getDnForGroup(null));
        group.setDisplayName(DisplayName);
        List groups = this.persistenceEntryManager.findEntries((Object)group);
        if (groups != null && groups.size() > 0) {
            return (JansGroup)groups.get(0);
        }
        return null;
    }

    public List<JansGroup> findGroups(JansGroup group, int sizeLimit) {
        group.setBaseDn(this.getDnForGroup(null));
        return this.persistenceEntryManager.findEntries((Object)group, sizeLimit);
    }

    public boolean isMemberOrOwner(String[] groupDNs, String personDN) throws Exception {
        boolean result = false;
        if (ArrayHelper.isEmpty((Object[])groupDNs)) {
            return result;
        }
        for (String groupDN : groupDNs) {
            if (!StringHelper.isEmpty((String)groupDN) && (result = this.isMemberOrOwner(groupDN, personDN))) break;
        }
        return result;
    }
}

