/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim.auth.oauth;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.as.client.OpenIdConfigurationResponse;
import io.jans.as.client.service.ClientFactory;
import io.jans.as.client.service.IntrospectionService;
import io.jans.as.model.common.IntrospectionResponse;
import io.jans.as.model.crypto.AuthCryptoProvider;
import io.jans.as.model.crypto.signature.AlgorithmFamily;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.jwt.JwtClaims;
import io.jans.scim.auth.IProtectionService;
import io.jans.scim.service.OpenIdService;
import io.jans.scim.service.filter.ProtectedApi;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.json.JSONObject;
import org.slf4j.Logger;

public abstract class BaseOAuthProtectionService
implements IProtectionService,
Serializable {
    private static final long serialVersionUID = -1147131971095460010L;
    @Inject
    private Logger log;
    @Inject
    private OpenIdService openIdService;
    private IntrospectionService introspectionService;
    private OpenIdConfigurationResponse oidcConfig;
    private ObjectMapper mapper;

    protected abstract Response processIntrospectionResponse(IntrospectionResponse var1, List<String> var2);

    @Override
    public Response processAuthorization(HttpHeaders headers, ResourceInfo resourceInfo) {
        try {
            String token = headers.getHeaderString("Authorization");
            boolean authFound = StringUtils.isNotEmpty((CharSequence)token);
            this.log.info("Authorization header {} found", (Object)(authFound ? "" : "not"));
            if (!authFound) {
                this.log.info("Request is missing authorization header");
                return IProtectionService.simpleResponse(Response.Status.UNAUTHORIZED, "No authorization header found");
            }
            token = token.replaceFirst("Bearer\\s+", "");
            this.log.debug("Validating token {}", (Object)token);
            List<String> scopes = this.getRequestedScopes(resourceInfo);
            this.log.info("Call requires scopes: {}", scopes);
            Jwt jwt = this.tokenAsJwt(token);
            if (jwt == null) {
                IntrospectionResponse iresp = null;
                try {
                    iresp = this.introspectionService.introspectToken("Bearer " + token, token);
                }
                catch (Exception e) {
                    this.log.error(e.getMessage());
                }
                return this.processIntrospectionResponse(iresp, scopes);
            }
            JwtClaims claims = jwt.getClaims();
            if (!this.oidcConfig.getIssuer().equals(claims.getClaimAsString("iss"))) {
                return IProtectionService.simpleResponse(Response.Status.FORBIDDEN, "Invalid token issuer");
            }
            int exp = Optional.ofNullable(claims.getClaimAsInteger("exp")).orElse(0);
            if (1000L * (long)exp < System.currentTimeMillis()) {
                return IProtectionService.simpleResponse(Response.Status.FORBIDDEN, "Expired token");
            }
            Map jwks = (Map)this.mapper.readValue(new URL(this.oidcConfig.getJwksUri()), Map.class);
            List tokenScopes = claims.getClaimAsStringList("scope");
            AuthCryptoProvider cryptoProvider = new AuthCryptoProvider(null, null, null, true);
            SignatureAlgorithm signatureAlg = jwt.getHeader().getSignatureAlgorithm();
            if (AlgorithmFamily.HMAC.equals((Object)signatureAlg.getFamily())) {
                return IProtectionService.simpleResponse(Response.Status.INTERNAL_SERVER_ERROR, "HMAC algorithm not allowed for token signature. Please use an algorithm in the EC, ED, or RSA family for signing");
            }
            boolean valid = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), jwt.getHeader().getKeyId(), new JSONObject(jwks), null, signatureAlg);
            if (valid && tokenScopes.containsAll(scopes)) {
                return null;
            }
            String msg = "Invalid token signature or insufficient scopes";
            this.log.error("{}. Token scopes: {}", (Object)msg, (Object)tokenScopes);
            return IProtectionService.simpleResponse(Response.Status.FORBIDDEN, msg);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return IProtectionService.simpleResponse(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    private Jwt tokenAsJwt(String token) {
        Jwt jwt = null;
        try {
            jwt = Jwt.parse((String)token);
            this.log.trace("This looks like a JWT token");
        }
        catch (InvalidJwtException e) {
            this.log.trace("Not a JWT token");
        }
        return jwt;
    }

    private List<String> getRequestedScopes(ResourceInfo resourceInfo) {
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.addAll(this.getScopesFromAnnotation(resourceInfo.getResourceClass()));
        scopes.addAll(this.getScopesFromAnnotation(resourceInfo.getResourceMethod()));
        return scopes;
    }

    private List<String> getScopesFromAnnotation(AnnotatedElement elem) {
        return BaseOAuthProtectionService.optAnnnotation(elem, ProtectedApi.class).map(ProtectedApi::scopes).map(Arrays::asList).orElse(Collections.emptyList());
    }

    private static <T extends Annotation> Optional<T> optAnnnotation(AnnotatedElement elem, Class<T> cls) {
        return Optional.ofNullable(elem.getAnnotation(cls));
    }

    @PostConstruct
    private void init() {
        try {
            this.mapper = new ObjectMapper();
            this.oidcConfig = this.openIdService.getOpenIdConfiguration();
            String introspectionEndpoint = this.oidcConfig.getIntrospectionEndpoint();
            this.introspectionService = ClientFactory.instance().createIntrospectionService(introspectionEndpoint, (ClientHttpEngine)ClientFactory.instance().createEngine());
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }
}

