/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim.service;

import io.jans.model.AuthenticationScriptUsageType;
import io.jans.model.ProgrammingLanguage;
import io.jans.model.ScriptLocationType;
import io.jans.model.SmtpConfiguration;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.orm.PersistenceEntryManager;
import io.jans.scim.model.JansConfiguration;
import io.jans.scim.service.OrganizationService;
import io.jans.service.EncryptionService;
import io.jans.util.StringHelper;
import io.jans.util.security.StringEncrypter;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;

@ApplicationScoped
@Named(value="configurationService")
public class ConfigurationService
implements Serializable {
    private static final long serialVersionUID = 8842838732456296435L;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private OrganizationService organizationService;
    @Inject
    private EncryptionService encryptionService;
    @Inject
    private ServletContext servletContext;
    private static final SimpleDateFormat PERIOD_DATE_FORMAT = new SimpleDateFormat("yyyyMM");
    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public boolean contains(String configurationDn) {
        return this.persistenceEntryManager.contains(configurationDn, JansConfiguration.class);
    }

    public void addConfiguration(JansConfiguration configuration) {
        this.persistenceEntryManager.persist((Object)configuration);
    }

    public void updateConfiguration(JansConfiguration configuration) {
        try {
            this.persistenceEntryManager.merge((Object)configuration);
        }
        catch (Exception e) {
            this.log.info("", (Throwable)e);
        }
    }

    public boolean containsConfiguration(String dn) {
        return this.persistenceEntryManager.contains(dn, JansConfiguration.class);
    }

    public JansConfiguration getConfigurationByInum(String inum) {
        return (JansConfiguration)this.persistenceEntryManager.find(JansConfiguration.class, (Object)this.getDnForConfiguration());
    }

    public JansConfiguration getConfiguration(String[] returnAttributes) {
        JansConfiguration result = null;
        result = (JansConfiguration)this.persistenceEntryManager.find((Object)this.getDnForConfiguration(), JansConfiguration.class, returnAttributes);
        return result;
    }

    public JansConfiguration getConfiguration() {
        return this.getConfiguration(null);
    }

    public List<JansConfiguration> getConfigurations() {
        return this.persistenceEntryManager.findEntries(this.getDnForConfiguration(), JansConfiguration.class, null);
    }

    public String getDnForConfiguration() {
        String baseDn = this.organizationService.getBaseDn();
        return String.format("ou=configuration,%s", baseDn);
    }

    public AuthenticationScriptUsageType[] getScriptUsageTypes() {
        return new AuthenticationScriptUsageType[]{AuthenticationScriptUsageType.INTERACTIVE, AuthenticationScriptUsageType.SERVICE, AuthenticationScriptUsageType.BOTH};
    }

    public ProgrammingLanguage[] getProgrammingLanguages() {
        return new ProgrammingLanguage[]{ProgrammingLanguage.PYTHON};
    }

    public ScriptLocationType[] getLocationTypes() {
        return new ScriptLocationType[]{ScriptLocationType.DB};
    }

    public CustomScriptType[] getCustomScriptTypes() {
        return new CustomScriptType[]{CustomScriptType.PERSON_AUTHENTICATION, CustomScriptType.CONSENT_GATHERING, CustomScriptType.CLIENT_REGISTRATION, CustomScriptType.DYNAMIC_SCOPE, CustomScriptType.ID_GENERATOR, CustomScriptType.LINK_INTERCEPTION, CustomScriptType.UMA_RPT_POLICY, CustomScriptType.UMA_CLAIMS_GATHERING, CustomScriptType.UMA_RPT_CLAIMS, CustomScriptType.INTROSPECTION, CustomScriptType.RESOURCE_OWNER_PASSWORD_CREDENTIALS, CustomScriptType.APPLICATION_SESSION, CustomScriptType.END_SESSION, CustomScriptType.SCIM, CustomScriptType.POST_AUTHN, CustomScriptType.PERSISTENCE_EXTENSION, CustomScriptType.IDP};
    }

    public CustomScriptType[] getOthersCustomScriptTypes() {
        return new CustomScriptType[]{CustomScriptType.CONSENT_GATHERING, CustomScriptType.CLIENT_REGISTRATION, CustomScriptType.DYNAMIC_SCOPE, CustomScriptType.ID_GENERATOR, CustomScriptType.LINK_INTERCEPTION, CustomScriptType.UMA_RPT_POLICY, CustomScriptType.UMA_CLAIMS_GATHERING, CustomScriptType.UMA_RPT_CLAIMS, CustomScriptType.INTROSPECTION, CustomScriptType.RESOURCE_OWNER_PASSWORD_CREDENTIALS, CustomScriptType.APPLICATION_SESSION, CustomScriptType.END_SESSION, CustomScriptType.SCIM, CustomScriptType.POST_AUTHN, CustomScriptType.PERSISTENCE_EXTENSION, CustomScriptType.IDP, CustomScriptType.CIBA_END_USER_NOTIFICATION};
    }

    public void encryptedSmtpPasswords(SmtpConfiguration smtpConfiguration) {
        String encryptedPassword;
        if (smtpConfiguration == null) {
            return;
        }
        String password = smtpConfiguration.getSmtpAuthenticationAccountPasswordDecrypted();
        if (StringHelper.isNotEmpty((String)password)) {
            try {
                encryptedPassword = this.encryptionService.encrypt(password);
                smtpConfiguration.setSmtpAuthenticationAccountPassword(encryptedPassword);
            }
            catch (StringEncrypter.EncryptionException ex) {
                this.log.error("Failed to encrypt SMTP password", (Throwable)ex);
            }
        }
        if (StringHelper.isNotEmpty((String)(password = smtpConfiguration.getKeyStorePasswordDecrypted()))) {
            try {
                encryptedPassword = this.encryptionService.encrypt(password);
                smtpConfiguration.setKeyStorePassword(encryptedPassword);
            }
            catch (StringEncrypter.EncryptionException ex) {
                this.log.error("Failed to encrypt Kestore password", (Throwable)ex);
            }
        }
    }

    public void decryptSmtpPasswords(SmtpConfiguration smtpConfiguration) {
        if (smtpConfiguration == null) {
            return;
        }
        String password = smtpConfiguration.getSmtpAuthenticationAccountPassword();
        if (StringHelper.isNotEmpty((String)password)) {
            try {
                smtpConfiguration.setSmtpAuthenticationAccountPasswordDecrypted(this.encryptionService.decrypt(password));
            }
            catch (StringEncrypter.EncryptionException ex) {
                this.log.error("Failed to decrypt SMTP password", (Throwable)ex);
            }
        }
        if (StringHelper.isNotEmpty((String)(password = smtpConfiguration.getKeyStorePassword()))) {
            try {
                smtpConfiguration.setKeyStorePasswordDecrypted(this.encryptionService.decrypt(password));
            }
            catch (StringEncrypter.EncryptionException ex) {
                this.log.error("Failed to decrypt Kestore password", (Throwable)ex);
            }
        }
    }

    public String getVersion() {
        String version = this.getClass().getPackage().getImplementationVersion();
        if (version == null) {
            Properties prop = new Properties();
            try (InputStream is = this.servletContext.getResourceAsStream("/META-INF/MANIFEST.MF");){
                prop.load(is);
                version = prop.getProperty("Implementation-Version");
            }
            catch (IOException e) {
                this.log.error(e.toString());
            }
        }
        this.log.info("Starting App version " + version);
        if (version != null) {
            version = version.replace("-nightly", "");
            return version;
        }
        return "";
    }
}

