/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim.service;

import io.jans.as.client.OpenIdConfigurationClient;
import io.jans.as.client.OpenIdConfigurationResponse;
import io.jans.scim.model.conf.AppConfiguration;
import io.jans.util.StringHelper;
import io.jans.util.exception.ConfigurationException;
import io.jans.util.init.Initializable;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.io.Serializable;
import org.slf4j.Logger;

@ApplicationScoped
@Named(value="openIdService")
public class OpenIdService
extends Initializable
implements Serializable {
    private static final long serialVersionUID = 7875838160379126796L;
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    private OpenIdConfigurationResponse openIdConfiguration;

    protected void initInternal() {
        try {
            this.loadOpenIdConfiguration();
        }
        catch (IOException ex) {
            throw new ConfigurationException("Failed to load oxAuth configuration");
        }
    }

    private void loadOpenIdConfiguration() throws IOException {
        Object openIdProvider = this.appConfiguration.getOxAuthIssuer();
        if (StringHelper.isEmpty((String)openIdProvider)) {
            throw new ConfigurationException("OpenIdProvider Url is invalid");
        }
        OpenIdConfigurationClient openIdConfigurationClient = new OpenIdConfigurationClient((String)(openIdProvider = (String)openIdProvider + "/.well-known/openid-configuration"));
        OpenIdConfigurationResponse response = openIdConfigurationClient.execOpenIdConfiguration();
        if (response == null || response.getStatus() != 200) {
            throw new ConfigurationException("Failed to load oxAuth configuration");
        }
        this.log.info("Successfully loaded oxAuth configuration");
        this.openIdConfiguration = response;
    }

    public OpenIdConfigurationResponse getOpenIdConfiguration() {
        this.init();
        return this.openIdConfiguration;
    }
}

