/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.scim.model.JansCustomPerson;
import io.jans.scim.model.JansGroup;
import io.jans.scim.service.GroupService;
import io.jans.scim.service.PersonService;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;

@ApplicationScoped
public class ServiceUtil
implements Serializable {
    private static final long serialVersionUID = -2842459224631032594L;
    @Inject
    private PersonService personService;
    @Inject
    private GroupService groupService;
    private static final SecureRandom random = new SecureRandom();
    private static final ObjectMapper mapper = new ObjectMapper();

    public void deleteGroupFromPerson(JansGroup group, String dn) throws Exception {
        List<String> persons = group.getMembers();
        for (String onePerson : persons) {
            JansCustomPerson gluuPerson = this.personService.getPersonByDn(onePerson);
            List<String> memberOflist = gluuPerson.getMemberOf();
            ArrayList<String> tempMemberOf = new ArrayList<String>();
            for (String aMemberOf : memberOflist) {
                tempMemberOf.add(aMemberOf);
            }
            for (String oneMemberOf : tempMemberOf) {
                if (!oneMemberOf.equalsIgnoreCase(dn)) continue;
                tempMemberOf.remove(oneMemberOf);
                break;
            }
            ArrayList<String> cleanMemberOf = new ArrayList<String>();
            for (String aMemberOf : tempMemberOf) {
                cleanMemberOf.add(aMemberOf);
            }
            gluuPerson.setMemberOf(cleanMemberOf);
            this.personService.updatePerson(gluuPerson);
        }
    }

    public String iterableToString(Iterable<?> list) {
        if (list == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : list) {
            sb.append(item);
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public void personMembersAdder(JansGroup gluuGroup, String dn) throws Exception {
        List<String> members = gluuGroup.getMembers();
        for (String member : members) {
            JansCustomPerson gluuPerson = this.personService.getPersonByDn(member);
            List<String> groups = gluuPerson.getMemberOf();
            if (this.isMemberOfExist(groups, dn)) continue;
            ArrayList<String> cleanGroups = new ArrayList<String>();
            cleanGroups.add(dn);
            for (String aGroup : groups) {
                cleanGroups.add(aGroup);
            }
            gluuPerson.setMemberOf(cleanGroups);
            this.personService.updatePerson(gluuPerson);
        }
    }

    private boolean isMemberOfExist(List<String> groups, String dn) {
        for (String group : groups) {
            if (!group.equalsIgnoreCase(dn)) continue;
            return true;
        }
        return false;
    }

    public void groupMembersAdder(JansCustomPerson gluuPerson, String dn) throws Exception {
        List<String> groups = gluuPerson.getMemberOf();
        for (String group : groups) {
            JansGroup oneGroup = this.groupService.getGroupByDn(group);
            List<String> groupMembers = oneGroup.getMembers();
            if (groupMembers == null || groupMembers.isEmpty() || this.isMemberExist(groupMembers, dn)) continue;
            ArrayList<String> cleanGroupMembers = new ArrayList<String>();
            cleanGroupMembers.add(dn);
            for (String personDN : groupMembers) {
                cleanGroupMembers.add(personDN);
            }
            oneGroup.setMembers(cleanGroupMembers);
            this.groupService.updateGroup(oneGroup);
        }
    }

    private boolean isMemberExist(List<String> groupMembers, String dn) {
        for (String member : groupMembers) {
            if (!member.equalsIgnoreCase(dn)) continue;
            return true;
        }
        return false;
    }

    public static String saveRandomFile(byte[] array, String baseDir, String extension) throws IOException {
        String filepath = baseDir + File.separator + Math.abs(random.nextLong()) + "." + extension;
        File dir = new File(baseDir);
        if (!dir.exists()) {
            dir.mkdirs();
        } else if (!dir.isDirectory()) {
            throw new IllegalArgumentException("parameter baseDir should be directory. The value: " + baseDir);
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(array);
             FileOutputStream out = new FileOutputStream(filepath);){
            int b;
            while ((b = ((InputStream)in).read()) != -1) {
                out.write(b);
            }
        }
        return filepath;
    }

    public static ObjectMapper getObjectMapper() {
        return mapper;
    }

    public static byte[] readFully(InputStream is) throws IOException {
        try {
            byte[] byArray;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                byte[] buffer = new byte[2048];
                int read = 0;
                while ((read = is.read(buffer)) != -1) {
                    baos.write(buffer, 0, read);
                }
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    static {
        mapper.disable(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

