/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.operator.bc;

import java.io.IOException;
import org.python.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.python.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.python.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.python.bouncycastle.crypto.Signer;
import org.python.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.python.bouncycastle.crypto.signers.Ed25519Signer;
import org.python.bouncycastle.crypto.signers.Ed448Signer;
import org.python.bouncycastle.crypto.util.PublicKeyFactory;
import org.python.bouncycastle.operator.OperatorCreationException;
import org.python.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;

public class BcEdDSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    public static final byte[] DEFAULT_CONTEXT = new byte[0];

    @Override
    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        if (algorithmIdentifier.getAlgorithm().equals(EdECObjectIdentifiers.id_Ed448)) {
            return new Ed448Signer(DEFAULT_CONTEXT);
        }
        return new Ed25519Signer();
    }

    @Override
    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }
}

